<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Customer;
use App\Services\CreditScoreService;

class BackfillCreditScoreRecords extends Command
{
    protected $signature = 'credit-scores:backfill-records';
    protected $description = 'Backfill credit score records for existing customers without them';

    public function handle()
    {
        $customers = Customer::whereDoesntHave('creditScores')->get();
        
        $this->info("Backfilling credit score records for {$customers->count()} customers...");
        
        if ($customers->count() === 0) {
            $this->info("No customers need credit score records backfill.");
            return;
        }
        
        $bar = $this->output->createProgressBar($customers->count());
        $successCount = 0;
        $failCount = 0;
        
        foreach ($customers as $customer) {
            try {
                app(CreditScoreService::class)->initializeCreditScore($customer->id);
                $successCount++;
            } catch (\Exception $e) {
                $this->error("Failed for customer {$customer->id}: " . $e->getMessage());
                $failCount++;
            }
            $bar->advance();
        }
        
        $bar->finish();
        $this->info("\nBackfill completed!");
        $this->info("Success: {$successCount}, Failed: {$failCount}");
    }
}