<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\PaymentSchedule;
use Carbon\Carbon;

class CheckOverduePayments extends Command
{
    protected $signature = 'payments:check-overdue';
    protected $description = 'Check and update overdue payment schedules';

    public function handle()
    {
        $overdueSchedules = PaymentSchedule::where('paymentdate', '<', Carbon::today())
            ->where('status', 'scheduled')
            ->get();

        foreach ($overdueSchedules as $schedule) {
            $schedule->update([
                'status' => 'overdue',
                'updatedby' => 1, // System user
                'updatedon' => now(),
            ]);
        }

        $this->info("Updated {$overdueSchedules->count()} payments to overdue status.");
        
        return Command::SUCCESS;
    }
}