<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\PaymentReminderService;

class ProcessPaymentReminders extends Command
{
    // This is the name of the command you will call in the scheduler
    protected $signature = 'payments:process-reminders';

    protected $description = 'Process upcoming payment reminders and overdue alerts';

    public function handle(PaymentReminderService $service)
    {
        $this->info('Starting payment reminder process...');
        
        $results = $service->processPaymentReminders();
        
        $this->info("Process complete!");
        $this->table(
            ['Metric', 'Count'],
            [
                ['Due Reminders Sent', $results['due_reminders_sent']],
                ['Overdue Alerts Sent', $results['overdue_alerts_sent']],
                ['Total SMS', $results['due_sms_sent'] + $results['overdue_sms_sent']],
                ['Total Emails', $results['due_emails_sent'] + $results['overdue_emails_sent']],
            ]
        );
    }
}