<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\BackfillCreditScoreRecords::class,
        Commands\CalculateDailyInterest::class,
    ];

    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Run every 5 minutes for reliability
        $schedule->command('loans:calculate-daily-interest')
            ->everyFiveMinutes()
            ->timezone('Africa/Lusaka')
            ->withoutOverlapping()
            ->appendOutputTo(storage_path('logs/daily-interest.log'))
            ->emailOutputOnFailure('admin@immiafinance.com');
            
        // Optional: Add a health check for the scheduler
        $schedule->call(function () {
            \Log::info('Scheduler is running at ' . now()->format('Y-m-d H:i:s'));
        })->everyFiveMinutes();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}