<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccountType;
use App\Models\AccountGroup; // ADD THIS

class AccountTypeController extends Controller
{
    public function index()
    {
        $accountTypes = AccountType::with(['accountGroup'])->orderBy('name')->get();
        return view('accounting.settings.account-types.index', compact('accountTypes'));
    }

    public function create()
    {
        $accountGroups = AccountGroup::where('is_active', true)->orderBy('name')->get(); // ADD THIS
        return view('accounting.settings.account-types.create', compact('accountGroups')); // UPDATE THIS
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            // 'code' => 'required|unique:account_types,code', // REMOVED
            'name' => 'required',
            'description' => 'nullable',
            'account_group_id' => 'required|exists:account_groups,id', // ADD THIS
            'normal_balance' => 'required|in:debit,credit', // ADD THIS
            'is_active' => 'boolean',
        ]);

        // Add authenticated user as creator
        $validated['created_by'] = auth()->id();
        $validated['updated_by'] = auth()->id();

        AccountType::create($validated);

        return redirect()->route('admin.accounting.settings.account-types.index')
            ->with('success', 'Account type created successfully.');
    }

    public function show($id)
    {
        $accountType = AccountType::with(['accountGroup'])->findOrFail($id); // UPDATE THIS
        return view('accounting.settings.account-types.show', compact('accountType'));
    }

    public function edit($id)
    {
        $accountType = AccountType::findOrFail($id);
        $accountGroups = AccountGroup::where('is_active', true)->orderBy('name')->get(); // ADD THIS
        return view('accounting.settings.account-types.edit', compact('accountType', 'accountGroups')); // UPDATE THIS
    }

    public function update(Request $request, $id)
    {
        $accountType = AccountType::findOrFail($id);
        
        $validated = $request->validate([
            // 'code' => 'required|unique:account_types,code,' . $id, // REMOVED
            'name' => 'required',
            'description' => 'nullable',
            'account_group_id' => 'required|exists:account_groups,id', // ADD THIS
            'normal_balance' => 'required|in:debit,credit', // ADD THIS
            'is_active' => 'boolean',
        ]);

        // Add authenticated user as updater
        $validated['updated_by'] = auth()->id();

        $accountType->update($validated);

        return redirect()->route('admin.accounting.settings.account-types.index')
            ->with('success', 'Account type updated successfully.');
    }

    public function destroy($id)
    {
        $accountType = AccountType::findOrFail($id);
        $accountType->delete();

        return redirect()->route('admin.accounting.settings.account-types.index')
            ->with('success', 'Account type deleted successfully.');
    }
}