<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Accounting\OtherExpense;
use App\Models\Accounting\ChartOfAccount;

class OtherExpenseController extends Controller
{
    public function index()
    {
        $expenses = OtherExpense::orderBy('expense_date', 'desc')->get();
        $accounts = ChartOfAccount::where('is_active', true)->get();
        
        return view('accounting.payables.other-expenses.index', compact('expenses', 'accounts'));
    }

    public function create()
    {
        $accounts = ChartOfAccount::where('is_active', true)->get();
        return view('accounting.payables.other-expenses.create', compact('accounts'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'expense_date' => 'required|date',
            'description' => 'required',
            'amount' => 'required|numeric|min:0',
            'category' => 'required',
            'account_id' => 'required|exists:chart_of_accounts,id',
            'reference' => 'nullable',
            'approved_by' => 'nullable',
        ]);

        OtherExpense::create($validated);

        return redirect()->route('admin.accounting.payables.other-expenses.index')
            ->with('success', 'Other expense created successfully.');
    }

    public function show($id)
    {
        $expense = OtherExpense::with(['account'])->findOrFail($id);
        return view('accounting.payables.other-expenses.show', compact('expense'));
    }

    public function edit($id)
    {
        $expense = OtherExpense::findOrFail($id);
        $accounts = ChartOfAccount::where('is_active', true)->get();
        
        return view('accounting.payables.other-expenses.edit', compact('expense', 'accounts'));
    }

    public function update(Request $request, $id)
    {
        $expense = OtherExpense::findOrFail($id);
        
        $validated = $request->validate([
            'expense_date' => 'required|date',
            'description' => 'required',
            'amount' => 'required|numeric|min:0',
            'category' => 'required',
            'account_id' => 'required|exists:chart_of_accounts,id',
            'reference' => 'nullable',
            'approved_by' => 'nullable',
        ]);

        $expense->update($validated);

        return redirect()->route('admin.accounting.payables.other-expenses.index')
            ->with('success', 'Other expense updated successfully.');
    }

    public function destroy($id)
    {
        $expense = OtherExpense::findOrFail($id);
        $expense->delete();

        return redirect()->route('admin.accounting.payables.other-expenses.index')
            ->with('success', 'Other expense deleted successfully.');
    }
}