<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Accounting\ChartOfAccount;
use App\Models\Accounting\JournalEntry;
use App\Models\Accounting\JournalEntryItem;

class ReportController extends Controller
{
    public function index()
    {
        return view('accounting.reports.index');
    }

    public function balanceSheet()
    {
        $assets = ChartOfAccount::where('account_type', 'asset')
            ->where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        $liabilities = ChartOfAccount::where('account_type', 'liability')
            ->where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        $equity = ChartOfAccount::where('account_type', 'equity')
            ->where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        $totalAssets = $assets->sum('current_balance');
        $totalLiabilities = $liabilities->sum('current_balance');
        $totalEquity = $equity->sum('current_balance');
        
        return view('accounting.reports.balance-sheet', compact(
            'assets', 'liabilities', 'equity', 
            'totalAssets', 'totalLiabilities', 'totalEquity'
        ));
    }

    public function incomeStatement()
    {
        $revenues = ChartOfAccount::where('account_type', 'revenue')
            ->where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        $expenses = ChartOfAccount::where('account_type', 'expense')
            ->where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        $totalRevenue = $revenues->sum('current_balance');
        $totalExpenses = $expenses->sum('current_balance');
        $netIncome = $totalRevenue - $totalExpenses;
        
        return view('accounting.reports.income-statement', compact(
            'revenues', 'expenses', 'totalRevenue', 'totalExpenses', 'netIncome'
        ));
    }

    public function cashFlow()
    {
        // Simplified cash flow - in real scenario, you'd calculate from transactions
        $cashAccounts = ChartOfAccount::where('account_name', 'like', '%cash%')
            ->orWhere('account_name', 'like', '%bank%')
            ->where('is_active', true)
            ->get();
            
        return view('accounting.reports.cash-flow', compact('cashAccounts'));
    }

    public function trialBalance()
    {
        $accounts = ChartOfAccount::where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        $totalDebits = $accounts->sum(function($account) {
            return $account->current_balance > 0 ? $account->current_balance : 0;
        });
        
        $totalCredits = $accounts->sum(function($account) {
            return $account->current_balance < 0 ? abs($account->current_balance) : 0;
        });
        
        return view('accounting.reports.trial-balance', compact('accounts', 'totalDebits', 'totalCredits'));
    }

    public function generalLedger()
    {
        $accounts = ChartOfAccount::where('is_active', true)
            ->orderBy('account_code')
            ->get();
            
        return view('accounting.reports.general-ledger', compact('accounts'));
    }
}
