<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DisbursementChannel;
use Illuminate\Http\Request;

class DisbursementChannelController extends Controller
{
   
    public function index(Request $request)
    {
    $search = $request->input('search');

    $channels = DisbursementChannel::where('companyid', auth()->user()->companyid)
        ->when($search, function ($query, $search) {
            return $query->where('disbursmentchannel', 'like', "%{$search}%");
        })
        ->paginate(10)
        ->withQueryString(); // Keeps search parameter in pagination links

    return view('admin.disbursementschannel.index', compact('channels', 'search'));
    }

    public function store(Request $request)
    {
        $request->validate(['disbursmentchannel' => 'required|string|max:255']);
        
        DisbursementChannel::create([
            'disbursmentchannel' => $request->disbursmentchannel,
            'companyid' => auth()->user()->companyid,
            'createdby' => auth()->id(),
        ]);

        return back()->with('success', 'Channel created successfully.');
    }

    public function update(Request $request, $id)
    {
        $channel = DisbursementChannel::findOrFail($id);
        $channel->update($request->only('disbursmentchannel'));
        return back()->with('success', 'Channel updated successfully.');
    }

    public function destroy($id)
    {
        DisbursementChannel::findOrFail($id)->delete();
        return back()->with('success', 'Channel deleted successfully.');
    }
    
    public function export(Request $request)
{
    $search = $request->input('search');
    
    $channels = DisbursementChannel::where('companyid', auth()->user()->companyid)
        ->when($search, function ($query, $search) {
            return $query->where('disbursmentchannel', 'like', "%{$search}%");
        })
        ->get();

    $fileName = 'disbursement_channels_' . date('Y-m-d') . '.csv';

    $headers = [
        "Content-type"        => "text/csv",
        "Content-Disposition" => "attachment; filename=$fileName",
        "Pragma"              => "no-cache",
        "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
        "Expires"             => "0"
    ];

    $columns = ['ID', 'Channel Name', 'Created At'];

    $callback = function() use($channels, $columns) {
        $file = fopen('php://output', 'w');
        fputcsv($file, $columns);

        foreach ($channels as $channel) {
            fputcsv($file, [
                $channel->id,
                $channel->disbursmentchannel,
                $channel->created_at->format('Y-m-d H:i:s'),
            ]);
        }

        fclose($file);
    };

    return response()->stream($callback, 200, $headers);
}
}