<?php

namespace App\Mail;

use App\Models\Application;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LoanApplicationSubmitted extends Mailable
{
    use Queueable, SerializesModels;

    public $application;
    public $customer;

    /**
     * Create a new message instance.
     */
    // Location: app/Mail/LoanApplicationSubmitted.php

    public function __construct(Application $application)
   {
         $this->application = $application;
         // This ensures $customer is available for your {{ $customer->first_name }} tag
         $this->customer = $application->customer; 
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Loan Application Received - IMMIA FINANCE LIMITED',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.loan-application-submitted',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}