<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentOverdueReminder extends Mailable
{
    use Queueable, SerializesModels;

    public $customer;
    public $schedule;
    public $loan;
    public $overdueAmount;
    public $overdueDays;

    public function __construct($customer, $schedule, $loan, $overdueAmount, $overdueDays)
    {
        $this->customer = $customer;
        $this->schedule = $schedule;
        $this->loan = $loan;
        $this->overdueAmount = $overdueAmount;
        $this->overdueDays = $overdueDays;
    }

    public function build()
    {
        return $this->subject('URGENT: Overdue Payment - Loan #' . $this->schedule->loannumber)
                    ->view('emails.payment_overdue_reminder')
                    ->with([
                        'customer' => $this->customer,
                        'schedule' => $this->schedule,
                        'loan' => $this->loan,
                        'overdueAmount' => $this->overdueAmount,
                        'overdueDays' => $this->overdueDays
                    ]);
    }
}