<?php

namespace App\Mail;

use App\Models\Repayment;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class RepaymentReceivedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $repayment;
    public $customer;

    public function __construct(Repayment $repayment)
    {
        $this->repayment = $repayment;
        $this->customer = $repayment->customer;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Payment Received - ZMW ' . number_format($this->repayment->rtotal, 2),
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.repayment-received',
        );
    }
}