<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveAccrualTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'period_date',
        'accrued_days',
        'taken_days',
        'encashed_days',
        'balance_days',
        'journal_entry_id',
        'notes',
        'created_by'
    ];

    protected $casts = [
        'period_date' => 'date',
        'accrued_days' => 'decimal:2',
        'taken_days' => 'decimal:2',
        'encashed_days' => 'decimal:2',
        'balance_days' => 'decimal:2'
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    public function journalEntry()
    {
        return $this->belongsTo(JournalEntry::class, 'journal_entry_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getTransactionTypeAttribute()
    {
        if ($this->accrued_days > 0) {
            return 'accrual';
        } elseif ($this->taken_days > 0) {
            return 'taken';
        } elseif ($this->encashed_days > 0) {
            return 'encashment';
        }
        return 'adjustment';
    }

    public function getTransactionTypeLabelAttribute()
    {
        return ucfirst($this->transaction_type);
    }

    public function getDaysAttribute()
    {
        if ($this->accrued_days > 0) {
            return $this->accrued_days;
        } elseif ($this->taken_days > 0) {
            return $this->taken_days;
        } elseif ($this->encashed_days > 0) {
            return $this->encashed_days;
        }
        return 0;
    }

    public function getFormattedPeriodDateAttribute()
    {
        return $this->period_date ? $this->period_date->format('M d, Y') : 'N/A';
    }

    public function getFormattedCreatedAtAttribute()
    {
        return $this->created_at ? $this->created_at->format('M d, Y H:i') : 'N/A';
    }
}