<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    use HasFactory;

    protected $table = 'loanform';

    protected $primaryKey = 'loanid';

    protected $fillable = [
        'productid',
        'customerid',
        'product',
        'amount',
        'duration',
        'rate',
        'status',
        'pdate',
        'disburseddate',
        'maturitydate',
        'collectiondate',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'rate' => 'decimal:2',
        'adminfee' => 'decimal:2',
        'insurancefee' => 'decimal:2',
        'adminamount' => 'decimal:2',
        'insuranceamount' => 'decimal:2',
        'cyclepayment' => 'decimal:2',
        'income' => 'decimal:2',
        'pdate' => 'date',
        'disburseddate' => 'date',
        'maturitydate' => 'date',
        'collectiondate' => 'date',
        'approvaldate' => 'date',
    ];

    // Relationships
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customerid');
    }

    public function product()
    {
        return $this->belongsTo(LoanType::class, 'productid');
    }

    public function repayments()
    {
        return $this->hasMany(Repayment::class, 'rloanid', 'loanid');
    }
}