<?php
// app/Models/PendingPayment.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PendingPayment extends Model
{
    use HasFactory;

    protected $table = 'pending_payments';

    protected $fillable = [
        'customer_id',
        'loan_id',
        'transaction_id',
        'external_id',
        'amount',
        'mobile_number',
        'payment_method',
        'status',
        'company_id',
        'completed_at'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'completed_at' => 'datetime'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function loan()
    {
        return $this->belongsTo(DisbursedLoan::class, 'loan_id', 'loanid');
    }
}