<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrimaryCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'branch_id',
        'report_type_id',
        'name',
        // 'code', // REMOVED
        'description',
        'sequence',
        'is_active',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'sequence' => 'integer',
        'is_active' => 'boolean'
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function reportType()
    {
        return $this->belongsTo(ReportType::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function accountGroups()
    {
        return $this->hasMany(AccountGroup::class);
    }
}