<?php

namespace App\Services;

use Illuminate\Support\Facades\Mail;
use App\Mail\CustomerOTPEmail;
use App\Mail\PasswordChangeNotification;
use App\Mail\PasswordResetLink;
use App\Mail\PasswordResetConfirmation;

class EmailService
{
    /**
     * Send OTP email
     */
    public function sendOTPEmail(string $email, array $data): bool
    {
        try {
            Mail::to($email)->send(new CustomerOTPEmail($data));
            return true;
        } catch (\Exception $e) {
            \Log::error('Failed to send OTP email: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Send password change notification
     */
    public function sendPasswordChangeNotification(string $email, array $data): bool
    {
        try {
            Mail::to($email)->send(new PasswordChangeNotification($data));
            return true;
        } catch (\Exception $e) {
            \Log::error('Failed to send password change notification: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Send password reset link
     */
    public function sendPasswordResetLink(string $email, array $data): bool
    {
        try {
            Mail::to($email)->send(new PasswordResetLink($data));
            return true;
        } catch (\Exception $e) {
            \Log::error('Failed to send password reset link: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Send password reset confirmation
     */
    public function sendPasswordResetConfirmation(string $email, array $data): bool
    {
        try {
            Mail::to($email)->send(new PasswordResetConfirmation($data));
            return true;
        } catch (\Exception $e) {
            \Log::error('Failed to send password reset confirmation: ' . $e->getMessage());
            return false;
        }
    }
}