<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class NotificationSettingService
{
    /**
     * Check if a specific channel is enabled for an event.
     */
    public static function isEnabled(string $eventKey, string $channel): bool
    {
        return Cache::remember("notify_settings_{$channel}_{$eventKey}", 3600, function () use ($eventKey, $channel) {
            return DB::table('notification_settings')
                ->where('event_key', $eventKey)
                ->where('channel', $channel)
                ->where('is_enabled', 1)
                ->exists();
        });
    }

    /**
     * Parse and send an SMS template from the database.
     */
    public static function sendSmsTemplate(string $eventKey, string $phoneNumber, array $data)
    {
        if (!self::isEnabled($eventKey, 'sms')) return false;

        $event = DB::table('notification_events')->where('event_key', $eventKey)->first();
        if (!$event || empty($event->sms_template)) return false;

        $message = $event->sms_template;
        foreach ($data as $key => $value) {
            $message = str_replace("[" . $key . "]", $value, $message);
        }

        return app(SmsService::class)->sendSms($phoneNumber, $message);
    }

    public static function getReminderDays(): int
    {
        return (int) DB::table('notification_events')->where('event_key', 'payment_due')->value('reminder_days') ?? 0;
    }

    public static function getOverdueFrequency(): int
    {
        return (int) DB::table('notification_events')->where('event_key', 'payment_overdue')->value('overdue_frequency_days') ?? 1;
    }
}