<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Cash/Bank Account | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'New Cash/Bank Account', 'subtitle' => 'Create a new cash, bank, or mobile money account'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if($errors->any())
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <div>
                            <span class="text-red-800 font-semibold">Please fix the following errors:</span>
                            <ul class="text-red-700 text-sm mt-1 list-disc list-inside">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif

            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-lg font-semibold text-gray-900">Account Information</h2>
                        <p class="text-gray-600 text-sm mt-1">Fill in the details to create a new account</p>
                    </div>
                    
                    <div class="p-6">
                        <form method="POST" action="{{ route('admin.accounting.cash-banking.accounts.store') }}">
                            @csrf

                            <!-- General Details Section -->
                            <div class="mb-8">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-info-circle text-blue-500 mr-2"></i>
                                    General Details
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="accountType" class="block text-sm font-medium text-gray-700 mb-2">Account Type *</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('accountType') border-red-500 @enderror" 
                                                id="accountType" name="accountType" required>
                                            <option value="">Select Account Type</option>
                                            <option value="Cash" {{ old('accountType') == 'Cash' ? 'selected' : '' }}>Cash</option>
                                            <option value="Mobile Money" {{ old('accountType') == 'Mobile Money' ? 'selected' : '' }}>Mobile Money</option>
                                            <option value="Bank" {{ old('accountType') == 'Bank' ? 'selected' : '' }}>Bank</option>
                                        </select>
                                        @error('accountType')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="accountName" class="block text-sm font-medium text-gray-700 mb-2">Account Name *</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('accountName') border-red-500 @enderror" 
                                               id="accountName" name="accountName" value="{{ old('accountName') }}" 
                                               placeholder="Enter account name" required>
                                        @error('accountName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="currency" class="block text-sm font-medium text-gray-700 mb-2">Currency *</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('currency') border-red-500 @enderror" 
                                                id="currency" name="currency" required>
                                            <option value="">Select Currency</option>
                                            @foreach($currencies as $currency)
                                                <option value="{{ $currency->code }}" {{ old('currency') == $currency->code ? 'selected' : '' }}>
                                                    {{ $currency->code }} - {{ $currency->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('currency')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <label for="glAccountId" class="block text-sm font-medium text-gray-700 mb-2">GL Account</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('glAccountId') border-red-500 @enderror" 
                                                id="glAccountId" name="glAccountId">
                                            <option value="">Select GL Account</option>
                                            @foreach($glAccounts as $glAccount)
                                                <option value="{{ $glAccount->id }}" {{ old('glAccountId') == $glAccount->id ? 'selected' : '' }}>
                                                    {{ $glAccount->code }} - {{ $glAccount->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('glAccountId')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <!-- GL Account Creation Option -->
                                <div class="mt-6 p-4 bg-green-50 border border-green-200 rounded-lg">
                                    <div class="flex items-center mb-3">
                                        <input type="checkbox" name="create_gl_account" id="create_gl_account" value="1"
                                               class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded"
                                               {{ old('create_gl_account') ? 'checked' : '' }}>
                                        <label for="create_gl_account" class="ml-2 text-sm font-medium text-gray-700">
                                            <i class="fas fa-book mr-1"></i> Create corresponding General Ledger Account
                                        </label>
                                    </div>
                                    <p class="text-sm text-gray-600 mb-3">
                                        Automatically create a General Ledger account linked to this cash/bank account
                                    </p>
                                    
                                    <div id="glAccountFields" class="{{ old('create_gl_account') ? '' : 'hidden' }}">
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <label for="gl_account_type_id" class="block text-sm font-medium text-gray-700 mb-1">
                                                    Account Type *
                                                </label>
                                                <select name="gl_account_type_id" id="gl_account_type_id"
                                                        class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                                    <option value="">Select Account Type</option>
                                                    @foreach($accountTypes as $accountType)
                                                        <option value="{{ $accountType->id }}" 
                                                                {{ old('gl_account_type_id') == $accountType->id ? 'selected' : '' }}>
                                                            {{ $accountType->name }} ({{ $accountType->normal_balance }})
                                                            @if($accountType->accountGroup)
                                                                - {{ $accountType->accountGroup->name }}
                                                            @endif
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('gl_account_type_id')
                                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            
                                            <div>
                                                <label for="gl_account_code" class="block text-sm font-medium text-gray-700 mb-1">
                                                    Account Code
                                                </label>
                                                <input type="text" name="gl_account_code" id="gl_account_code"
                                                       class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500"
                                                       value="{{ old('gl_account_code') }}"
                                                       placeholder="Auto-generated if left empty">
                                            </div>
                                        </div>
                                        
                                        <div class="mt-3">
                                            <label for="gl_account_description" class="block text-sm font-medium text-gray-700 mb-1">
                                                Account Description
                                            </label>
                                            <textarea name="gl_account_description" id="gl_account_description" rows="2"
                                                      class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500"
                                                      placeholder="Optional description for the GL account">{{ old('gl_account_description') }}</textarea>
                                        </div>
                                        
                                        <div class="mt-2 text-xs text-gray-500">
                                            <i class="fas fa-info-circle mr-1"></i>
                                            The GL account will be automatically linked to this cash/bank account
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Bank Account Information -->
                            <div class="mb-8 bank-info-section" style="display: none;">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-landmark text-blue-500 mr-2"></i>
                                    Bank Account Information
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="bankAccountName" class="block text-sm font-medium text-gray-700 mb-2">Bank Account Name</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('bankAccountName') border-red-500 @enderror" 
                                               id="bankAccountName" name="bankAccountName" value="{{ old('bankAccountName') }}">
                                        @error('bankAccountName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="accountNumber" class="block text-sm font-medium text-gray-700 mb-2">Account Number</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('accountNumber') border-red-500 @enderror" 
                                               id="accountNumber" name="accountNumber" value="{{ old('accountNumber') }}">
                                        @error('accountNumber')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="branchName" class="block text-sm font-medium text-gray-700 mb-2">Branch Name</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('branchName') border-red-500 @enderror" 
                                               id="branchName" name="branchName" value="{{ old('branchName') }}">
                                        @error('branchName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <label for="bankName" class="block text-sm font-medium text-gray-700 mb-2">Bank Name</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('bankName') border-red-500 @enderror" 
                                               id="bankName" name="bankName" value="{{ old('bankName') }}">
                                        @error('bankName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Options -->
                            <div class="mb-8">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-cog text-blue-500 mr-2"></i>
                                    Options
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="openingBalance" class="block text-sm font-medium text-gray-700 mb-2">Opening Balance *</label>
                                        <input type="number" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('openingBalance') border-red-500 @enderror" 
                                               id="openingBalance" name="openingBalance" value="{{ old('openingBalance', '0.00') }}" 
                                               step="0.01" min="0" required>
                                        @error('openingBalance')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="openingBalanceDate" class="block text-sm font-medium text-gray-700 mb-2">Opening Balance as At *</label>
                                        <input type="date" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('openingBalanceDate') border-red-500 @enderror" 
                                               id="openingBalanceDate" name="openingBalanceDate" value="{{ old('openingBalanceDate', date('Y-m-d')) }}" required>
                                        @error('openingBalanceDate')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mt-6 space-y-3">
                                    <div class="flex items-center">
                                        <input type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" 
                                               id="isActive" name="isActive" value="1" {{ old('isActive', true) ? 'checked' : '' }}>
                                        <label for="isActive" class="ml-2 block text-sm text-gray-700">Active Account</label>
                                    </div>

                                    <div class="flex items-center">
                                        <input type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" 
                                               id="isDefault" name="isDefault" value="1" {{ old('isDefault') ? 'checked' : '' }}>
                                        <label for="isDefault" class="ml-2 block text-sm text-gray-700">Set as Default Account</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="mb-8">
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                                <textarea class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror" 
                                          id="description" name="description" rows="3" placeholder="Optional description of the account">{{ old('description') }}</textarea>
                                @error('description')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <!-- Buttons -->
                            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200">
                                <a href="{{ route('admin.accounting.cash-banking.accounts.index') }}" 
                                   class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition duration-150 font-medium">
                                    Cancel
                                </a>
                                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition duration-150 font-medium flex items-center">
                                    <i class="fas fa-save mr-2"></i>
                                    Save Account
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Show/hide bank information based on account type
        function toggleBankInfo() {
            const accountType = document.getElementById('accountType').value;
            const bankInfoSection = document.querySelector('.bank-info-section');
            const bankFields = document.querySelectorAll('.bank-info-section input, .bank-info-section select');
            
            if (accountType === 'Bank') {
                bankInfoSection.style.display = 'block';
                bankFields.forEach(field => field.required = true);
            } else {
                bankInfoSection.style.display = 'none';
                bankFields.forEach(field => field.required = false);
            }
        }

        // Toggle GL account creation fields
        document.getElementById('create_gl_account').addEventListener('change', function() {
            const glFields = document.getElementById('glAccountFields');
            if (this.checked) {
                glFields.classList.remove('hidden');
                document.getElementById('gl_account_type_id').required = true;
            } else {
                glFields.classList.add('hidden');
                document.getElementById('gl_account_type_id').required = false;
            }
        });

        // Auto-generate GL account code based on account name
        document.getElementById('accountName').addEventListener('input', function() {
            if (document.getElementById('create_gl_account').checked && 
                !document.getElementById('gl_account_code').value) {
                const accountName = this.value.trim();
                if (accountName) {
                    const accountType = document.getElementById('accountType').value;
                    let prefix = '';
                    
                    switch(accountType) {
                        case 'Cash': prefix = 'CASH'; break;
                        case 'Bank': prefix = 'BANK'; break;
                        case 'Mobile Money': prefix = 'MM'; break;
                        default: prefix = 'CASH';
                    }
                    
                    const cleanName = accountName.toUpperCase()
                        .replace(/[^A-Z0-9\s]/g, '')
                        .replace(/\s+/g, '_');
                        
                    const accountCode = prefix + '_' + cleanName;
                    document.getElementById('gl_account_code').value = accountCode;
                }
            }
        });

        // Also trigger when account type changes
        document.getElementById('accountType').addEventListener('change', function() {
            if (document.getElementById('create_gl_account').checked && 
                document.getElementById('accountName').value) {
                document.getElementById('accountName').dispatchEvent(new Event('input'));
            }
            toggleBankInfo(); // Also toggle bank info
        });

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleBankInfo();
            
            // If create_gl_account is checked, show the fields
            if (document.getElementById('create_gl_account').checked) {
                document.getElementById('glAccountFields').classList.remove('hidden');
                document.getElementById('gl_account_type_id').required = true;
            }
        });
    </script>
</body>
</html>