<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transfer Details | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Transfer Details', 'subtitle' => 'View internal transfer details and ledger entries'])

        <main class="p-6">
            <!-- Back Navigation -->
            <div class="mb-6">
                <a href="{{ route('admin.accounting.cash-banking.internal-transfers.index') }}" 
                   class="inline-flex items-center text-blue-600 hover:text-blue-700 font-medium">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Back to Transfers
                </a>
            </div>

            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            <!-- Transfer Details Card -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-6">
                <div class="p-6 border-b border-gray-200">
                    <div class="flex justify-between items-center">
                        <h2 class="text-xl font-bold text-gray-900">Transfer #{{ $transfer->transferid }}</h2>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $transfer->transferstatus == 'Sent' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                            @if($transfer->transferstatus == 'Sent')
                            <i class="fas fa-check-circle mr-1.5"></i>
                            @else
                            <i class="fas fa-clock mr-1.5"></i>
                            @endif
                            {{ $transfer->transferstatus }}
                        </span>
                    </div>
                </div>

                <div class="p-6">
                    <!-- Transfer Overview -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                        <!-- From Account -->
                        <div class="bg-red-50 rounded-xl p-5 border border-red-200">
                            <div class="flex items-center mb-4">
                                <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-arrow-up text-red-600"></i>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900">From Account</h3>
                                    <p class="text-sm text-gray-600">Source account</p>
                                </div>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-900">{{ $transfer->fromAccount->accountName }}</h4>
                                <p class="text-sm text-gray-600">{{ $transfer->fromAccount->accountType }}</p>
                                @if($transfer->fromAccount->accountNumber)
                                <p class="text-sm text-gray-600">#{{ $transfer->fromAccount->accountNumber }}</p>
                                @endif
                                <div class="mt-3">
                                    <p class="text-sm text-gray-600">Current Balance:</p>
                                    <p class="text-lg font-bold text-red-600">{{ number_format($transfer->fromAccount->current_balance, 2) }} {{ $transfer->fromAccount->currency }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Transfer Amount -->
                        <div class="bg-blue-50 rounded-xl p-5 border border-blue-200">
                            <div class="flex items-center mb-4">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-exchange-alt text-blue-600"></i>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900">Transfer Amount</h3>
                                    <p class="text-sm text-gray-600">Amount transferred</p>
                                </div>
                            </div>
                            <div>
                                <h4 class="text-2xl font-bold text-gray-900">{{ number_format($transfer->amountsent, 2) }} {{ $transfer->currency }}</h4>
                                @if($transfer->exchangerate != 1)
                                <div class="mt-3 space-y-1">
                                    <p class="text-sm text-gray-600">
                                        Exchange Rate: {{ number_format($transfer->exchangerate, 4) }}
                                    </p>
                                    <p class="text-sm font-medium text-green-600">
                                        Amount Received: {{ number_format($transfer->amountreceived, 2) }}
                                    </p>
                                </div>
                                @endif
                            </div>
                        </div>

                        <!-- To Account -->
                        <div class="bg-green-50 rounded-xl p-5 border border-green-200">
                            <div class="flex items-center mb-4">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-arrow-down text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900">To Account</h3>
                                    <p class="text-sm text-gray-600">Destination account</p>
                                </div>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-900">{{ $transfer->toAccount->accountName }}</h4>
                                <p class="text-sm text-gray-600">{{ $transfer->toAccount->accountType }}</p>
                                @if($transfer->toAccount->accountNumber)
                                <p class="text-sm text-gray-600">#{{ $transfer->toAccount->accountNumber }}</p>
                                @endif
                                <div class="mt-3">
                                    <p class="text-sm text-gray-600">Current Balance:</p>
                                    <p class="text-lg font-bold text-green-600">{{ number_format($transfer->toAccount->current_balance, 2) }} {{ $transfer->toAccount->currency }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Details -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Transfer Details</h3>
                            <div class="space-y-3">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Transaction Date:</span>
                                    <span class="font-medium">{{ $transfer->transactiondate->format('M d, Y') }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Reference:</span>
                                    <span class="font-medium">{{ $transfer->reference ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">External Reference:</span>
                                    <span class="font-medium">{{ $transfer->referenceno ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Created By:</span>
                                    <span class="font-medium">{{ $transfer->creator->name ?? 'System' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Created On:</span>
                                    <span class="font-medium">{{ $transfer->created_at->format('M d, Y h:i A') }}</span>
                                </div>
                                @if($transfer->transferstatus == 'Sent')
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Sent By:</span>
                                    <span class="font-medium">{{ $transfer->sentByUser->name ?? 'System' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Sent On:</span>
                                    <span class="font-medium">{{ $transfer->sent_at ? $transfer->sent_at->format('M d, Y h:i A') : 'N/A' }}</span>
                                </div>
                                @endif
                            </div>
                        </div>

                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Description</h3>
                            <div class="bg-gray-50 rounded-lg p-4">
                                <p class="text-gray-700">{{ $transfer->details ?? 'No description provided' }}</p>
                            </div>
                            
                            @if($transfer->transferstatus == 'Sent')
                            <div class="mt-6">
                                <h3 class="text-lg font-semibold text-gray-900 mb-4">Accounting Status</h3>
                                <div class="grid grid-cols-2 gap-4">
                                    <div class="bg-blue-50 rounded-lg p-3">
                                        <p class="text-sm text-gray-600">CashBook Entries:</p>
                                        <p class="text-lg font-bold text-blue-600">{{ $cashbookEntries->count() }}</p>
                                    </div>
                                    <div class="bg-purple-50 rounded-lg p-3">
                                        <p class="text-sm text-gray-600">GL Entries:</p>
                                        <p class="text-lg font-bold text-purple-600">{{ $ledgerEntries->count() }}</p>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Actions -->
                    @if($transfer->transferstatus === 'Pending')
                    <div class="mt-8 pt-6 border-t border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Transfer Actions</h3>
                        <div class="flex flex-wrap gap-3">
                            <a href="{{ route('admin.accounting.cash-banking.internal-transfers.edit', $transfer->transferid) }}" 
                               class="px-5 py-2.5 border border-green-600 text-green-600 rounded-lg font-semibold hover:bg-green-50 transition duration-150 flex items-center">
                                <i class="fas fa-edit mr-2"></i> Edit Transfer
                            </a>
                            
                            <form action="{{ route('admin.accounting.cash-banking.internal-transfers.send', $transfer->transferid) }}" 
                                  method="POST" 
                                  onsubmit="return confirm('Are you sure you want to send this transfer? This will post it to the ledger and cannot be undone.')">
                                @csrf
                                <button type="submit" 
                                        class="px-5 py-2.5 bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700 text-white rounded-lg font-semibold transition duration-150 flex items-center">
                                    <i class="fas fa-paper-plane mr-2"></i> Send Transfer
                                </button>
                            </form>
                            
                            <form action="{{ route('admin.accounting.cash-banking.internal-transfers.destroy', $transfer->transferid) }}" 
                                  method="POST" 
                                  onsubmit="return confirm('Are you sure you want to delete this transfer? This action cannot be undone.')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        class="px-5 py-2.5 border border-red-600 text-red-600 rounded-lg font-semibold hover:bg-red-50 transition duration-150 flex items-center">
                                    <i class="fas fa-trash mr-2"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- CashBook Entries -->
            @if($transfer->transferstatus === 'Sent' && $cashbookEntries->count() > 0)
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-6">
                <div class="p-6 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">CashBook Entries</h3>
                            <p class="text-sm text-gray-600">Posted cashbook transactions for this transfer</p>
                        </div>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                            <i class="fas fa-book mr-1.5"></i> {{ $cashbookEntries->count() }} Entries
                        </span>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Account</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Debit</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Credit</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Balance After</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($cashbookEntries as $entry)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $entry->transaction_date->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $entry->account->accountName ?? 'N/A' }}</div>
                                    <div class="text-sm text-gray-500">{{ $entry->account->accountType ?? '' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $entry->transaction_type == \App\Models\CashBook::TRANSACTION_TRANSFER_IN ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $entry->transaction_type }}
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-900">{{ $entry->description }}</div>
                                    <div class="text-xs text-gray-500">{{ $entry->reference_number }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($entry->isDebit())
                                    <div class="text-sm font-semibold text-green-600">
                                        {{ number_format($entry->amount, 2) }}
                                    </div>
                                    @else
                                    <div class="text-sm text-gray-400">-</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($entry->isCredit())
                                    <div class="text-sm font-semibold text-red-600">
                                        {{ number_format(abs($entry->amount), 2) }}
                                    </div>
                                    @else
                                    <div class="text-sm text-gray-400">-</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ number_format($entry->balance_after, 2) }} {{ $entry->currency }}</div>
                                    <div class="text-xs text-gray-500">from {{ number_format($entry->balance_before, 2) }}</div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td colspan="4" class="px-6 py-3 text-right text-sm font-semibold text-gray-900">Totals:</td>
                                <td class="px-6 py-3 text-sm font-semibold text-green-600">
                                    {{ number_format($cashbookEntries->where('amount', '>', 0)->sum('amount'), 2) }}
                                </td>
                                <td class="px-6 py-3 text-sm font-semibold text-red-600">
                                    {{ number_format(abs($cashbookEntries->where('amount', '<', 0)->sum('amount')), 2) }}
                                </td>
                                <td class="px-6 py-3"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            @endif

            <!-- General Ledger Entries -->
            @if($transfer->transferstatus === 'Sent' && $ledgerEntries->count() > 0)
            <div class="bg-white rounded-xl shadow-sm border border-gray-200">
                <div class="p-6 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">General Ledger Entries</h3>
                            <p class="text-sm text-gray-600">Double-entry accounting journal entries</p>
                        </div>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                            <i class="fas fa-balance-scale mr-1.5"></i> {{ $ledgerEntries->count() }} Entries
                        </span>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Account</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Reference</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($ledgerEntries as $entry)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $entry->entrydate->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $entry->account->name ?? 'N/A' }}</div>
                                    <div class="text-sm text-gray-500">{{ $entry->account->account_code ?? '' }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-900">{{ $entry->description }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $entry->entrytype == 'debit' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ strtoupper($entry->entrytype) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-semibold {{ $entry->entrytype == 'debit' ? 'text-green-600' : 'text-red-600' }}">
                                        {{ number_format($entry->amount, 2) }}
                                        @if($entry->original_currency)
                                        <span class="text-xs text-gray-500 ml-1">{{ $entry->original_currency }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $entry->documentno }}</div>
                                    <div class="text-xs text-gray-500">{{ $entry->referencedocument }}</div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td colspan="3" class="px-6 py-3 text-right text-sm font-semibold text-gray-900">Totals:</td>
                                <td class="px-6 py-3 text-sm font-medium text-gray-900">
                                    <div>{{ $ledgerEntries->where('entrytype', 'debit')->count() }} Debits</div>
                                    <div>{{ $ledgerEntries->where('entrytype', 'credit')->count() }} Credits</div>
                                </td>
                                <td class="px-6 py-3 text-sm font-semibold">
                                    <div class="text-green-600">
                                        Debit: {{ number_format($ledgerEntries->where('entrytype', 'debit')->sum('amount'), 2) }}
                                    </div>
                                    <div class="text-red-600 mt-1">
                                        Credit: {{ number_format($ledgerEntries->where('entrytype', 'credit')->sum('amount'), 2) }}
                                    </div>
                                </td>
                                <td class="px-6 py-3"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            @endif

            @if($transfer->transferstatus === 'Sent' && $cashbookEntries->count() == 0 && $ledgerEntries->count() == 0)
            <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-6 mb-6">
                <div class="flex items-center">
                    <i class="fas fa-exclamation-triangle text-yellow-500 text-xl mr-3"></i>
                    <div>
                        <h3 class="text-lg font-semibold text-yellow-800">Ledger Entries Not Found</h3>
                        <p class="text-yellow-700 mt-1">
                            This transfer is marked as "Sent" but no ledger entries were found. 
                            This might indicate an issue with the posting process.
                        </p>
                    </div>
                </div>
            </div>
            @endif
        </main>
    </div>

    <script>
        // Auto-hide success messages after 5 seconds
        setTimeout(() => {
            const successAlert = document.querySelector('.bg-green-50');
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 5000);
    </script>
</body>
</html>