<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $vendor->display_name }} | {{ config('app.name', 'Laravel') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Vendor Details', 'subtitle' => 'View vendor information'])

        <main class="p-6">
            <!-- Action Buttons -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <a href="{{ route('admin.accounting.expenses.vendors.index') }}" 
                       class="text-blue-600 hover:text-blue-800 flex items-center">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Vendors
                    </a>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('admin.accounting.expenses.vendors.edit', $vendor->id) }}" 
                       class="px-4 py-2 bg-blue-600 text-white rounded text-sm font-medium hover:bg-blue-700 flex items-center">
                        <i class="fas fa-edit mr-2"></i> Edit
                    </a>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                <!-- Vendor Header -->
                <div class="bg-gradient-to-r from-blue-50 to-blue-100 p-6 border-b border-gray-200">
                    <div class="flex items-center">
                        <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center mr-4">
                            <span class="text-white font-bold text-xl">
                                {{ strtoupper(substr($vendor->display_name, 0, 1)) }}
                            </span>
                        </div>
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">{{ $vendor->display_name }}</h2>
                            <div class="flex items-center space-x-4 mt-2">
                                @if($vendor->company_name)
                                    <span class="text-gray-600">
                                        <i class="fas fa-building mr-1"></i> {{ $vendor->company_name }}
                                    </span>
                                @endif
                                <span class="px-2 py-1 rounded-full text-xs font-medium 
                                    {{ $vendor->active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $vendor->active ? 'Active' : 'Inactive' }}
                                </span>
                                @if($vendor->vendor_1099)
                                    <span class="px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        1099 Vendor
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Vendor Information -->
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <!-- Contact Info -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h3 class="font-semibold text-gray-900 mb-3 flex items-center">
                                <i class="fas fa-address-card mr-2 text-blue-600"></i>
                                Contact Information
                            </h3>
                            <div class="space-y-2">
                                @if($vendor->email)
                                    <div class="flex items-center">
                                        <i class="fas fa-envelope text-gray-400 mr-2 w-5"></i>
                                        <a href="mailto:{{ $vendor->email }}" class="text-blue-600 hover:text-blue-800">
                                            {{ $vendor->email }}
                                        </a>
                                    </div>
                                @endif
                                @if($vendor->mobile_phone)
                                    <div class="flex items-center">
                                        <i class="fas fa-phone text-gray-400 mr-2 w-5"></i>
                                        <span class="text-gray-700">{{ $vendor->mobile_phone }}</span>
                                    </div>
                                @endif
                                @if($vendor->other_phone)
                                    <div class="flex items-center">
                                        <i class="fas fa-phone-alt text-gray-400 mr-2 w-5"></i>
                                        <span class="text-gray-700">{{ $vendor->other_phone }}</span>
                                    </div>
                                @endif
                                @if($vendor->website)
                                    <div class="flex items-center">
                                        <i class="fas fa-globe text-gray-400 mr-2 w-5"></i>
                                        <a href="{{ $vendor->website }}" target="_blank" class="text-blue-600 hover:text-blue-800">
                                            {{ $vendor->website }}
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Account Information -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h3 class="font-semibold text-gray-900 mb-3 flex items-center">
                                <i class="fas fa-wallet mr-2 text-green-600"></i>
                                Account Information
                            </h3>
                            <div class="space-y-2">
                                <div class="flex items-center">
                                    <i class="fas fa-hashtag text-gray-400 mr-2 w-5"></i>
                                    <span class="text-gray-700">
                                        Account: {{ $vendor->account_name }}
                                    </span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-money-bill-wave text-gray-400 mr-2 w-5"></i>
                                    <span class="text-gray-700">
                                        Currency: {{ $vendor->currency_with_symbol }}
                                    </span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-balance-scale text-gray-400 mr-2 w-5"></i>
                                    <span class="text-gray-700 font-medium {{ $vendor->balance > 0 ? 'text-red-600' : 'text-green-600' }}">
                                        Balance: {{ $vendor->currency_symbol }}{{ number_format($vendor->balance, 2) }}
                                    </span>
                                </div>
                                @if($vendor->payment_terms)
                                    <div class="flex items-center">
                                        <i class="fas fa-calendar-alt text-gray-400 mr-2 w-5"></i>
                                        <span class="text-gray-700">
                                            Payment Terms: {{ $vendor->payment_terms }}
                                        </span>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Tax Information -->
                        @if($vendor->vendor_1099 || $vendor->tax_id)
                            <div class="bg-gray-50 rounded-lg p-4">
                                <h3 class="font-semibold text-gray-900 mb-3 flex items-center">
                                    <i class="fas fa-file-invoice-dollar mr-2 text-purple-600"></i>
                                    Tax Information
                                </h3>
                                <div class="space-y-2">
                                    @if($vendor->vendor_1099)
                                        <div class="flex items-center">
                                            <i class="fas fa-check-circle text-green-500 mr-2 w-5"></i>
                                            <span class="text-gray-700">1099 Eligible Vendor</span>
                                        </div>
                                    @endif
                                    @if($vendor->tax_id)
                                        <div class="flex items-center">
                                            <i class="fas fa-id-card text-gray-400 mr-2 w-5"></i>
                                            <span class="text-gray-700">Tax ID: {{ $vendor->tax_id }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <!-- Billing Address -->
                        @if($vendor->billing_street1)
                            <div class="bg-gray-50 rounded-lg p-4">
                                <h3 class="font-semibold text-gray-900 mb-3 flex items-center">
                                    <i class="fas fa-map-marker-alt mr-2 text-red-600"></i>
                                    Billing Address
                                </h3>
                                <div class="text-gray-700 whitespace-pre-line">
                                    {{ $vendor->billing_address }}
                                </div>
                            </div>
                        @endif

                        <!-- Shipping Address -->
                        @if($vendor->shipping_street1 && $vendor->shipping_street1 !== $vendor->billing_street1)
                            <div class="bg-gray-50 rounded-lg p-4">
                                <h3 class="font-semibold text-gray-900 mb-3 flex items-center">
                                    <i class="fas fa-truck mr-2 text-orange-600"></i>
                                    Shipping Address
                                </h3>
                                <div class="text-gray-700 whitespace-pre-line">
                                    {{ $vendor->shipping_address }}
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Vendor Notes -->
                           <!-- Vendor Notes -->
@if($vendor->notes && $vendor->notes->count() > 0)
    <div class="mt-8">
        <h3 class="font-semibold text-gray-900 mb-4">Notes</h3>
        <div class="space-y-3">
            @foreach($vendor->notes as $note)
                <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <i class="fas fa-sticky-note text-yellow-400"></i>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-yellow-700">{{ $note->note }}</p>
                            <p class="text-xs text-yellow-600 mt-1">
                                {{ $note->created_at->format('M d, Y h:i A') }}
                            </p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@else
    <!-- Optional: Show message if no notes -->
    <div class="mt-8 text-center text-gray-500">
        <i class="fas fa-sticky-note text-3xl mb-2"></i>
        <p>No notes added yet</p>
    </div>
@endif
                    
                    
                    
                    
                </div>
            </div>
        </main>
    </div>
</body>
</html>