<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Journal Entries | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Journal Entries', 'subtitle' => 'Manage accounting journal entries'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <!-- Action Bar -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-xl font-bold text-gray-900">All Journal Entries</h2>
                    <p class="text-gray-600">{{ $journalEntries->count() }} entries found</p>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('admin.accounting.journals.create') }}" 
                       class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-semibold flex items-center space-x-2 transition duration-150">
                        <i class="fas fa-plus"></i>
                        <span>New Journal</span>
                    </a>
                </div>
            </div>

            <!-- Status Filter -->
            <div class="mb-6 flex space-x-2">
                <a href="{{ route('admin.accounting.journals.index', ['status' => 'all']) }}" 
                   class="px-4 py-2 rounded-lg font-medium {{ request('status') == 'all' || !request('status') ? 'bg-blue-100 text-blue-600' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                    All
                </a>
                <a href="{{ route('admin.accounting.journals.index', ['status' => 'draft']) }}" 
                   class="px-4 py-2 rounded-lg font-medium {{ request('status') == 'draft' ? 'bg-yellow-100 text-yellow-600' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                    Draft
                </a>
                <a href="{{ route('admin.accounting.journals.index', ['status' => 'posted']) }}" 
                   class="px-4 py-2 rounded-lg font-medium {{ request('status') == 'posted' ? 'bg-green-100 text-green-600' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                    Posted
                </a>
                <a href="{{ route('admin.accounting.journals.index', ['status' => 'cancelled']) }}" 
                   class="px-4 py-2 rounded-lg font-medium {{ request('status') == 'cancelled' ? 'bg-red-100 text-red-600' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                    Cancelled
                </a>
            </div>

            <!-- Journal Entries Table -->
            <div class="bg-white rounded-xl shadow-sm border">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Entry Number</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Currency</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Debit/Credit</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($journalEntries as $entry)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $entry->entry_number }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $entry->entry_date->format('M d, Y') }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-gray-900">{{ Str::limit($entry->description, 60) }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-500">{{ $entry->reference ?? 'N/A' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $entry->currency->code ?? 'N/A' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $entry->currency->symbol ?? '$' }}{{ number_format($entry->total_debit, 2) }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        {{ $entry->status == 'draft' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $entry->status == 'posted' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $entry->status == 'cancelled' ? 'bg-red-100 text-red-800' : '' }}">
                                        {{ ucfirst($entry->status) }}
                                    </span>
                                    @if($entry->posted_at)
                                    <div class="text-xs text-gray-500 mt-1">
                                        {{ $entry->posted_at->format('M d, Y') }}
                                    </div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex items-center space-x-2">
                                        <a href="{{ route('admin.accounting.journals.show', $entry->id) }}" 
                                           class="text-blue-600 hover:text-blue-900 transition duration-150" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($entry->status == 'draft')
                                        <a href="{{ route('admin.accounting.journals.edit', $entry->id) }}" 
                                           class="text-green-600 hover:text-green-900 transition duration-150" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @endif
                                        @if($entry->status == 'draft')
                                        <form action="{{ route('admin.accounting.journals.destroy', $entry->id) }}" 
                                              method="POST" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="text-red-600 hover:text-red-900 transition duration-150"
                                                    onclick="return confirm('Are you sure you want to delete this journal entry? This action cannot be undone.')"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endif
                                        @if($entry->status == 'draft')
                                        <form action="{{ route('admin.accounting.journals.post', $entry->id) }}" 
                                              method="POST" class="inline">
                                            @csrf
                                            <button type="submit" 
                                                    class="text-purple-600 hover:text-purple-900 transition duration-150"
                                                    onclick="return confirm('Are you sure you want to post this journal entry? This will update the general ledger.')"
                                                    title="Post">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="px-6 py-4 text-center text-sm text-gray-500">
                                    <div class="flex flex-col items-center justify-center py-8">
                                        <i class="fas fa-book text-4xl text-gray-300 mb-4"></i>
                                        <p class="text-gray-500">No journal entries found</p>
                                        <a href="{{ route('admin.accounting.journals.create') }}" 
                                           class="mt-2 text-blue-600 hover:text-blue-700 font-medium transition duration-150">
                                            Create your first journal entry
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Pagination -->
            @if($journalEntries->hasPages())
            <div class="mt-6">
                {{ $journalEntries->links() }}
            </div>
            @endif
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Success message handling
        @if(session('success'))
            setTimeout(() => {
                const successAlert = document.querySelector('.bg-green-50');
                if (successAlert) {
                    successAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        @if(session('error'))
            setTimeout(() => {
                const errorAlert = document.querySelector('.bg-red-50');
                if (errorAlert) {
                    errorAlert.style.display = 'none';
                }
            }, 5000);
        @endif
    </script>
</body>
</html>