<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Journal Entry {{ $journalEntry->entry_number }} | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Journal Entry Details', 'subtitle' => 'View journal entry information'])

        <main class="p-6">
            <!-- Action Bar -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-xl font-bold text-gray-900">{{ $journalEntry->entry_number }}</h2>
                    <p class="text-gray-600">Journal Entry Details</p>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('admin.accounting.journals.index') }}" 
                       class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg font-semibold flex items-center space-x-2 transition duration-150">
                        <i class="fas fa-arrow-left"></i>
                        <span>Back to List</span>
                    </a>
                    @if($journalEntry->status == 'draft')
                    <a href="{{ route('admin.accounting.journals.edit', $journalEntry->id) }}" 
                       class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-semibold flex items-center space-x-2 transition duration-150">
                        <i class="fas fa-edit"></i>
                        <span>Edit</span>
                    </a>
                    @endif
                    @if($journalEntry->status == 'draft')
                    <form action="{{ route('admin.accounting.journals.post', $journalEntry->id) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" 
                                class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-lg font-semibold flex items-center space-x-2 transition duration-150"
                                onclick="return confirm('Are you sure you want to post this journal entry? This will update the general ledger.')">
                            <i class="fas fa-paper-plane"></i>
                            <span>Post</span>
                        </button>
                    </form>
                    @endif
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Left Column - Header Information -->
                <div class="lg:col-span-2">
                    <!-- Journal Information -->
                    <div class="bg-white rounded-xl shadow-sm border p-6 mb-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Journal Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Journal Number</label>
                                <p class="text-lg font-bold text-gray-900">{{ $journalEntry->entry_number }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Entry Date</label>
                                <p class="text-gray-900">{{ $journalEntry->entry_date->format('F d, Y') }}</p>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                                <p class="text-gray-900">{{ $journalEntry->description }}</p>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Reference</label>
                                <p class="text-gray-900">{{ $journalEntry->reference ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Currency Information -->
                    <div class="bg-white rounded-xl shadow-sm border p-6 mb-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Currency Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Currency</label>
                                <p class="text-gray-900">{{ $journalEntry->currency->code ?? 'N/A' }} - {{ $journalEntry->currency->name ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Exchange Rate</label>
                                <p class="text-gray-900">{{ number_format($journalEntry->exchange_rate, 6) }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Exchange Date</label>
                                <p class="text-gray-900">{{ $journalEntry->entry_date->format('F d, Y') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Journal Lines -->
                    <div class="bg-white rounded-xl shadow-sm border p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Journal Lines</h3>
                        
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead class="bg-gray-50 border-b">
                                    <tr>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Debit</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Credit</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Memo</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($journalEntry->items as $item)
                                    <tr class="border-b hover:bg-gray-50">
                                        <td class="px-4 py-3">
                                            <div class="font-medium text-gray-900">{{ $item->account->code ?? 'N/A' }}</div>
                                            <div class="text-sm text-gray-500">{{ $item->account->name ?? 'N/A' }}</div>
                                        </td>
                                        <td class="px-4 py-3 text-right">
                                            @if($item->debit > 0)
                                            <span class="text-green-600 font-semibold">
                                                {{ $journalEntry->currency->symbol ?? '$' }}{{ number_format($item->debit, 2) }}
                                            </span>
                                            @else
                                            <span class="text-gray-400">-</span>
                                            @endif
                                        </td>
                                        <td class="px-4 py-3 text-right">
                                            @if($item->credit > 0)
                                            <span class="text-red-600 font-semibold">
                                                {{ $journalEntry->currency->symbol ?? '$' }}{{ number_format($item->credit, 2) }}
                                            </span>
                                            @else
                                            <span class="text-gray-400">-</span>
                                            @endif
                                        </td>
                                        <td class="px-4 py-3">
                                            <span class="text-gray-600">{{ $item->description ?? '-' }}</span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot class="bg-gray-50">
                                    <tr>
                                        <td class="px-4 py-3 font-semibold text-right">Totals:</td>
                                        <td class="px-4 py-3 text-right font-semibold text-green-600">
                                            {{ $journalEntry->currency->symbol ?? '$' }}{{ number_format($journalEntry->total_debit, 2) }}
                                        </td>
                                        <td class="px-4 py-3 text-right font-semibold text-red-600">
                                            {{ $journalEntry->currency->symbol ?? '$' }}{{ number_format($journalEntry->total_credit, 2) }}
                                        </td>
                                        <td class="px-4 py-3"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Status & Actions -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-xl shadow-sm border p-6 sticky top-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Status & Information</h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                                    {{ $journalEntry->status == 'draft' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                    {{ $journalEntry->status == 'posted' ? 'bg-green-100 text-green-800' : '' }}
                                    {{ $journalEntry->status == 'cancelled' ? 'bg-red-100 text-red-800' : '' }}">
                                    {{ ucfirst($journalEntry->status) }}
                                </span>
                            </div>

                            @if($journalEntry->posted_at)
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Posted Date</label>
                                <p class="text-gray-900">{{ $journalEntry->posted_at->format('F d, Y H:i') }}</p>
                            </div>
                            @endif

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Created By</label>
                                <p class="text-gray-900">{{ $journalEntry->creator->name ?? 'System' }}</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Created Date</label>
                                <p class="text-gray-900">{{ $journalEntry->created_at->format('F d, Y H:i') }}</p>
                            </div>

                            @if($journalEntry->updated_at)
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Last Updated</label>
                                <p class="text-gray-900">{{ $journalEntry->updated_at->format('F d, Y H:i') }}</p>
                            </div>
                            @endif

                            <div class="pt-4 border-t border-gray-200">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Summary</label>
                                <div class="space-y-2 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Total Lines:</span>
                                        <span class="font-semibold">{{ $journalEntry->items->count() }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Total Amount:</span>
                                        <span class="font-semibold">
                                            {{ $journalEntry->currency->symbol ?? '$' }}{{ number_format($journalEntry->total_debit, 2) }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Balance Status:</span>
                                        <span class="font-semibold {{ $journalEntry->isBalanced() ? 'text-green-600' : 'text-red-600' }}">
                                            {{ $journalEntry->isBalanced() ? 'Balanced' : 'Not Balanced' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>