@php
    // Define variables for header partial and view
    $pageTitle = 'Finalize Offer Activation';
    $pageSubtitle = 'Confirming permanent activation for Offer #' . $offer->id; 
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            width: 100%;
            background-color: #F3F2F1;
            color: #605E5C;
        }
        /* Custom styles to match your theme */
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        /* Ensuring primary button styles are fully applied */
        .bg-primary { background-color: #146CAA; }
        .hover\:bg-primary\/90:hover { background-color: rgba(20, 108, 170, 0.9); }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        
        @include('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ])

        <main class="p-6">
            
            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-danger mr-2"></i>
                        <span class="text-red-800 font-medium">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <div class="max-w-3xl mx-auto bg-white rounded-lg shadow-lg border border-gray200">
                <div class="p-6 border-b border-gray200">
                    <h2 class="text-xl font-bold text-gray900">Final Activation</h2>
                </div>
                
                <div class="p-6">
                    
                    <div class="mb-6 p-4 bg-yellow-100 border border-yellow-300 rounded-lg">
                        <div class="flex items-start">
                            <i class="fas fa-exclamation-triangle text-warning text-lg mr-3 mt-0.5"></i>
                            <div>
                                <p class="text-warning font-semibold">
                                    WARNING: This is a permanent action.
                                </p>
                                <p class="text-sm text-gray700 mt-1">
                                    Once activated and finalized, this offer **cannot be edited or deleted**. It will serve as the immutable benchmark for the system.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <h3 class="text-lg font-semibold text-gray900 mb-4">Offer Details</h3>
                    
                    <div class="grid grid-cols-2 gap-4 mb-6">
                        
                        {{-- 1. Product Name --}}
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-1">Product Name</label>
                            <input type="text" value="{{ $offer->product_name }}" class="quickbooks-input" readonly>
                        </div>
                        
                        {{-- 2. Credit Tier --}}
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-1">Credit Tier</label>
                            <input type="text" value="{{ $offer->credit_score_tier }} ({{ $offer->min_score }}-{{ $offer->max_score }})" class="quickbooks-input" readonly>
                        </div>

                        {{-- 3. Duration Range --}}
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-1">Duration Range</label>
                            <input type="text" value="{{ $offer->min_duration }} - {{ $offer->max_duration }} days" class="quickbooks-input" readonly>
                        </div>
                        
                        {{-- 4. Amount Range --}}
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-1">Amount Range</label>
                            <input type="text" value="ZMW {{ number_format($offer->min_amount, 2) }} - ZMW {{ number_format($offer->max_amount, 2) }}" class="quickbooks-input" readonly>
                        </div>

                        {{-- 5. Daily Interest Rate --}}
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-1">Daily Interest Rate</label>
                            <input type="text" value="{{ number_format($offer->daily_rate, 2) }}%" class="quickbooks-input" readonly>
                        </div>
                        
                        {{-- 6. Current Status --}}
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-1">Current Status</label>
                            <input type="text" value="{{ $offer->is_active ? 'Active' : 'Inactive' }}" class="quickbooks-input" readonly>
                        </div>
                    </div>

                    {{-- FORM FOR SUBMITTING ACTIVATION --}}
                    <form method="POST" action="{{ route('admin.accounting.offers.activate', $offer->id) }}">
                        @csrf
                        <div class="flex justify-between items-center pt-6 border-t border-gray200">
                            {{-- CANCEL/BACK BUTTON --}}
                            <a href="{{ route('admin.accounting.offers.index') }}" 
                               class="px-4 py-2 border border-gray300 text-gray700 rounded text-sm font-medium hover:bg-gray100">
                                <i class="fas fa-arrow-left mr-2"></i> Cancel
                            </a>
                            
                            {{-- SUBMIT BUTTON WRAPPED FOR RELIABILITY --}}
                            <div class="flex-shrink-0">
                                <button type="submit" 
                                        class="px-4 py-2 bg-primary text-white rounded text-sm font-medium hover:bg-primary/90">
                                    <i class="fas fa-bolt mr-2"></i> Finalize and Activate
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
        </main>
    </div>
</body>
</html>