<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Earning Type | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const taxableCheckbox = document.getElementById('is_taxable');
            const statutoryCheckbox = document.getElementById('is_statutory');
            const statutoryLabel = document.querySelector('label[for="is_statutory"]');
            
            function updateStatutoryField() {
                if (!taxableCheckbox.checked) {
                    // If not taxable, disable statutory checkbox and uncheck it
                    statutoryCheckbox.checked = false;
                    statutoryCheckbox.disabled = true;
                    statutoryLabel.classList.add('text-gray-400');
                    statutoryLabel.classList.remove('text-gray-700');
                } else {
                    // If taxable, enable statutory checkbox
                    statutoryCheckbox.disabled = false;
                    statutoryLabel.classList.remove('text-gray-400');
                    statutoryLabel.classList.add('text-gray-700');
                }
            }
            
            // Initial update
            updateStatutoryField();
            
            // Update when taxable checkbox changes
            taxableCheckbox.addEventListener('change', updateStatutoryField);
            
            // Form validation
            const form = document.querySelector('form');
            form.addEventListener('submit', function(e) {
                // Validate that if statutory is checked, taxable must also be checked
                if (statutoryCheckbox.checked && !taxableCheckbox.checked) {
                    e.preventDefault();
                    alert('Error: Statutory deductions must be taxable. Please check "Taxable Earnings" if you want to mark this as statutory.');
                    return false;
                }
                
                // Validate unique code (you might want to add AJAX validation)
                const codeInput = document.querySelector('input[name="code"]');
                if (!codeInput.value.trim()) {
                    e.preventDefault();
                    alert('Please enter a code for the earning type.');
                    return false;
                }
            });
        });
    </script>
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Create Earning Type', 'subtitle' => 'Define a new payroll earning type'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            @if ($errors->any())
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center mb-2">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">Please fix the following errors:</span>
                    </div>
                    <ul class="list-disc list-inside text-red-700 text-sm">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <!-- Back Button -->
            <div class="mb-6">
                <a href="{{ route('admin.accounting.payroll.earnings.types.index') }}" 
                   class="text-blue-600 hover:text-blue-900 font-medium text-sm flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Earning Types
                </a>
            </div>

            <!-- Earning Type Form -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
                <form action="{{ route('admin.accounting.payroll.earnings.types.store') }}" method="POST">
                    @csrf
                    
                    <div class="p-6 space-y-6">
                        <!-- Basic Information -->
                        <div>
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Basic Information</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Name *
                                    </label>
                                    <input type="text" name="name" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                                           placeholder="e.g., Basic Salary"
                                           value="{{ old('name') }}"
                                           required>
                                    @error('name')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Type *
                                    </label>
                                    <select name="type" 
                                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                                            required>
                                        <option value="">Select Type</option>
                                        <option value="basic" {{ old('type') == 'basic' ? 'selected' : '' }}>Basic Salary</option>
                                        <option value="allowance" {{ old('type') == 'allowance' ? 'selected' : '' }}>Allowance</option>
                                        <option value="bonus" {{ old('type') == 'bonus' ? 'selected' : '' }}>Bonus</option>
                                        <option value="commission" {{ old('type') == 'commission' ? 'selected' : '' }}>Commission</option>
                                        <option value="gratuity" {{ old('type') == 'gratuity' ? 'selected' : '' }}>Gratuity</option>
                                        <option value="overtime" {{ old('type') == 'overtime' ? 'selected' : '' }}>Overtime</option>
                                        <option value="other" {{ old('type') == 'other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                    @error('type')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Code *
                                    </label>
                                    <input type="text" name="code" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                                           placeholder="e.g., BASIC, HOUSING, TRANSPORT"
                                           value="{{ old('code') }}"
                                           required>
                                    <p class="text-xs text-gray-500 mt-1">Unique code for this earning type</p>
                                    @error('code')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Sort Order
                                    </label>
                                    <input type="number" name="sort_order" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                                           value="{{ old('sort_order', 0) }}"
                                           min="0">
                                    @error('sort_order')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Tax and Status Settings -->
                        <div>
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Tax and Status Settings</h3>
                            <div class="space-y-4">
                                <div class="flex items-center">
                                    <input type="checkbox" id="is_taxable" name="is_taxable" value="1" 
                                           {{ old('is_taxable', true) ? 'checked' : '' }}
                                           class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                    <label for="is_taxable" class="ml-2 text-sm text-gray-700">
                                        Taxable Earnings
                                    </label>
                                    <span class="ml-2 text-xs text-gray-500">(Subject to PAYE tax)</span>
                                </div>
                                
                                <div class="flex items-center">
                                    <input type="checkbox" id="is_statutory" name="is_statutory" value="1"
                                           {{ old('is_statutory') ? 'checked' : '' }}
                                           class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                    <label for="is_statutory" class="ml-2 text-sm text-gray-700">
                                        Statutory Deduction
                                    </label>
                                    <span class="ml-2 text-xs text-gray-500">(e.g., NAPSA, NHIMA, pension contributions)</span>
                                </div>
                                
                                <!-- Information box -->
                                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-4">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <i class="fas fa-info-circle text-blue-400"></i>
                                        </div>
                                        <div class="ml-3">
                                            <h3 class="text-sm font-medium text-blue-800">Important Note</h3>
                                            <div class="mt-2 text-sm text-blue-700">
                                                <p>• Statutory deductions must be taxable</p>
                                                <p>• Non-taxable earnings are not subject to PAYE tax</p>
                                                <p>• Statutory deductions include mandatory contributions like NAPSA, NHIMA, etc.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Description
                            </label>
                            <textarea name="description" rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                                      placeholder="Optional description for this earning type...">{{ old('description') }}</textarea>
                            @error('description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 rounded-b-lg">
                        <div class="flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.payroll.earnings.types.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 hover:bg-gray-50">
                                Cancel
                            </a>
                            <button type="submit" 
                                    class="px-4 py-2 bg-blue-600 text-white rounded-lg text-sm font-medium hover:bg-blue-700">
                                Create Earning Type
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>