<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leave Pending Review | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-approve {
            background-color: #E1F0FA;
            color: #107C10;
        }
        .action-btn-approve:hover {
            background-color: #107C10;
            color: white;
        }
        .action-btn-reject {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-reject:hover {
            background-color: #D83B01;
            color: white;
        }
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge-pending {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Leave Pending Review</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.index') }}" class="hover:text-primary">Payroll</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.index') }}" class="hover:text-primary">Leave Management</a>
                        <span>/</span>
                        <span class="text-gray900">Pending Review</span>
                    </nav>
                </div>
                <div class="flex items-center space-x-3">
                    <span class="text-sm text-gray600">{{ $pendingRequests->total() }} request(s) pending</span>
                </div>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <!-- Pending Requests Table -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                @if($pendingRequests->count() > 0)
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Employee</th>
                                <th>Leave Type</th>
                                <th>Dates</th>
                                <th>Duration</th>
                                <th>Requested</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($pendingRequests as $request)
                            <tr class="hover:bg-gray100">
                                <td>
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-full bg-primaryLight flex items-center justify-center">
                                            <span class="text-primary text-sm font-medium">
                                                {{ substr($request->employee->first_name, 0, 1) }}{{ substr($request->employee->last_name, 0, 1) }}
                                            </span>
                                        </div>
                                        <div>
                                            <a href="{{ route('admin.accounting.payroll.leave.requests.show', $request->id) }}" 
                                               class="font-medium text-gray900 hover:text-primary">
                                                {{ $request->employee->full_name }}
                                            </a>
                                            <div class="text-xs text-gray500">{{ $request->employee->employee_number }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">{{ $request->leaveType->name }}</div>
                                    @if($request->leaveType->is_paid)
                                    <div class="text-xs text-green-600">Paid Leave</div>
                                    @else
                                    <div class="text-xs text-gray500">Unpaid Leave</div>
                                    @endif
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">{{ $request->formatted_start_date }}</div>
                                    <div class="text-xs text-gray500">to {{ $request->formatted_end_date }}</div>
                                </td>
                                <td>
                                    <div class="text-sm font-medium text-gray900">{{ $request->total_days }} days</div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">{{ $request->formatted_created_at }}</div>
                                    <div class="text-xs text-gray500">{{ $request->requester->name ?? 'System' }}</div>
                                </td>
                                <td>
                                    <div class="flex items-center">
                                        <a href="{{ route('admin.accounting.payroll.leave.requests.show', $request->id) }}" 
                                           class="action-btn action-btn-view"
                                           title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <a href="{{ route('admin.accounting.payroll.leave.requests.approve', $request->id) }}" 
                                           class="action-btn action-btn-approve"
                                           title="Approve"
                                           onclick="return confirm('Are you sure you want to approve this leave request?')">
                                            <i class="fas fa-check"></i>
                                        </a>
                                        
                                        <a href="{{ route('admin.accounting.payroll.leave.requests.reject', $request->id) }}" 
                                           class="action-btn action-btn-reject"
                                           title="Reject"
                                           onclick="return confirm('Are you sure you want to reject this leave request?')">
                                            <i class="fas fa-times"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($pendingRequests->hasPages())
                <div class="p-6 border-t border-gray200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing {{ $pendingRequests->firstItem() }} to {{ $pendingRequests->lastItem() }} of {{ $pendingRequests->total() }} entries
                        </div>
                        <div class="flex space-x-2">
                            @if($pendingRequests->onFirstPage())
                            <span class="px-3 py-1 rounded bg-gray100 text-gray500 text-sm">Previous</span>
                            @else
                            <a href="{{ $pendingRequests->previousPageUrl() }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">Previous</a>
                            @endif
                            
                            @foreach($pendingRequests->getUrlRange(1, $pendingRequests->lastPage()) as $page => $url)
                                @if($page == $pendingRequests->currentPage())
                                <span class="px-3 py-1 rounded bg-primary text-white text-sm">{{ $page }}</span>
                                @else
                                <a href="{{ $url }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">{{ $page }}</a>
                                @endif
                            @endforeach
                            
                            @if($pendingRequests->hasMorePages())
                            <a href="{{ $pendingRequests->nextPageUrl() }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">Next</a>
                            @else
                            <span class="px-3 py-1 rounded bg-gray100 text-gray500 text-sm">Next</span>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
                
                @else
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-check-circle text-yellow-600 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-medium text-gray900 mb-2">No pending leave requests</h3>
                    <p class="text-gray600 mb-6 max-w-md mx-auto">
                        All leave requests have been reviewed and processed.
                    </p>
                    <a href="{{ route('admin.accounting.payroll.leave.requests.index') }}" 
                       class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 inline-flex items-center gap-2">
                        <i class="fas fa-list"></i>
                        View All Leave Requests
                    </a>
                </div>
                @endif
            </div>
        </main>
    </div>

    <script>
        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
    </script>
</body>
</html>