<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculate Payroll | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-input {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 6px 12px;
            font-size: 14px;
        }
        .quickbooks-input:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        .quickbooks-checkbox {
            width: 18px;
            height: 18px;
            border: 2px solid #605E5C;
            border-radius: 3px;
        }
        .quickbooks-checkbox:checked {
            background-color: #146CAA;
            border-color: #146CAA;
        }
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .form-section {
            background: white;
            border-radius: 8px;
            padding: 24px;
            margin-bottom: 16px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .form-section h3 {
            font-size: 18px;
            font-weight: 600;
            color: #323130;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 1px solid #EDEBE9;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Calculate Payroll', 'subtitle' => 'Process payroll for ' . ($period->period_name ?? 'Selected Period')])

        <main class="p-6">
            <!-- Back Button -->
            <div class="mb-6">
                <a href="{{ route('admin.accounting.payroll.processing.index') }}" 
                   class="text-primary hover:text-primary/90 font-medium text-sm flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Payroll Processing
                </a>
            </div>

            <!-- Period Information -->
            <div class="form-section">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray700 mb-2">Payroll Period</label>
                        <div class="p-3 bg-gray50 rounded-lg border border-gray200">
                            <div class="font-medium text-gray900">{{ $period->period_name ?? 'N/A' }}</div>
                            <div class="text-sm text-gray600">{{ $period->formatted_date_range ?? 'N/A' }}</div>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray700 mb-2">Cutoff Date</label>
                        <div class="p-3 bg-gray50 rounded-lg border border-gray200">
                            <div class="font-medium text-gray900">{{ $period->cutoff_date->format('M d, Y') ?? 'N/A' }}</div>
                            <div class="text-sm text-gray600">Payroll cutoff</div>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray700 mb-2">Payment Date</label>
                        <div class="p-3 bg-gray50 rounded-lg border border-gray200">
                            <div class="font-medium text-gray900">{{ $period->payment_date->format('M d, Y') ?? 'N/A' }}</div>
                            <div class="text-sm text-gray600">Scheduled payment</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Employee Selection -->
            <div class="form-section">
                <h3>Select Employees</h3>
                
                @if(!$payeSettings || !$napsaSettings || !$nhimaSettings)
                    <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-triangle text-red-500 mr-2"></i>
                            <div>
                                <p class="text-sm text-red-800 font-medium">Missing Payroll Settings</p>
                                <p class="text-xs text-red-600 mt-1">
                                    Please configure PAYE, NAPSA, and NHIMA settings before processing payroll.
                                    <a href="{{ route('admin.accounting.payroll.index') }}" class="font-medium underline">Go to Settings</a>
                                </p>
                            </div>
                        </div>
                    </div>
                @endif
                
                @if($employees->isEmpty())
                    <div class="text-center py-8">
                        <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-user-slash text-gray500 text-2xl"></i>
                        </div>
                        <h3 class="text-lg font-medium text-gray900 mb-2">No Active Employees</h3>
                        <p class="text-gray600 mb-6">Add employees first before processing payroll.</p>
                        <a href="{{ route('admin.accounting.payroll.employees.create') }}" 
                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90">
                            <i class="fas fa-plus mr-2"></i>Add Employee
                        </a>
                    </div>
                @else
                    <form id="payrollForm" action="{{ route('admin.accounting.payroll.processing.calculate') }}" method="POST">
                        @csrf
                        <input type="hidden" name="payroll_period_id" value="{{ $period->id }}">
                        
                        <!-- Quick Actions -->
                        <div class="mb-6 flex items-center space-x-3">
                            <button type="button" onclick="selectAllEmployees()" class="text-primary hover:text-primary/90 text-sm font-medium">
                                Select All
                            </button>
                            <span class="text-gray400">|</span>
                            <button type="button" onclick="deselectAllEmployees()" class="text-primary hover:text-primary/90 text-sm font-medium">
                                Deselect All
                            </button>
                            <span class="text-gray400">|</span>
                            <button type="button" onclick="selectActiveOnly()" class="text-primary hover:text-primary/90 text-sm font-medium">
                                Active Only
                            </button>
                        </div>
                        
                        <!-- Employees Table -->
                        <div class="overflow-x-auto mb-6">
                            <table class="quickbooks-table">
                                <thead>
                                    <tr>
                                        <th class="w-12">
                                            <input type="checkbox" 
                                                   id="selectAllEmployees" 
                                                   class="quickbooks-checkbox">
                                        </th>
                                        <th>Employee</th>
                                        <th>Employee #</th>
                                        <th>Basic Salary</th>
                                        <th>Gross Salary</th>
                                        <th>NAPSA #</th>
                                        <th>NHIMA #</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($employees as $employee)
                                        <tr class="hover:bg-gray100 transition-colors">
                                            <td>
                                                <input type="checkbox" 
                                                       name="selected_employees[]" 
                                                       value="{{ $employee->id }}"
                                                       class="employee-checkbox quickbooks-checkbox"
                                                       data-salary="{{ $employee->gross_salary }}"
                                                       checked>
                                            </td>
                                            <td>
                                                <div class="flex items-center">
                                                    <div class="w-8 h-8 {{ $employee->is_active ? 'bg-primaryLight' : 'bg-gray200' }} rounded-full flex items-center justify-center mr-3">
                                                        <span class="{{ $employee->is_active ? 'text-primary' : 'text-gray600' }} font-semibold text-sm">
                                                            {{ strtoupper(substr($employee->first_name, 0, 1)) }}
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <div class="font-medium text-gray900">{{ $employee->first_name }} {{ $employee->last_name }}</div>
                                                        <div class="text-xs text-gray500">{{ $employee->email }}</div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="font-medium text-gray900">
                                                {{ $employee->employee_number }}
                                            </td>
                                            <td class="text-gray700 font-medium">
                                                {{ $company->currency_symbol ?? 'K' }}{{ number_format($employee->basic_salary, 2) }}
                                            </td>
                                            <td class="text-gray700 font-medium">
                                                {{ $company->currency_symbol ?? 'K' }}{{ number_format($employee->gross_salary, 2) }}
                                            </td>
                                            <td class="text-gray700">
                                                {{ $employee->napsa_number ?: '—' }}
                                            </td>
                                            <td class="text-gray700">
                                                {{ $employee->nhima_number ?: '—' }}
                                            </td>
                                            <td>
                                                @if($employee->is_active)
                                                    <span class="quickbooks-badge bg-green-100 text-green-800">Active</span>
                                                @else
                                                    <span class="quickbooks-badge bg-red-100 text-red-800">Inactive</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Summary -->
                        <div class="bg-gray50 p-4 rounded-lg mb-6">
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <div class="text-sm text-gray600 mb-1">Selected Employees</div>
                                    <div class="text-2xl font-semibold text-gray900" id="selectedCount">0</div>
                                </div>
                                <div>
                                    <div class="text-sm text-gray600 mb-1">Total Gross Salary</div>
                                    <div class="text-2xl font-semibold text-gray900" id="totalGrossSalary">{{ $company->currency_symbol ?? 'K' }}0.00</div>
                                </div>
                                <div>
                                    <div class="text-sm text-gray600 mb-1">Estimated PAYE</div>
                                    <div class="text-2xl font-semibold text-danger" id="estimatedPAYE">{{ $company->currency_symbol ?? 'K' }}0.00</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Form Actions -->
                        <div class="border-t border-gray200 pt-6">
                            <div class="flex justify-end space-x-3">
                                <a href="{{ route('admin.accounting.payroll.processing.index') }}" 
                                   class="px-4 py-2 border border-gray300 rounded text-sm font-medium text-gray700 hover:bg-gray50">
                                    Cancel
                                </a>
                                <button type="submit" 
                                        class="px-4 py-2 bg-primary text-white rounded text-sm font-medium hover:bg-primary/90"
                                        {{ !$payeSettings || !$napsaSettings || !$nhimaSettings || $employees->isEmpty() ? 'disabled' : '' }}>
                                    Calculate Payroll
                                </button>
                            </div>
                        </div>
                    </form>
                @endif
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize counts
            updateSummary();
            
            // Select all employees checkbox
            const selectAllCheckbox = document.getElementById('selectAllEmployees');
            if (selectAllCheckbox) {
                selectAllCheckbox.addEventListener('change', function() {
                    const checkboxes = document.querySelectorAll('.employee-checkbox');
                    checkboxes.forEach(checkbox => {
                        checkbox.checked = this.checked;
                    });
                    updateSummary();
                });
            }
            
            // Individual employee checkbox
            const employeeCheckboxes = document.querySelectorAll('.employee-checkbox');
            employeeCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', updateSummary);
            });
            
            // Update summary function
            function updateSummary() {
                const selectedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');
                const selectedCount = selectedCheckboxes.length;
                
                // Update count
                document.getElementById('selectedCount').textContent = selectedCount;
                
                // Calculate total gross salary
                let totalGross = 0;
                selectedCheckboxes.forEach(checkbox => {
                    const salary = parseFloat(checkbox.getAttribute('data-salary')) || 0;
                    totalGross += salary;
                });
                
                // Update total gross salary
                const currencySymbol = '{{ $company->currency_symbol ?? "K" }}';
                document.getElementById('totalGrossSalary').textContent = 
                    currencySymbol + totalGross.toFixed(2);
                
                // Estimate PAYE (simplified calculation - 25% of gross)
                const estimatedPAYE = totalGross * 0.25;
                document.getElementById('estimatedPAYE').textContent = 
                    currencySymbol + estimatedPAYE.toFixed(2);
                
                // Update select all checkbox
                if (selectAllCheckbox) {
                    const totalCheckboxes = employeeCheckboxes.length;
                    selectAllCheckbox.checked = selectedCount > 0 && selectedCount === totalCheckboxes;
                    selectAllCheckbox.indeterminate = selectedCount > 0 && selectedCount < totalCheckboxes;
                }
            }
        });
        
        // Quick action functions
        function selectAllEmployees() {
            const checkboxes = document.querySelectorAll('.employee-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = true;
            });
            updateSummary();
        }
        
        function deselectAllEmployees() {
            const checkboxes = document.querySelectorAll('.employee-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = false;
            });
            updateSummary();
        }
        
        function selectActiveOnly() {
            const checkboxes = document.querySelectorAll('.employee-checkbox');
            checkboxes.forEach(checkbox => {
                const row = checkbox.closest('tr');
                const statusBadge = row.querySelector('.quickbooks-badge');
                const isActive = statusBadge && statusBadge.textContent.includes('Active');
                checkbox.checked = isActive;
            });
            updateSummary();
        }
        
        // Form validation
        const form = document.getElementById('payrollForm');
        if (form) {
            form.addEventListener('submit', function(e) {
                const selectedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');
                if (selectedCheckboxes.length === 0) {
                    e.preventDefault();
                    showNotification('Please select at least one employee', 'error');
                }
            });
        }
        
        function showNotification(message, type = 'info') {
            const existing = document.querySelector('.quickbooks-notification');
            if (existing) existing.remove();

            const colors = {
                success: 'bg-success',
                error: 'bg-danger',
                info: 'bg-primary',
                warning: 'bg-warning'
            };

            const icons = {
                success: 'fa-check-circle',
                error: 'fa-exclamation-circle',
                info: 'fa-info-circle',
                warning: 'fa-exclamation-triangle'
            };

            const notification = document.createElement('div');
            notification.className = `quickbooks-notification fixed top-4 right-4 ${colors[type]} text-white px-4 py-3 rounded shadow-lg z-50 flex items-center animate-fade-in`;
            notification.innerHTML = `
                <i class="fas ${icons[type]} mr-2"></i>
                <span>${message}</span>
            `;

            document.body.appendChild(notification);

            setTimeout(() => {
                notification.classList.add('animate-fade-out');
                setTimeout(() => {
                    notification.remove();
                }, 300);
            }, 3000);
        }

        // Add animation styles
        const style = document.createElement('style');
        style.textContent = `
            @keyframes fadeIn {
                from { opacity: 0; transform: translateY(-10px); }
                to { opacity: 1; transform: translateY(0); }
            }
            @keyframes fadeOut {
                from { opacity: 1; transform: translateY(0); }
                to { opacity: 0; transform: translateY(-10px); }
            }
            .animate-fade-in {
                animation: fadeIn 0.3s ease-out;
            }
            .animate-fade-out {
                animation: fadeOut 0.3s ease-in;
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>