@php
    $pageTitle = 'Create Loan Product';
    $pageSubtitle = 'Add a new product with rates, fees, and penalties';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
        }
        .bg-primary { background-color: var(--zedbank-blue); }
        .hover\:bg-secondary:hover { background-color: var(--zedbank-blue-dark); }
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        .quickbooks-input-readonly { background-color: #F3F2F1; color: #605E5C; cursor: not-allowed; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        @include('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                    <form action="{{ route('admin.accounting.products.store') }}" method="POST">
                        @csrf
                        
                        <div class="p-6 space-y-8">
                            <section>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Basic Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Product Name *</label>
                                        <input type="text" name="product" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('product') }}">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Interest Method *</label>
                                        <select name="interest_method" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="reducing_balance" {{ old('interest_method', 'reducing_balance') == 'reducing_balance' ? 'selected' : '' }}>Reducing Balance</option>
                                            <option value="simple_interest" {{ old('interest_method') == 'simple_interest' ? 'selected' : '' }}>Simple Interest</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Status *</label>
                                        <select name="status" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="Active">Active</option>
                                            <option value="Inactive">Inactive</option>
                                        </select>
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Description *</label>
                                        <input type="text" name="details" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('details') }}">
                                    </div>
                                </div>
                            </section>

                            <section>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Interest Rates (%)</h3>
                                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Daily</label>
                                        <input type="number" step="0.01" name="dailyrate" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('dailyrate', 0) }}">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Weekly</label>
                                        <input type="number" step="0.01" name="weeklyrate" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('weeklyrate', 0) }}">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-bold text-blue-700 mb-2">Monthly *</label>
                                        <input type="number" step="0.01" name="monthlyrate" id="monthlyrate" required class="w-full border-2 border-blue-200 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('monthlyrate', 0) }}" oninput="computeYearlyRate()">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-400 mb-2">Yearly (Auto)</label>
                                        <input type="number" step="0.01" name="yearlyrate" id="yearlyrate" readonly class="w-full border border-gray-300 rounded-lg px-3 py-2 quickbooks-input-readonly" value="{{ old('yearlyrate', 0) }}">
                                    </div>
                                </div>
                            </section>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <section>
                                    <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Processing Fee</h3>
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Fee Amount/Rate</label>
                                            <input type="number" step="0.01" name="processing_fee" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('processing_fee', 0) }}">
                                        </div>
                                        <div class="flex items-center gap-4 text-sm text-gray-700">
                                            <label class="flex items-center"><input type="radio" name="processing_fee_basis" value="initial_amount" checked class="mr-2"> Initial Amt</label>
                                            <label class="flex items-center"><input type="radio" name="processing_fee_basis" value="outstanding_balance" class="mr-2"> Outstanding</label>
                                        </div>
                                    </div>
                                </section>
                                <section>
                                    <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Late Penalty</h3>
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Penalty Amount/Rate</label>
                                            <input type="number" step="0.01" name="penalty_rate" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="{{ old('penalty_rate', 0) }}">
                                        </div>
                                        <div>
                                            <select name="penalty_basis" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                                <option value="fixed">Fixed Amount</option>
                                                <option value="percentage_of_due">% of Due Amount</option>
                                                <option value="percentage_of_outstanding">% of Total Outstanding</option>
                                            </select>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>

                        <div class="bg-gray-50 px-6 py-4 border-t border-gray-200 rounded-b-lg flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.products.index') }}" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">Cancel</a>
                            <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-secondary transition font-semibold shadow-sm">
                                <i class="fas fa-save mr-2"></i> Post Product
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        function computeYearlyRate() {
            const monthly = parseFloat(document.getElementById('monthlyrate').value) || 0;
            document.getElementById('yearlyrate').value = (monthly * 12).toFixed(2);
        }
        document.addEventListener('DOMContentLoaded', computeYearlyRate);
    </script>
</body>
</html>