<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Leave Requests | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-cancel {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-cancel:hover {
            background-color: #D83B01;
            color: white;
        }
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        .balance-card {
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 8px;
            padding: 16px;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'My Leave Requests', 'subtitle' => 'Apply for and manage your leave requests'])

        <main class="p-6">
            <!-- Leave Balances -->
            @if($leaveBalances->count() > 0)
            <div class="mb-6">
                <h2 class="text-lg font-semibold text-gray900 mb-4">Leave Balances ({{ date('Y') }})</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    @foreach($leaveBalances as $balance)
                    <div class="balance-card animate-fade-in">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <h3 class="text-sm font-semibold text-gray900">{{ $balance->leaveType->name }}</h3>
                                <p class="text-xs text-gray600">{{ $balance->leaveType->code }}</p>
                            </div>
                            <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-calendar-alt text-blue-600"></i>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between text-sm">
                                <span class="text-gray600">Accrued:</span>
                                <span class="font-medium text-gray900">{{ $balance->total_accrued }} days</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray600">Taken:</span>
                                <span class="font-medium text-red-600">{{ $balance->total_taken }} days</span>
                            </div>
                            <div class="flex justify-between text-sm font-semibold pt-2 border-t border-gray200">
                                <span class="text-gray700">Balance:</span>
                                <span class="text-green-600">{{ $balance->available_balance }} days</span>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Action Bar -->
            <div class="bg-white rounded-lg border border-gray200 p-4 mb-6">
                <div class="flex flex-col md:flex-row md:items-center justify-between space-y-4 md:space-y-0">
                    <div>
                        <h2 class="text-lg font-semibold text-gray900">Leave Requests</h2>
                        <p class="text-gray600 text-sm mt-1">{{ $leaveRequests->total() }} request(s) found</p>
                    </div>
                    <div class="flex space-x-3">
                        <!-- Filters -->
                        <div>
                            <select id="statusFilter" class="quickbooks-input w-40">
                                <option value="all">All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>
                        
                        <div>
                            <select id="typeFilter" class="quickbooks-input w-48">
                                <option value="all">All Leave Types</option>
                                @foreach($leaveTypes as $type)
                                    <option value="{{ $type->id }}" {{ request('leave_type_id') == $type->id ? 'selected' : '' }}>
                                        {{ $type->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div>
                            <select id="yearFilter" class="quickbooks-input w-32">
                                <option value="all">All Years</option>
                                @foreach($years as $year)
                                    <option value="{{ $year }}" {{ request('year') == $year ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <a href="{{ route('admin.accounting.self-service.leave.create') }}" 
                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                            <i class="fas fa-plus"></i>
                            New Request
                        </a>
                    </div>
                </div>
            </div>

            <!-- Leave Requests Table -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden animate-fade-in">
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Leave Type</th>
                                <th>Date Range</th>
                                <th>Duration</th>
                                <th>Reason</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($leaveRequests as $request)
                            <tr class="hover:bg-gray100 transition-colors">
                                <td>
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-lg 
                                            @if($request->status == 'approved') bg-green-100
                                            @elseif($request->status == 'pending') bg-yellow-100
                                            @elseif($request->status == 'rejected') bg-red-100
                                            @else bg-gray-100 @endif
                                            flex items-center justify-center">
                                            <i class="fas fa-calendar-alt 
                                                @if($request->status == 'approved') text-green-600
                                                @elseif($request->status == 'pending') text-yellow-600
                                                @elseif($request->status == 'rejected') text-red-600
                                                @else text-gray-600 @endif"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900">{{ $request->leaveType->name }}</div>
                                            <div class="text-xs text-gray500">{{ $request->leaveType->code }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">
                                        {{ \Carbon\Carbon::parse($request->start_date)->format('M d, Y') }}
                                    </div>
                                    <div class="text-xs text-gray600">
                                        to {{ \Carbon\Carbon::parse($request->end_date)->format('M d, Y') }}
                                    </div>
                                </td>
                                <td>
                                    <div class="font-medium text-gray900">{{ $request->total_days }} days</div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray700 max-w-xs truncate" title="{{ $request->reason }}">
                                        {{ strlen($request->reason) > 50 ? substr($request->reason, 0, 50) . '...' : $request->reason }}
                                    </div>
                                </td>
                                <td>
                                    <span class="quickbooks-badge 
                                        @if($request->status == 'approved') bg-green-100 text-green-800
                                        @elseif($request->status == 'pending') bg-yellow-100 text-yellow-800
                                        @elseif($request->status == 'rejected') bg-red-100 text-red-800
                                        @else bg-gray-100 text-gray-800 @endif">
                                        {{ ucfirst($request->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="flex items-center">
                                        <a href="{{ route('admin.accounting.self-service.leave.show', $request->id) }}" 
                                           class="action-btn action-btn-view"
                                           title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($request->canCancel())
                                        <form id="cancelForm{{ $request->id }}" 
                                              action="{{ route('admin.accounting.self-service.leave.cancel', $request->id) }}" 
                                              method="POST" 
                                              class="inline">
                                            @csrf
                                            <button type="button" 
                                                    onclick="confirmCancel({{ $request->id }}, '{{ $request->leaveType->name }}')"
                                                    class="action-btn action-btn-cancel"
                                                    title="Cancel Request">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center py-12">
                                    <div class="py-8 text-center">
                                        <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                            <i class="fas fa-calendar-alt text-gray500 text-2xl"></i>
                                        </div>
                                        <h3 class="text-lg font-medium text-gray900 mb-2">No leave requests found</h3>
                                        <p class="text-gray600 mb-6 max-w-md mx-auto">
                                            You haven't submitted any leave requests yet. Click the button below to apply for leave.
                                        </p>
                                        <a href="{{ route('admin.accounting.self-service.leave.create') }}" 
                                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2 mx-auto inline-flex">
                                            <i class="fas fa-plus"></i>
                                            Apply for Leave
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($leaveRequests->hasPages())
                <div class="px-6 py-4 border-t border-gray200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing {{ $leaveRequests->firstItem() }} to {{ $leaveRequests->lastItem() }} of {{ $leaveRequests->total() }} results
                        </div>
                        <div class="flex space-x-2">
                            @if($leaveRequests->onFirstPage())
                            <span class="px-3 py-1 bg-gray100 text-gray500 rounded text-sm">Previous</span>
                            @else
                            <a href="{{ $leaveRequests->previousPageUrl() }}" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">Previous</a>
                            @endif
                            
                            @foreach($leaveRequests->getUrlRange(1, $leaveRequests->lastPage()) as $page => $url)
                                @if($page == $leaveRequests->currentPage())
                                <span class="px-3 py-1 bg-primary text-white rounded text-sm">{{ $page }}</span>
                                @else
                                <a href="{{ $url }}" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">{{ $page }}</a>
                                @endif
                            @endforeach
                            
                            @if($leaveRequests->hasMorePages())
                            <a href="{{ $leaveRequests->nextPageUrl() }}" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">Next</a>
                            @else
                            <span class="px-3 py-1 bg-gray100 text-gray500 rounded text-sm">Next</span>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Filter functionality
            const statusFilter = document.getElementById('statusFilter');
            const typeFilter = document.getElementById('typeFilter');
            const yearFilter = document.getElementById('yearFilter');
            
            function applyFilters() {
                const status = statusFilter.value;
                const type = typeFilter.value;
                const year = yearFilter.value;
                let url = '{{ route("admin.accounting.self-service.leave.index") }}';
                let params = [];
                
                if (status !== 'all') {
                    params.push(`status=${status}`);
                }
                
                if (type !== 'all') {
                    params.push(`leave_type_id=${type}`);
                }
                
                if (year !== 'all') {
                    params.push(`year=${year}`);
                }
                
                if (params.length > 0) {
                    url += '?' + params.join('&');
                }
                
                window.location.href = url;
            }
            
            statusFilter.addEventListener('change', applyFilters);
            typeFilter.addEventListener('change', applyFilters);
            yearFilter.addEventListener('change', applyFilters);

            // Cancel confirmation
            window.confirmCancel = function(requestId, leaveType) {
                if (confirm(`Are you sure you want to cancel your ${leaveType} leave request? This action cannot be undone.`)) {
                    document.getElementById(`cancelForm${requestId}`).submit();
                }
            };

            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
    </script>
</body>
</html>