<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll Details | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .info-card {
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 8px;
            padding: 20px;
        }
        .earnings-table {
            border-collapse: collapse;
            width: 100%;
        }
        .earnings-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            padding: 10px 12px;
            border-bottom: 1px solid #EDEBE9;
        }
        .earnings-table td {
            padding: 10px 12px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 13px;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Payroll Details', 'subtitle' => $entry->payrollPeriod->period_name ?? 'Payroll Information'])

        <main class="p-6">
            <!-- Action Bar -->
            <div class="bg-white rounded-lg border border-gray200 p-4 mb-6">
                <div class="flex flex-col md:flex-row md:items-center justify-between space-y-4 md:space-y-0">
                    <div>
                        <h2 class="text-lg font-semibold text-gray900">Payroll Details</h2>
                        <p class="text-gray600 text-sm mt-1">{{ \Carbon\Carbon::parse($entry->period_start_date)->format('M d') }} - {{ \Carbon\Carbon::parse($entry->period_end_date)->format('M d, Y') }}</p>
                    </div>
                    <div class="flex space-x-3">
                        <a href="{{ route('admin.accounting.self-service.payrolls.index') }}" 
                           class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium flex items-center gap-2">
                            <i class="fas fa-arrow-left"></i>
                            Back to Payrolls
                        </a>
                        <a href="{{ route('admin.accounting.self-service.payrolls.payslip', $entry->id) }}" 
                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                            <i class="fas fa-download"></i>
                            Download Payslip
                        </a>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
                <!-- Employee Information -->
                <div class="info-card animate-fade-in">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-10 h-10 bg-primaryLight rounded-lg flex items-center justify-center">
                            <i class="fas fa-user-tie text-primary"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-semibold text-gray900">Employee Information</h3>
                            <p class="text-xs text-gray600">Personal details</p>
                        </div>
                    </div>
                    <div class="space-y-3">
                        <div>
                            <p class="text-xs text-gray600 mb-1">Employee Number</p>
                            <p class="text-sm font-medium text-gray900">{{ $employee->employee_number }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray600 mb-1">Name</p>
                            <p class="text-sm font-medium text-gray900">{{ $employee->first_name }} {{ $employee->last_name }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray600 mb-1">Department</p>
                            <p class="text-sm font-medium text-gray900">{{ $employee->department->name ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray600 mb-1">Position</p>
                            <p class="text-sm font-medium text-gray900">{{ $employee->position ?? 'N/A' }}</p>
                        </div>
                    </div>
                </div>

                <!-- Payroll Period Information -->
                <div class="info-card animate-fade-in" style="animation-delay: 0.1s">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar-alt text-blue-600"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-semibold text-gray900">Payroll Period</h3>
                            <p class="text-xs text-gray600">Period details</p>
                        </div>
                    </div>
                    <div class="space-y-3">
                        <div>
                            <p class="text-xs text-gray600 mb-1">Period Name</p>
                            <p class="text-sm font-medium text-gray900">{{ $entry->payrollPeriod->period_name ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray600 mb-1">Date Range</p>
                            <p class="text-sm font-medium text-gray900">
                                {{ \Carbon\Carbon::parse($entry->period_start_date)->format('M d, Y') }} - 
                                {{ \Carbon\Carbon::parse($entry->period_end_date)->format('M d, Y') }}
                            </p>
                        </div>
                        <div>
                            <p class="text-xs text-gray600 mb-1">Payment Date</p>
                            <p class="text-sm font-medium text-gray900">
                                {{ $entry->payment_date ? \Carbon\Carbon::parse($entry->payment_date)->format('M d, Y') : 'Not Paid' }}
                            </p>
                        </div>
                        <div>
                            <p class="text-xs text-gray600 mb-1">Status</p>
                            <span class="quickbooks-badge 
                                @if($entry->calculation_status == 'paid') bg-green-100 text-green-800
                                @elseif($entry->calculation_status == 'approved') bg-blue-100 text-blue-800
                                @elseif($entry->calculation_status == 'calculated') bg-yellow-100 text-yellow-800
                                @else bg-gray-100 text-gray-800 @endif">
                                {{ ucfirst($entry->calculation_status) }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Summary Card -->
                <div class="info-card animate-fade-in" style="animation-delay: 0.2s">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-chart-pie text-green-600"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-semibold text-gray900">Payroll Summary</h3>
                            <p class="text-xs text-gray600">Financial overview</p>
                        </div>
                    </div>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center">
                            <p class="text-xs text-gray600">Gross Earnings</p>
                            <p class="text-sm font-bold text-gray900">
                                {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->gross_earnings, 2) }}
                            </p>
                        </div>
                        <div class="flex justify-between items-center">
                            <p class="text-xs text-gray600">Total Deductions</p>
                            <p class="text-sm font-bold text-red-600">
                                {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->total_deductions, 2) }}
                            </p>
                        </div>
                        <div class="pt-3 border-t border-gray200">
                            <div class="flex justify-between items-center">
                                <p class="text-sm font-semibold text-gray700">Net Pay</p>
                                <p class="text-lg font-bold text-green-600">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->net_pay, 2) }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Earnings Breakdown -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden mb-6">
                <div class="px-6 py-4 border-b border-gray200">
                    <h3 class="text-lg font-semibold text-gray900">Earnings Breakdown</h3>
                    <p class="text-gray600 text-sm mt-1">Detailed breakdown of all earnings</p>
                </div>
                <div class="p-6">
                    <div class="overflow-x-auto">
                        <table class="earnings-table">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Name</th>
                                    <th>Amount</th>
                                    <th>Tax Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($earningsBreakdown as $earning)
                                <tr class="hover:bg-gray50">
                                    <td>
                                        <span class="quickbooks-badge 
                                            @if($earning['type'] == 'recurring') bg-blue-100 text-blue-800
                                            @else bg-yellow-100 text-yellow-800 @endif">
                                            {{ ucfirst(str_replace('_', ' ', $earning['type'])) }}
                                        </span>
                                    </td>
                                    <td class="font-medium text-gray900">{{ $earning['name'] }}</td>
                                    <td class="font-medium text-gray900">
                                        {{ $company->currency_symbol ?? 'K' }}{{ $earning['amount'] }}
                                    </td>
                                    <td>
                                        <span class="quickbooks-badge 
                                            @if($earning['taxable']) bg-red-100 text-red-800
                                            @else bg-green-100 text-green-800 @endif">
                                            {{ $earning['taxable_text'] }}
                                        </span>
                                    </td>
                                </tr>
                                @endforeach
                                <tr class="bg-gray50">
                                    <td colspan="2" class="font-bold text-gray900">Total Earnings</td>
                                    <td class="font-bold text-gray900">
                                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->gross_earnings, 2) }}
                                    </td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Deductions Breakdown -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Statutory Deductions -->
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray200">
                        <h3 class="text-lg font-semibold text-gray900">Statutory Deductions</h3>
                        <p class="text-gray600 text-sm mt-1">Government-mandated deductions</p>
                    </div>
                    <div class="p-6">
                        <div class="space-y-4">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-percentage text-red-600"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-gray900">PAYE Tax</p>
                                        <p class="text-xs text-gray600">Income tax</p>
                                    </div>
                                </div>
                                <p class="text-sm font-bold text-red-600">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->paye_tax, 2) }}
                                </p>
                            </div>
                            <div class="flex justify-between items-center">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-shield-alt text-purple-600"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-gray900">NAPSA</p>
                                        <p class="text-xs text-gray600">Pension contribution</p>
                                    </div>
                                </div>
                                <p class="text-sm font-bold text-purple-600">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->napsa_employee, 2) }}
                                </p>
                            </div>
                            <div class="flex justify-between items-center">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-heartbeat text-green-600"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-gray900">NHIMA</p>
                                        <p class="text-xs text-gray600">Medical insurance</p>
                                    </div>
                                </div>
                                <p class="text-sm font-bold text-green-600">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->nhima_employee, 2) }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Summary -->
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray200">
                        <h3 class="text-lg font-semibold text-gray900">Deductions Summary</h3>
                        <p class="text-gray600 text-sm mt-1">Total deductions breakdown</p>
                    </div>
                    <div class="p-6">
                        <div class="space-y-4">
                            <div class="flex justify-between items-center">
                                <p class="text-sm text-gray600">PAYE Tax</p>
                                <p class="text-sm font-medium text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->paye_tax, 2) }}
                                </p>
                            </div>
                            <div class="flex justify-between items-center">
                                <p class="text-sm text-gray600">NAPSA</p>
                                <p class="text-sm font-medium text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->napsa_employee, 2) }}
                                </p>
                            </div>
                            <div class="flex justify-between items-center">
                                <p class="text-sm text-gray600">NHIMA</p>
                                <p class="text-sm font-medium text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->nhima_employee, 2) }}
                                </p>
                            </div>
                            <div class="pt-4 border-t border-gray200">
                                <div class="flex justify-between items-center">
                                    <p class="text-sm font-semibold text-gray700">Total Deductions</p>
                                    <p class="text-lg font-bold text-red-600">
                                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->total_deductions, 2) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
    </script>
</body>
</html>