<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Account Type | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'View Account Type', 'subtitle' => 'Account type details'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Account Type Details</h2>
                        <p class="text-gray-600">View detailed information about this account type</p>
                    </div>

                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Name -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $accountType->name }}
                                </div>
                            </div>

                            <!-- Account Group -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Account Group</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $accountType->accountGroup->name ?? 'N/A' }}
                                    @if($accountType->accountGroup && $accountType->accountGroup->primaryCategory)
                                        <span class="text-gray-500"> - {{ $accountType->accountGroup->primaryCategory->name }}</span>
                                    @endif
                                </div>
                            </div>

                            <!-- Normal Balance -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Normal Balance</label>
                                @php
                                    $balanceColors = [
                                        'debit' => 'bg-blue-100 text-blue-800',
                                        'credit' => 'bg-green-100 text-green-800'
                                    ];
                                @endphp
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $balanceColors[$accountType->normal_balance] ?? 'bg-gray-100 text-gray-800' }}">
                                    {{ ucfirst($accountType->normal_balance) }}
                                </span>
                            </div>

                            <!-- Status -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $accountType->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $accountType->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>

                            <!-- Chart of Accounts Count -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Chart of Accounts</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $accountType->chartOfAccounts->count() }} accounts
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-3 rounded-lg border min-h-[80px]">
                                    {{ $accountType->description ?: 'No description provided' }}
                                </div>
                            </div>

                            <!-- Created/Updated Info -->
                            <div class="md:col-span-2 border-t pt-6 mt-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
                                    <div>
                                        <span class="font-medium">Created:</span> 
                                        {{ $accountType->created_at->format('M j, Y g:i A') }}
                                    </div>
                                    <div>
                                        <span class="font-medium">Last Updated:</span> 
                                        {{ $accountType->updated_at->format('M j, Y g:i A') }}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="mt-8 flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.settings.account-types.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                Back to List
                            </a>
                            <a href="{{ route('admin.accounting.settings.account-types.edit', $accountType->id) }}" 
                               class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                Edit Account Type
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>