<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Close Financial Year | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Close Financial Year', 'subtitle' => 'Close financial year and prevent further transactions'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border border-yellow-200">
                    <!-- Warning Header -->
                    <div class="p-6 border-b border-yellow-200 bg-yellow-50 rounded-t-xl">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-triangle text-yellow-500 text-2xl mr-3"></i>
                            <div>
                                <h2 class="text-xl font-bold text-yellow-800">Close Financial Year</h2>
                                <p class="text-yellow-700">This action will prevent any further transactions for this financial year</p>
                            </div>
                        </div>
                    </div>

                    <!-- Financial Year Details -->
                    <div class="p-6 border-b border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Financial Year Details</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Year</label>
                                <div class="mt-1 text-sm text-gray-900">{{ $financialYear->year_name }}</div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Period</label>
                                <div class="mt-1 text-sm text-gray-900">
                                    {{ $financialYear->start_date->format('F j, Y') }} to {{ $financialYear->end_date->format('F j, Y') }}
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Journal Entries</label>
                                <div class="mt-1 text-sm text-gray-900">{{ $financialYear->journalEntries->count() }} entries</div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Current Status</label>
                                <div class="mt-1">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        Open
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Closure Information -->
                    <div class="p-6 border-b border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">What happens when you close a financial year?</h3>
                        <ul class="list-disc list-inside space-y-2 text-sm text-gray-700">
                            <li>No new journal entries can be posted for this period</li>
                            <li>Existing transactions cannot be modified</li>
                            <li>Financial reports become final for this period</li>
                            <li>Opening balances for the next period are calculated</li>
                            <li>This action is reversible but should be done with caution</li>
                        </ul>
                    </div>

                    <!-- Close Form -->
                    <form action="{{ route('admin.accounting.settings.financial-years.close', $financialYear->id) }}" method="POST" class="p-6">
                        @csrf

                        <!-- Confirmation -->
                        <div class="mb-6">
                            <label for="confirmation" class="block text-sm font-medium text-gray-700 mb-2">
                                Type "CLOSE_YEAR" to confirm
                            </label>
                            <input type="text" 
                                   name="confirmation" 
                                   id="confirmation"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500"
                                   placeholder="CLOSE_YEAR"
                                   required>
                            @error('confirmation')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Final Warning -->
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
                            <div class="flex">
                                <i class="fas fa-exclamation-circle text-red-400 mt-0.5 mr-3"></i>
                                <div>
                                    <h4 class="text-sm font-medium text-red-800">Important Notice</h4>
                                    <p class="text-sm text-red-700 mt-1">
                                        This action cannot be undone automatically. Please ensure all transactions for this period are complete and verified before proceeding.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.settings.financial-years.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                Cancel
                            </a>
                            <button type="submit" 
                                    class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 flex items-center space-x-2"
                                    onclick="return confirm('Are you absolutely sure you want to close this financial year? This action is critical and should only be performed at the end of the accounting period.')">
                                <i class="fas fa-lock"></i>
                                <span>Close Financial Year</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const confirmationInput = document.getElementById('confirmation');
            const submitButton = document.querySelector('button[type="submit"]');
            
            // Initially disable submit button
            submitButton.disabled = true;
            submitButton.classList.add('opacity-50', 'cursor-not-allowed');
            
            confirmationInput.addEventListener('input', function() {
                if (this.value === 'CLOSE_YEAR') {
                    submitButton.disabled = false;
                    submitButton.classList.remove('opacity-50', 'cursor-not-allowed');
                } else {
                    submitButton.disabled = true;
                    submitButton.classList.add('opacity-50', 'cursor-not-allowed');
                }
            });
        });
    </script>
</body>
</html>