@php
    $pageTitle = 'View Loan Application';
    $pageSubtitle = 'Details for application: ' . $application->application_number;
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        :root { 
            --zedbank-blue: {{ $themeBlue }}; 
            --zedbank-blue-dark: {{ $themeBlueDark }}; 
        }
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        .compact-input { padding: 10px 14px; font-size: 0.875rem; }
        .compact-label { font-size: 0.875rem; }
        .detail-label { font-size: 0.75rem; color: #6b7280; }
        .detail-value { font-size: 0.875rem; font-weight: 600; }
        
        .loading-spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #0077C5;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .backdate-warning {
            display: none;
            animation: fadeIn 0.3s ease-in;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .date-info-text {
            font-size: 0.75rem;
            color: #6b7280;
            margin-top: 0.25rem;
        }
        
        /* Modal styles */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 50;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: white;
            border-radius: 0.5rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            max-height: 90vh;
            overflow-y: auto;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .status-badge i {
            margin-right: 0.25rem;
        }
        
        /* Quick Actions Container */
        .quick-actions-container {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
            align-items: center;
        }
        
        @media (max-width: 768px) {
            .quick-actions-container {
                margin-top: 1rem;
                width: 100%;
            }
        }
        
        .quick-action-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            font-size: 0.875rem;
            white-space: nowrap;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        @include('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle])

        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                <!-- Top Section with Back Button and Quick Actions -->
                <div class="mb-6 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                    <!-- Back Button -->
                    <a href="{{ route('admin.applications.index') }}" class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark font-medium w-fit">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Applications
                    </a>
                    
                    <!-- Quick Actions - Horizontal on right -->
                    <div class="quick-actions-container">
                        <button onclick="showUploadModal()" 
                                class="quick-action-btn bg-zedbank-blue text-white hover:bg-zedbank-blue-dark">
                            <i class="fas fa-upload mr-2"></i> Upload Documents
                        </button>
                        
                        <a href="{{ route('admin.applications.schedule.view', $application->id) }}" 
                           class="quick-action-btn border border-blue-300 text-blue-700 bg-blue-50 hover:bg-blue-100">
                            <i class="fas fa-calendar-alt mr-2"></i> View Schedule
                        </a>
                        
                        <a href="{{ route('admin.applications.schedule.pdf', $application->id) }}" 
                           class="quick-action-btn border border-green-300 text-green-700 bg-green-50 hover:bg-green-100">
                            <i class="fas fa-file-pdf mr-2"></i> Download PDF
                        </a>
                        
                        @if($application->status == 'approved' && !$application->disbursed_at)
                            <a href="{{ route('admin.applications.disburse', $application->id) }}" 
                               class="quick-action-btn bg-zedbank-blue text-white hover:bg-zedbank-blue-dark">
                                <i class="fas fa-money-bill-wave mr-2"></i> Process Disbursement
                            </a>
                        @endif
                        
                        @if($application->status == 'submitted' || $application->status == 'under_review')
                            <div class="flex gap-2">
                                <form action="{{ route('admin.applications.approve', $application->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" 
                                            onclick="return confirm('Are you sure you want to approve this application?')"
                                            class="quick-action-btn bg-green-600 text-white hover:bg-green-700">
                                        <i class="fas fa-check mr-2"></i> Approve
                                    </button>
                                </form>
                                <form action="{{ route('admin.applications.reject', $application->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" 
                                            onclick="return confirm('Are you sure you want to reject this application?')"
                                            class="quick-action-btn bg-red-600 text-white hover:bg-red-700">
                                        <i class="fas fa-times mr-2"></i> Reject
                                    </button>
                                </form>
                            </div>
                        @endif
                        
                        @if($application->status != 'disbursed')
                            <a href="{{ route('admin.applications.edit', $application->id) }}" 
                               class="quick-action-btn bg-gray-800 text-white hover:bg-gray-900">
                                <i class="fas fa-edit mr-2"></i> Edit Application
                            </a>
                        @endif
                    </div>
                </div>

                {{-- Display validation errors --}}
                @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <i class="fas fa-exclamation-triangle text-red-500"></i>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">
                                There were {{ $errors->count() }} error(s) with your submission
                            </h3>
                            <div class="mt-2 text-sm text-red-700">
                                <ul class="list-disc pl-5 space-y-1">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                {{-- Application Status Alert --}}
                <div class="mb-6">
                    @php
                        $statusColors = [
                            'submitted' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-800', 'icon' => 'fa-paper-plane'],
                            'under_review' => ['bg' => 'bg-yellow-100', 'text' => 'text-yellow-800', 'icon' => 'fa-clock'],
                            'approved' => ['bg' => 'bg-green-100', 'text' => 'text-green-800', 'icon' => 'fa-check-circle'],
                            'rejected' => ['bg' => 'bg-red-100', 'text' => 'text-red-800', 'icon' => 'fa-times-circle'],
                            'disbursed' => ['bg' => 'bg-purple-100', 'text' => 'text-purple-800', 'icon' => 'fa-money-check-alt'],
                        ];
                        $status = $application->status ?? 'submitted';
                        $color = $statusColors[$status] ?? $statusColors['submitted'];
                    @endphp
                    <div class="flex items-center justify-between p-4 {{ $color['bg'] }} border border-{{ str_replace('bg-', '', $color['bg']) }}-200 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas {{ $color['icon'] }} text-xl {{ $color['text'] }} mr-3"></i>
                            <div>
                                <h3 class="text-lg font-bold {{ $color['text'] }}">Application Status: {{ ucfirst(str_replace('_', ' ', $status)) }}</h3>
                                <p class="text-sm {{ $color['text'] }} opacity-90">
                                    @if($status == 'approved')
                                        Approved on {{ $application->approved_at->format('M d, Y') }} by {{ $application->reviewedBy->name ?? 'Admin' }}
                                    @elseif($status == 'disbursed')
                                        Disbursed on {{ $application->disbursed_at->format('M d, Y') }} by {{ $application->disbursedBy->name ?? 'Admin' }}
                                    @else
                                        Created on {{ $application->created_at->format('M d, Y') }} by {{ $application->createdBy->name ?? 'Admin' }}
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- MAIN CONTENT SECTIONS - ALL FULL WIDTH --}}
                <div class="space-y-6">
                    
                    {{-- CARD 1: CUSTOMER INFORMATION --}}
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                <i class="fas fa-user mr-3 text-zedbank-blue"></i>
                                Customer Information
                            </h2>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="detail-label">Customer Number</p>
                                    <p class="detail-value">{{ $application->customer->customer_number ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Full Name</p>
                                    <p class="detail-value">{{ $application->customer->first_name ?? '' }} {{ $application->customer->surname ?? '' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">NRC Number</p>
                                    <p class="detail-value">{{ $application->customer->number ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Phone Number</p>
                                    <p class="detail-value">{{ $application->customer->phone ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Email Address</p>
                                    <p class="detail-value">{{ $application->customer->email ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Physical Address</p>
                                    <p class="detail-value">{{ $application->customer->address ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Town/Province</p>
                                    <p class="detail-value">{{ $application->customer->town ?? 'N/A' }}, {{ $application->customer->province ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- CARD 2: LOAN DETAILS --}}
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                <i class="fas fa-file-invoice-dollar mr-3 text-zedbank-blue"></i>
                                Loan Details
                            </h2>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <p class="detail-label">Application Number</p>
                                    <p class="detail-value font-bold">{{ $application->application_number }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Loan Product</p>
                                    <p class="detail-value">{{ $application->product->product ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Currency</p>
                                    <p class="detail-value">{{ $application->currency->code ?? 'ZMW' }} ({{ $application->currency->symbol ?? 'ZMW' }})</p>
                                </div>
                                <div>
                                    <p class="detail-label">Loan Amount</p>
                                    <p class="detail-value font-bold text-green-600">
                                        {{ $application->currency->symbol ?? 'ZMW' }} {{ number_format($application->loan_amount, 2) }}
                                    </p>
                                </div>
                                <div>
                                    <p class="detail-label">Interest Rate</p>
                                    <p class="detail-value">{{ number_format($application->interest_rate, 2) }}% per {{ $application->payment_frequency }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Loan Term</p>
                                    <p class="detail-value">{{ $application->loan_tenure }} 
                                        @if($application->payment_frequency === 'monthly')
                                            Months
                                        @elseif($application->payment_frequency === 'weekly')
                                            Weeks
                                        @elseif($application->payment_frequency === 'daily')
                                            Days
                                        @else
                                            Periods
                                        @endif
                                    </p>
                                </div>
                                <div>
                                    <p class="detail-label">Payment Frequency</p>
                                    <p class="detail-value">{{ ucfirst(str_replace('_', ' ', $application->payment_frequency)) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Interest Method</p>
                                    <p class="detail-value">{{ ucfirst(str_replace('_', ' ', $application->interest_method)) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Monthly Installment</p>
                                    <p class="detail-value font-bold">
                                        {{ $application->currency->symbol ?? 'ZMW' }} {{ number_format($application->installment_amount, 2) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- CARD 3: FEES AND PENALTIES --}}
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                <i class="fas fa-clipboard-list mr-3 text-zedbank-blue"></i>
                                Fees & Penalties
                            </h2>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                                <div>
                                    <p class="detail-label">Processing Fee</p>
                                    <p class="detail-value">{{ number_format($application->processing_fee, 2) }}% 
                                        ({{ str_replace('_', ' ', $application->processing_fee_basis) }})</p>
                                </div>
                                <div>
                                    <p class="detail-label">Admin Fee</p>
                                    <p class="detail-value">{{ $application->currency->symbol ?? 'ZMW' }} {{ number_format($application->adminfee, 2) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Insurance Fee</p>
                                    <p class="detail-value">{{ $application->currency->symbol ?? 'ZMW' }} {{ number_format($application->insurancefee, 2) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Penalty Rate</p>
                                    <p class="detail-value">{{ number_format($application->penalty_rate, 2) }}% 
                                        ({{ str_replace('_', ' ', $application->penalty_basis) }})</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- CARD 4: EMPLOYMENT DETAILS --}}
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                <i class="fas fa-briefcase mr-3 text-zedbank-blue"></i>
                                Employment Details
                            </h2>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="detail-label">Job Title</p>
                                    <p class="detail-value">{{ $application->job_title ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Employer Name</p>
                                    <p class="detail-value">{{ $application->employer_name ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Employment Type</p>
                                    <p class="detail-value">{{ ucfirst(str_replace('_', ' ', $application->employment_type ?? 'N/A')) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Employee Number</p>
                                    <p class="detail-value">{{ $application->employee_number ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Years of Employment</p>
                                    <p class="detail-value">{{ $application->employment_years ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Gross Salary</p>
                                    <p class="detail-value">{{ $application->currency->symbol ?? 'ZMW' }} {{ number_format($application->gross_salary, 2) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Net Salary</p>
                                    <p class="detail-value">{{ $application->currency->symbol ?? 'ZMW' }} {{ number_format($application->net_salary, 2) }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Contract Expiry Date</p>
                                    <p class="detail-value">{{ $application->contract_expiry_date ? \Carbon\Carbon::parse($application->contract_expiry_date)->format('M d, Y') : 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <p class="detail-label font-medium mb-2">Employer Address</p>
                                <p class="detail-value">{{ $application->employer_physical_address ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>

                    {{-- CARD 5: NEXT OF KIN DETAILS --}}
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                <i class="fas fa-users mr-3 text-zedbank-blue"></i>
                                Next of Kin Details
                            </h2>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="detail-label">Full Name</p>
                                    <p class="detail-value">{{ $application->kin_first_name ?? '' }} {{ $application->kin_surname ?? '' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Relationship</p>
                                    <p class="detail-value">{{ ucfirst($application->kin_relationship ?? 'N/A') }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Phone Number</p>
                                    <p class="detail-value">{{ $application->kin_telephone ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Email Address</p>
                                    <p class="detail-value">{{ $application->kin_email ?? 'N/A' }}</p>
                                </div>
                                <div class="md:col-span-2">
                                    <p class="detail-label">Physical Address</p>
                                    <p class="detail-value">{{ $application->kin_physical_address ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- CARD 6: DOCUMENT REQUIREMENTS --}}
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <div class="flex justify-between items-center">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-file-alt mr-3 text-zedbank-blue"></i>
                                    Document Requirements
                                </h2>
                                <span class="text-sm font-semibold px-3 py-1 bg-blue-100 text-blue-800 rounded-full">
                                    {{ $documentStats['total_documents'] ?? 0 }}/{{ $documentStats['total_requirements'] ?? 0 }}
                                </span>
                            </div>
                        </div>
                        <div class="p-4">
                            
                            @if(count($requirementsWithStatus ?? []) > 0)
                                <!-- Document Statistics -->
                                <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                                    <div class="bg-blue-50 border border-blue-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-blue-700">{{ $documentStats['mandatory_completed'] ?? 0 }}/{{ $documentStats['mandatory_requirements'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-blue-600">Mandatory</div>
                                    </div>
                                    <div class="bg-green-50 border border-green-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-green-700">{{ $documentStats['verified'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-green-600">Verified</div>
                                    </div>
                                    <div class="bg-yellow-50 border border-yellow-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-yellow-700">{{ $documentStats['pending'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-yellow-600">Pending</div>
                                    </div>
                                    <div class="bg-red-50 border border-red-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-red-700">{{ $documentStats['rejected'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-red-600">Rejected</div>
                                    </div>
                                </div>

                                <!-- Progress Bars -->
                                <div class="mb-6">
                                    <div class="flex justify-between text-sm mb-1">
                                        <span class="font-medium">Mandatory Completion</span>
                                        <span class="font-bold">{{ $documentStats['mandatory_completion'] ?? 0 }}%</span>
                                    </div>
                                    <div class="w-full bg-gray-200 rounded-full h-2.5">
                                        <div class="bg-green-600 h-2.5 rounded-full" style="width: {{ $documentStats['mandatory_completion'] ?? 0 }}%"></div>
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">
                                        {{ $documentStats['mandatory_completed'] ?? 0 }} of {{ $documentStats['mandatory_requirements'] ?? 0 }} mandatory documents verified
                                    </p>
                                </div>

                                <!-- Document Requirements Table -->
                                <div class="overflow-x-auto border border-gray-200 rounded-lg">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Document</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach($requirementsWithStatus as $index => $requirement)
                                                <tr class="{{ $requirement['is_mandatory'] ? 'bg-yellow-50' : 'hover:bg-gray-50' }}">
                                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">
                                                        {{ $index + 1 }}
                                                    </td>
                                                    <td class="px-4 py-3">
                                                        <div class="font-medium text-gray-900">{{ $requirement['name'] }}</div>
                                                        <div class="text-xs text-gray-500">{{ $requirement['description'] }}</div>
                                                        @if($requirement['has_document'])
                                                            <div class="text-xs text-gray-700 mt-1">
                                                                <i class="fas fa-file text-blue-500 mr-1"></i>
                                                                {{ $requirement['document']->file_name }}
                                                                <span class="text-gray-400 mx-1">•</span>
                                                                {{ $requirement['document']->formatted_file_size }}
                                                            </div>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        @if($requirement['is_mandatory'])
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                                <i class="fas fa-exclamation-circle mr-1"></i> Mandatory
                                                            </span>
                                                        @else
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                                <i class="fas fa-check-circle mr-1"></i> Optional
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        @if($requirement['status'] == 'verified')
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                                <i class="fas fa-check-circle mr-1"></i> Verified
                                                            </span>
                                                            @if($requirement['verified_by'] && $requirement['verified_at'])
                                                                <div class="text-xs text-gray-500 mt-1">
                                                                    <i class="fas fa-user-check mr-1"></i> {{ $requirement['verified_by'] }}
                                                                    <br>
                                                                    <i class="fas fa-calendar-alt mr-1"></i> {{ $requirement['verified_at'] }}
                                                                </div>
                                                            @endif
                                                        @elseif($requirement['status'] == 'pending')
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                                <i class="fas fa-clock mr-1"></i> Pending
                                                            </span>
                                                        @elseif($requirement['status'] == 'rejected')
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                                <i class="fas fa-times-circle mr-1"></i> Rejected
                                                            </span>
                                                            @if($requirement['rejection_reason'])
                                                                <div class="text-xs text-red-600 mt-1">
                                                                    <i class="fas fa-exclamation-circle mr-1"></i> {{ $requirement['rejection_reason'] }}
                                                                </div>
                                                            @endif
                                                        @else
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                                <i class="fas fa-exclamation-circle mr-1"></i> Not Attached
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium">
                                                        @if($requirement['has_document'])
                                                            <div class="flex space-x-2">
                                                                <a href="{{ route('admin.applications.view-document', ['id' => $application->id, 'document' => $requirement['document']->id]) }}" 
                                                                   class="inline-flex items-center px-3 py-1 border border-blue-300 text-blue-700 bg-blue-50 rounded hover:bg-blue-100"
                                                                   target="_blank"
                                                                   title="View Document">
                                                                    <i class="fas fa-eye mr-1"></i> View
                                                                </a>
                                                                <a href="{{ route('admin.applications.download-document', ['id' => $application->id, 'document' => $requirement['document']->id]) }}" 
                                                                   class="inline-flex items-center px-3 py-1 border border-green-300 text-green-700 bg-green-50 rounded hover:bg-green-100"
                                                                   title="Download Document">
                                                                    <i class="fas fa-download mr-1"></i> Download
                                                                </a>
                                                                
                                                                @if($requirement['status'] == 'rejected' || $requirement['status'] == 'pending')
                                                                    <button onclick="showReplaceModal({{ $requirement['document']->id }}, '{{ $requirement['name'] }}')"
                                                                            class="inline-flex items-center px-3 py-1 border border-orange-300 text-orange-700 bg-orange-50 rounded hover:bg-orange-100"
                                                                            title="Replace Document">
                                                                        <i class="fas fa-sync-alt mr-1"></i> Replace
                                                                    </button>
                                                                @endif
                                                                
                                                                @if($requirement['status'] == 'pending')
                                                                    <button onclick="verifyDocument({{ $requirement['document']->id }}, '{{ $requirement['name'] }}')"
                                                                            class="inline-flex items-center px-3 py-1 border border-green-600 text-green-700 bg-green-100 rounded hover:bg-green-200"
                                                                            title="Verify Document">
                                                                        <i class="fas fa-check mr-1"></i> Verify
                                                                    </button>
                                                                    <button onclick="showRejectModal({{ $requirement['document']->id }}, '{{ $requirement['name'] }}')"
                                                                            class="inline-flex items-center px-3 py-1 border border-red-600 text-red-700 bg-red-100 rounded hover:bg-red-200"
                                                                            title="Reject Document">
                                                                        <i class="fas fa-times mr-1"></i> Reject
                                                                    </button>
                                                                @endif
                                                            </div>
                                                        @else
                                                            <button onclick="showAttachModal({{ $requirement['requirement_id'] }})"
                                                                    class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                                                <i class="fas fa-paperclip mr-2"></i> Attach
                                                            </button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Summary Alert -->
                                <div class="mt-6 p-4 {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'bg-green-50 border border-green-200' : 'bg-yellow-50 border border-yellow-200' }} rounded-lg">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <i class="fas {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'fa-check-circle text-green-400' : 'fa-exclamation-triangle text-yellow-400' }}"></i>
                                        </div>
                                        <div class="ml-3 flex-1 md:flex md:justify-between">
                                            <div>
                                                <p class="text-sm font-medium {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'text-green-800' : 'text-yellow-800' }}">
                                                    @if(($documentStats['mandatory_completion'] ?? 0) == 100)
                                                        ✅ All mandatory documents are verified! This application meets the document requirements.
                                                    @else
                                                        ⚠️ {{ ($documentStats['mandatory_requirements'] ?? 0) - ($documentStats['mandatory_completed'] ?? 0) }} mandatory document(s) still need to be verified.
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="mt-3 md:mt-0 md:ml-6">
                                                <button onclick="showUploadModal()" 
                                                       class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'text-green-700 bg-green-100 hover:bg-green-200' : 'text-yellow-700 bg-yellow-100 hover:bg-yellow-200' }}">
                                                    <i class="fas fa-upload mr-2"></i> Upload Documents
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Check Eligibility Button -->
                                @if($application->status != 'disbursed')
                                    <div class="mt-6 text-center">
                                        <button onclick="checkApprovalEligibility()" 
                                                class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                            <i class="fas fa-clipboard-check mr-2"></i> Check Approval Eligibility
                                        </button>
                                    </div>
                                @endif

                            @else
                                <!-- No Requirements Message -->
                                <div class="text-center py-8">
                                    <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-blue-100">
                                        <i class="fas fa-info-circle text-blue-600 text-xl"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-gray-900">No Document Requirements</h3>
                                    <p class="mt-2 text-sm text-gray-500">
                                        This loan product does not have any document requirements configured.
                                    </p>
                                    <div class="mt-6">
                                        <button onclick="showUploadModal()" 
                                               class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700">
                                            <i class="fas fa-plus mr-2"></i> Upload Document
                                        </button>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    {{-- CARD 7: DISBURSEMENT INFORMATION (if disbursed) --}}
                    @if($application->disbursed_at)
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                <i class="fas fa-exchange-alt mr-3 text-zedbank-blue"></i>
                                Disbursement Information
                            </h2>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="detail-label">Disbursement Date</p>
                                    <p class="detail-value">{{ $application->disbursed_at->format('M d, Y') }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Disbursed By</p>
                                    <p class="detail-value">{{ $application->disbursedBy->name ?? 'Admin' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Loan Number</p>
                                    <p class="detail-value font-bold">{{ $application->loan_id ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="detail-label">Payment Method</p>
                                    <p class="detail-value">{{ $application->suggestedpaymentmethod ?? 'N/A' }}</p>
                                </div>
                                @if($application->suggestedpaymentmethod == 'Bank')
                                    <div class="md:col-span-2">
                                        <p class="detail-label">Bank Details</p>
                                        <p class="detail-value">
                                            {{ $application->bank_name ?? '' }} 
                                            @if($application->account_number)
                                                - Acc: {{ $application->account_number }}
                                            @endif
                                        </p>
                                    </div>
                                @endif
                                @if($application->suggestedpaymentmethod == 'Mobile')
                                    <div>
                                        <p class="detail-label">Mobile Channel</p>
                                        <p class="detail-value">{{ $application->mobile_channel ?? 'N/A' }}</p>
                                    </div>
                                    <div>
                                        <p class="detail-label">Mobile Number</p>
                                        <p class="detail-value">{{ $application->mobile_number ?? 'N/A' }}</p>
                                    </div>
                                @endif
                                @if($application->disbursement_notes)
                                    <div class="md:col-span-2">
                                        <p class="detail-label">Disbursement Notes</p>
                                        <p class="detail-value">{{ $application->disbursement_notes }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif

                    {{-- APPLICATION TIMELINE CARD --}}
                    <div class="bg-white rounded-xl shadow-sm border p-4">
                        <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-history mr-3 text-zedbank-blue"></i> Application Timeline
                        </h3>
                        <div class="space-y-4">
                            <div>
                                <p class="text-xs text-gray-500">Created</p>
                                <p class="text-sm font-medium">{{ $application->created_at->format('M d, Y H:i') }}</p>
                                <p class="text-xs text-gray-500">by {{ $application->createdBy->name ?? 'Admin' }}</p>
                            </div>
                            @if($application->submitted_at)
                            <div>
                                <p class="text-xs text-gray-500">Submitted</p>
                                <p class="text-sm font-medium">{{ $application->submitted_at->format('M d, Y H:i') }}</p>
                            </div>
                            @endif
                            @if($application->reviewed_at)
                            <div>
                                <p class="text-xs text-gray-500">Reviewed</p>
                                <p class="text-sm font-medium">{{ $application->reviewed_at->format('M d, Y H:i') }}</p>
                                <p class="text-xs text-gray-500">by {{ $application->reviewedBy->name ?? 'Admin' }}</p>
                            </div>
                            @endif
                            @if($application->approved_at)
                            <div>
                                <p class="text-xs text-gray-500">Approved</p>
                                <p class="text-sm font-medium">{{ $application->approved_at->format('M d, Y H:i') }}</p>
                            </div>
                            @endif
                            @if($application->disbursed_at)
                            <div>
                                <p class="text-xs text-gray-500">Disbursed</p>
                                <p class="text-sm font-medium">{{ $application->disbursed_at->format('M d, Y H:i') }}</p>
                                <p class="text-xs text-gray-500">by {{ $application->disbursedBy->name ?? 'Admin' }}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Document Upload Modal -->
    <div id="uploadDocumentModal" class="modal-overlay">
        <div class="modal-content w-full max-w-2xl mx-4">
            <form id="uploadDocumentForm" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-gray-900">Upload Document</h3>
                        <button type="button" onclick="hideUploadModal()" class="text-gray-400 hover:text-gray-500">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>
                    
                    <div class="space-y-4">
                        <!-- Hidden application ID -->
                        <input type="hidden" name="application_id" id="modalApplicationId" value="{{ $application->id }}">
                        
                        <!-- Requirement Selection -->
                        <div>
                            <label for="modal_requirement_id" class="block text-sm font-medium text-gray-700 mb-2">
                                Document Type *
                            </label>
                            <select name="requirement_id" 
                                    id="modal_requirement_id" 
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                    required>
                                <option value="">-- Select Document Type --</option>
                                @foreach($requirementsWithStatus as $requirement)
                                    @if(!$requirement['has_document'] || $requirement['status'] == 'rejected')
                                        <option value="{{ $requirement['requirement_id'] }}">
                                            {{ $requirement['name'] }}
                                            @if($requirement['is_mandatory'])
                                                (Mandatory)
                                            @endif
                                            @if($requirement['has_document'] && $requirement['status'] == 'rejected')
                                                - Replace Rejected
                                            @endif
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                            <p class="mt-1 text-sm text-gray-500">
                                Select the type of document to upload
                            </p>
                        </div>

                        <!-- File Upload with Drag & Drop -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Document File *
                            </label>
                            <div id="dropZone" 
                                 class="border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:border-blue-400 transition-colors duration-200 cursor-pointer">
                                <div class="space-y-2">
                                    <i class="fas fa-cloud-upload-alt text-4xl text-gray-400"></i>
                                    <div>
                                        <p class="text-sm text-gray-600">
                                            <span class="font-medium text-blue-600 hover:text-blue-500 cursor-pointer">
                                                Click to browse
                                            </span>
                                            or drag and drop
                                        </p>
                                        <p class="text-xs text-gray-500 mt-1">
                                            PDF, JPG, PNG, DOC, DOCX, XLS, XLSX up to 10MB
                                        </p>
                                    </div>
                                    <input type="file" 
                                           name="document" 
                                           id="modalDocument" 
                                           class="hidden" 
                                           accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx"
                                           required>
                                </div>
                            </div>
                            
                            <!-- File Preview -->
                            <div id="modalFilePreview" class="mt-3 hidden">
                                <div class="flex items-center justify-between bg-green-50 border border-green-200 rounded-lg p-3">
                                    <div class="flex items-center">
                                        <i class="fas fa-file text-green-500 mr-3 text-xl"></i>
                                        <div>
                                            <p id="modalFileName" class="font-medium text-green-800"></p>
                                            <p id="modalFileSize" class="text-sm text-green-600"></p>
                                        </div>
                                    </div>
                                    <button type="button" onclick="clearModalFile()" class="text-red-500 hover:text-red-700">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Notes -->
                        <div>
                            <label for="modal_notes" class="block text-sm font-medium text-gray-700 mb-2">
                                Notes (Optional)
                            </label>
                            <textarea name="notes" 
                                      id="modal_notes" 
                                      rows="3" 
                                      class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                      placeholder="Add any notes about this document..."></textarea>
                        </div>

                        <!-- Upload Progress -->
                        <div id="uploadProgress" class="hidden">
                            <div class="flex items-center space-x-3">
                                <div class="flex-1">
                                    <div class="w-full bg-gray-200 rounded-full h-2.5">
                                        <div id="progressBar" class="bg-green-600 h-2.5 rounded-full" style="width: 0%"></div>
                                    </div>
                                    <p id="progressText" class="text-sm text-gray-600 mt-1">Uploading...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                    <button type="button" 
                            onclick="hideUploadModal()"
                            class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                        Cancel
                    </button>
                    <button type="submit" 
                            id="uploadSubmitBtn"
                            class="px-4 py-2 bg-zedbank-blue text-white rounded-md hover:bg-zedbank-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 font-medium">
                        <i class="fas fa-upload mr-2"></i> Upload Document
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Replace Document Modal -->
    <div id="replaceDocumentModal" class="modal-overlay">
        <div class="modal-content w-full max-w-md mx-4">
            <form id="replaceDocumentForm" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="document_id" id="replaceDocumentId">
                <div class="p-6">
                    <div class="flex items-start">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100">
                            <i class="fas fa-exchange-alt text-blue-600"></i>
                        </div>
                        <div class="mt-0 ml-4">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Replace Document</h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-500 mb-4">
                                    You are replacing document: <span id="replaceDocName" class="font-semibold"></span>
                                </p>
                                
                                <!-- New File Upload -->
                                <div class="mb-4">
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        New Document File *
                                    </label>
                                    <div id="replaceDropZone" 
                                         class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-blue-400 transition-colors duration-200 cursor-pointer">
                                        <div class="space-y-2">
                                            <i class="fas fa-cloud-upload-alt text-3xl text-gray-400"></i>
                                            <div>
                                                <p class="text-sm text-gray-600">
                                                    <span class="font-medium text-blue-600 hover:text-blue-500 cursor-pointer">
                                                        Click to browse
                                                    </span>
                                                    or drag and drop
                                                </p>
                                                <p class="text-xs text-gray-500 mt-1">
                                                    PDF, JPG, PNG, DOC, DOCX, XLS, XLSX up to 10MB
                                                </p>
                                            </div>
                                            <input type="file" 
                                                   name="document" 
                                                   id="replaceDocument" 
                                                   class="hidden" 
                                                   accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx"
                                                   required>
                                        </div>
                                    </div>
                                    
                                    <!-- File Preview -->
                                    <div id="replaceFilePreview" class="mt-3 hidden">
                                        <div class="flex items-center justify-between bg-green-50 border border-green-200 rounded-lg p-3">
                                            <div class="flex items-center">
                                                <i class="fas fa-file text-green-500 mr-3"></i>
                                                <div>
                                                    <p id="replaceFileName" class="font-medium text-green-800"></p>
                                                    <p id="replaceFileSize" class="text-sm text-green-600"></p>
                                                </div>
                                            </div>
                                            <button type="button" onclick="clearReplaceFile()" class="text-red-500 hover:text-red-700">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Notes -->
                                <div class="mb-4">
                                    <label for="replace_notes" class="block text-sm font-medium text-gray-700 mb-2">
                                        Notes (Optional)
                                    </label>
                                    <textarea name="notes" 
                                              id="replace_notes" 
                                              rows="2" 
                                              class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                              placeholder="Notes about the replacement..."></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                    <button type="button" 
                            onclick="hideReplaceModal()"
                            class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                        Cancel
                    </button>
                    <button type="submit" 
                            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 font-medium">
                        <i class="fas fa-sync-alt mr-2"></i> Replace Document
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Reject Document Modal -->
    <div id="rejectModal" class="modal-overlay">
        <div class="modal-content w-full max-w-md mx-4">
            <form id="rejectForm" method="POST">
                @csrf
                <div class="p-6">
                    <div class="flex items-start">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                            <i class="fas fa-times text-red-600"></i>
                        </div>
                        <div class="mt-0 ml-4">
                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="rejectModalTitle">Reject Document</h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-500 mb-4">
                                    You are about to reject document: <span id="rejectDocName" class="font-semibold"></span>
                                </p>
                                <input type="hidden" name="document_id" id="rejectDocId">
                                
                                <div class="mb-4">
                                    <label for="rejection_reason" class="block text-sm font-medium text-gray-700 mb-2">Rejection Reason *</label>
                                    <textarea name="rejection_reason" id="rejection_reason" rows="3" 
                                              class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                              placeholder="Please provide a reason for rejecting this document..."
                                              required></textarea>
                                </div>
                                
                                <div class="mb-4">
                                    <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Additional Notes (Optional)</label>
                                    <textarea name="notes" id="notes" rows="2" 
                                              class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                              placeholder="Any additional notes..."></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                    <button type="button" 
                            onclick="hideRejectModal()"
                            class="inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:text-sm">
                        Cancel
                    </button>
                    <button type="submit" 
                            class="inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:text-sm">
                        <i class="fas fa-times mr-2"></i> Reject Document
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Success Notification -->
    <div id="successNotification" class="fixed top-4 right-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded shadow-lg z-50 hidden transition-all duration-300 ease-in-out">
        <div class="flex">
            <div class="py-1">
                <i class="fas fa-check-circle mr-3 text-green-500"></i>
            </div>
            <div>
                <p class="font-bold" id="successTitle"></p>
                <p class="text-sm" id="successMessage"></p>
            </div>
            <button onclick="hideNotification('successNotification')" class="ml-4 text-green-700 hover:text-green-900">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>

    <!-- Error Notification -->
    <div id="errorNotification" class="fixed top-4 right-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded shadow-lg z-50 hidden transition-all duration-300 ease-in-out">
        <div class="flex">
            <div class="py-1">
                <i class="fas fa-exclamation-triangle mr-3 text-red-500"></i>
            </div>
            <div>
                <p class="font-bold" id="errorTitle"></p>
                <p class="text-sm" id="errorMessage"></p>
            </div>
            <button onclick="hideNotification('errorNotification')" class="ml-4 text-red-700 hover:text-red-900">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>
<script>
    // Document Management Functions
    function verifyDocument(documentId, documentName) {
        if (confirm(`Are you sure you want to verify "${documentName}"?`)) {
            showNotification('Processing...', 'Verifying document...', 'info');
            
            // Add a loading spinner to the verify button
            const verifyBtn = event.target;
            const originalHTML = verifyBtn.innerHTML;
            verifyBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Verifying...';
            verifyBtn.disabled = true;
            
            $.ajax({
                url: '{{ url("admin/applications/") }}/' + {{ $application->id }} + '/documents/' + documentId + '/verify',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    notes: 'Document verified by admin'
                },
                success: function(response) {
                    if (response.success) {
                        showNotification('Document Verified', response.message, 'success');
                        // Reload the page to show updated status
                        setTimeout(() => {
                            location.reload();
                        }, 1500);
                    } else {
                        showNotification('Verification Failed', response.message, 'error');
                        verifyBtn.innerHTML = originalHTML;
                        verifyBtn.disabled = false;
                    }
                },
                error: function(xhr) {
                    console.error('Error verifying document:', xhr);
                    let errorMessage = 'Failed to verify document. Please try again.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    showNotification('Error', errorMessage, 'error');
                    verifyBtn.innerHTML = originalHTML;
                    verifyBtn.disabled = false;
                }
            });
        }
    }

    function showRejectModal(documentId, documentName) {
        document.getElementById('rejectDocId').value = documentId;
        document.getElementById('rejectDocName').textContent = documentName;
        document.getElementById('rejectModal').style.display = 'flex';
        document.getElementById('rejection_reason').focus();
    }

    function hideRejectModal() {
        document.getElementById('rejectModal').style.display = 'none';
        document.getElementById('rejectForm').reset();
    }

    // Handle reject form submission
    document.getElementById('rejectForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const documentId = document.getElementById('rejectDocId').value;
        const documentName = document.getElementById('rejectDocName').textContent;
        const formData = new FormData(this);
        
        showNotification('Processing...', 'Rejecting document...', 'info');
        
        // Disable submit button
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalBtnText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processing...';
        submitBtn.disabled = true;
        
        $.ajax({
            url: '{{ url("admin/applications/") }}/' + {{ $application->id }} + '/documents/' + documentId + '/reject',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                hideRejectModal();
                showNotification('Document Rejected', 'Document has been rejected successfully.', 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            },
            error: function(xhr) {
                hideRejectModal();
                let errorMessage = 'Failed to reject document. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                showNotification('Error', errorMessage, 'error');
                submitBtn.innerHTML = originalBtnText;
                submitBtn.disabled = false;
            }
        });
    });

    // Document Upload Modal Functions
    function showUploadModal(requirementId = '') {
        const modal = document.getElementById('uploadDocumentModal');
        const requirementSelect = document.getElementById('modal_requirement_id');
        
        // Reset form
        document.getElementById('uploadDocumentForm').reset();
        document.getElementById('modalFilePreview').classList.add('hidden');
        document.getElementById('uploadProgress').classList.add('hidden');
        document.getElementById('progressBar').style.width = '0%';
        document.getElementById('progressText').textContent = 'Uploading...';
        
        // Set requirement if provided
        if (requirementId) {
            requirementSelect.value = requirementId;
        }
        
        modal.style.display = 'flex';
        
        // Focus on requirement select
        setTimeout(() => {
            if (!requirementId) {
                requirementSelect.focus();
            }
        }, 100);
    }

    function hideUploadModal() {
        document.getElementById('uploadDocumentModal').style.display = 'none';
    }

    function showReplaceModal(documentId, documentName) {
        document.getElementById('replaceDocumentId').value = documentId;
        document.getElementById('replaceDocName').textContent = documentName;
        document.getElementById('replaceDocumentModal').style.display = 'flex';
        
        // Reset form
        document.getElementById('replaceDocumentForm').reset();
        document.getElementById('replaceFilePreview').classList.add('hidden');
    }

    function hideReplaceModal() {
        document.getElementById('replaceDocumentModal').style.display = 'none';
    }

    function showAttachModal(requirementId) {
        showUploadModal(requirementId);
    }

    // Drag & Drop functionality
    function setupDropZone(dropZoneId, fileInputId, previewId, fileNameId, fileSizeId) {
        const dropZone = document.getElementById(dropZoneId);
        const fileInput = document.getElementById(fileInputId);
        const preview = document.getElementById(previewId);
        const fileName = document.getElementById(fileNameId);
        const fileSize = document.getElementById(fileSizeId);
        
        // Click to browse
        dropZone.addEventListener('click', () => fileInput.click());
        
        // File input change
        fileInput.addEventListener('change', (e) => {
            const file = e.target.files[0];
            if (file) {
                updateFilePreview(file, preview, fileName, fileSize);
            }
        });
        
        // Drag & Drop
        dropZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropZone.classList.add('border-blue-500', 'bg-blue-50');
        });
        
        dropZone.addEventListener('dragleave', () => {
            dropZone.classList.remove('border-blue-500', 'bg-blue-50');
        });
        
        dropZone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropZone.classList.remove('border-blue-500', 'bg-blue-50');
            
            const file = e.dataTransfer.files[0];
            if (file) {
                fileInput.files = e.dataTransfer.files;
                updateFilePreview(file, preview, fileName, fileSize);
            }
        });
    }

    function updateFilePreview(file, preview, fileName, fileSize) {
        if (file) {
            // Check file size (10MB limit)
            const maxSize = 10 * 1024 * 1024;
            if (file.size > maxSize) {
                showNotification('File Too Large', 'File size exceeds 10MB limit. Please choose a smaller file.', 'error');
                return;
            }
            
            // Check file type
            const validTypes = ['application/pdf', 'image/jpeg', 'image/jpg', 'image/png', 
                               'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                               'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'];
            
            if (!validTypes.includes(file.type)) {
                showNotification('Invalid File Type', 'Please upload a valid document file (PDF, JPG, PNG, DOC, DOCX, XLS, XLSX).', 'error');
                return;
            }
            
            fileName.textContent = file.name;
            
            // Format file size
            const size = file.size;
            const i = Math.floor(Math.log(size) / Math.log(1024));
            const formattedSize = (size / Math.pow(1024, i)).toFixed(2) * 1 + ' ' + ['B', 'KB', 'MB', 'GB', 'TB'][i];
            fileSize.textContent = formattedSize;
            
            preview.classList.remove('hidden');
        }
    }

    function clearModalFile() {
        document.getElementById('modalDocument').value = '';
        document.getElementById('modalFilePreview').classList.add('hidden');
    }

    function clearReplaceFile() {
        document.getElementById('replaceDocument').value = '';
        document.getElementById('replaceFilePreview').classList.add('hidden');
    }

    // Handle upload form submission with AJAX
    document.getElementById('uploadDocumentForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const requirementId = document.getElementById('modal_requirement_id').value;
        
        if (!requirementId) {
            showNotification('Selection Required', 'Please select a document type.', 'error');
            return;
        }
        
        const fileInput = document.getElementById('modalDocument');
        if (!fileInput.files[0]) {
            showNotification('File Required', 'Please select a file to upload.', 'error');
            return;
        }
        
        // Show progress
        document.getElementById('uploadProgress').classList.remove('hidden');
        const submitBtn = document.getElementById('uploadSubmitBtn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Uploading...';
        
        // AJAX upload
        const xhr = new XMLHttpRequest();
        
        xhr.upload.addEventListener('progress', function(e) {
            if (e.lengthComputable) {
                const percentComplete = (e.loaded / e.total) * 100;
                document.getElementById('progressBar').style.width = percentComplete + '%';
                document.getElementById('progressText').textContent = 
                    `Uploading: ${Math.round(percentComplete)}%`;
            }
        });
        
        xhr.addEventListener('load', function() {
            if (xhr.status === 200) {
                try {
                    const response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        showNotification('Upload Successful', response.message, 'success');
                        hideUploadModal();
                        
                        // Reload the page to show updated documents
                        setTimeout(() => {
                            location.reload();
                        }, 1500);
                    } else {
                        // Show validation errors or error message
                        let errorMessage = response.message;
                        if (response.errors) {
                            // Format validation errors
                            const errors = Object.values(response.errors).flat();
                            errorMessage = errors.join('<br>');
                        }
                        showNotification('Upload Failed', errorMessage, 'error');
                        resetUploadForm();
                    }
                } catch (error) {
                    console.error('Parse error:', error, xhr.responseText);
                    showNotification('Upload Error', 'An error occurred during upload. Please try again.', 'error');
                    resetUploadForm();
                }
            } else if (xhr.status === 422) {
                // Validation error
                try {
                    const response = JSON.parse(xhr.responseText);
                    let errorMessage = 'Validation error';
                    if (response.errors) {
                        const errors = Object.values(response.errors).flat();
                        errorMessage = errors.join('<br>');
                    }
                    showNotification('Validation Error', errorMessage, 'error');
                    resetUploadForm();
                } catch (error) {
                    showNotification('Validation Error', 'Invalid data submitted.', 'error');
                    resetUploadForm();
                }
            } else if (xhr.status === 403) {
                showNotification('Permission Denied', 'You do not have permission to upload documents.', 'error');
                resetUploadForm();
            } else {
                showNotification('Upload Error', `Server error (${xhr.status}). Please try again.`, 'error');
                resetUploadForm();
            }
        });
        
        xhr.addEventListener('error', function() {
            showNotification('Network Error', 'Network error occurred. Please check your connection.', 'error');
            resetUploadForm();
        });
        
        xhr.open('POST', '{{ route("admin.applications.store-document", $application->id) }}');
        xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');
        xhr.send(formData);
    });

    // Handle replace form submission
    document.getElementById('replaceDocumentForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const documentId = document.getElementById('replaceDocumentId').value;
        
        const fileInput = document.getElementById('replaceDocument');
        if (!fileInput.files[0]) {
            showNotification('File Required', 'Please select a new file to replace the existing one.', 'error');
            return;
        }
        
        // Show loading state
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalBtnText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Replacing...';
        submitBtn.disabled = true;
        
        showNotification('Processing...', 'Replacing document...', 'info');
        
        // AJAX request for replacement
        fetch('{{ route("admin.applications.store-document", $application->id) }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => {
            if (!response.ok) {
                if (response.status === 422) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'Validation error');
                    });
                }
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showNotification('Replacement Successful', data.message, 'success');
                hideReplaceModal();
                
                // Reload the page
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showNotification('Replacement Failed', data.message || 'Failed to replace document.', 'error');
                submitBtn.innerHTML = originalBtnText;
                submitBtn.disabled = false;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('Error', error.message || 'An error occurred. Please try again.', 'error');
            submitBtn.innerHTML = originalBtnText;
            submitBtn.disabled = false;
        });
    });

    function resetUploadForm() {
        document.getElementById('uploadProgress').classList.add('hidden');
        const submitBtn = document.getElementById('uploadSubmitBtn');
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-upload mr-2"></i> Upload Document';
    }

    function checkApprovalEligibility() {
        // Show loading state
        const button = event.target;
        const originalText = button.innerHTML;
        button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Checking...';
        button.disabled = true;
        
        showNotification('Checking...', 'Checking document completion...', 'info');
        
        $.ajax({
            url: '{{ route("admin.applications.check-completion", $application->id) }}',
            method: 'GET',
            success: function(response) {
                if (response.eligible_for_approval) {
                    showNotification('Eligible for Approval', response.message, 'success');
                } else {
                    let missingDocs = response.missing_mandatory.join(', ');
                    showNotification('Not Eligible', 
                        `${response.message}\n\nMissing documents: ${missingDocs}\n\nCompletion: ${response.completion_percentage}%`, 
                        'error'
                    );
                }
                button.innerHTML = originalText;
                button.disabled = false;
            },
            error: function(xhr) {
                showNotification('Error', 'Failed to check eligibility. Please try again.', 'error');
                button.innerHTML = originalText;
                button.disabled = false;
            }
        });
    }

    function showNotification(title, message, type) {
        // Hide any existing notifications
        document.getElementById('successNotification').classList.add('hidden');
        document.getElementById('errorNotification').classList.add('hidden');
        
        if (type === 'success' || type === 'info') {
            document.getElementById('successTitle').textContent = title;
            document.getElementById('successMessage').textContent = message;
            document.getElementById('successNotification').classList.remove('hidden');
            
            // Auto-hide after 5 seconds
            setTimeout(() => {
                document.getElementById('successNotification').classList.add('hidden');
            }, 5000);
        } else {
            document.getElementById('errorTitle').textContent = title;
            document.getElementById('errorMessage').textContent = message;
            document.getElementById('errorNotification').classList.remove('hidden');
            
            // Auto-hide after 5 seconds
            setTimeout(() => {
                document.getElementById('errorNotification').classList.add('hidden');
            }, 5000);
        }
    }

    function hideNotification(notificationId) {
        document.getElementById(notificationId).classList.add('hidden');
    }

    // Document download handler with progress indication
    function handleDocumentDownload(url, documentName) {
        showNotification('Downloading...', `Preparing ${documentName} for download...`, 'info');
        
        // Create a temporary iframe for download
        const iframe = document.createElement('iframe');
        iframe.style.display = 'none';
        iframe.src = url;
        document.body.appendChild(iframe);
        
        // Remove iframe after download
        setTimeout(() => {
            document.body.removeChild(iframe);
        }, 5000);
    }

    // Initialize drop zones and event listeners
    document.addEventListener('DOMContentLoaded', function() {
        setupDropZone('dropZone', 'modalDocument', 'modalFilePreview', 'modalFileName', 'modalFileSize');
        setupDropZone('replaceDropZone', 'replaceDocument', 'replaceFilePreview', 'replaceFileName', 'replaceFileSize');
        
        // Close modals with Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                hideUploadModal();
                hideReplaceModal();
                hideRejectModal();
            }
        });
        
        // Close modals when clicking outside
        document.getElementById('uploadDocumentModal').addEventListener('click', function(e) {
            if (e.target === this) {
                hideUploadModal();
            }
        });
        
        document.getElementById('replaceDocumentModal').addEventListener('click', function(e) {
            if (e.target === this) {
                hideReplaceModal();
            }
        });
        
        document.getElementById('rejectModal').addEventListener('click', function(e) {
            if (e.target === this) {
                hideRejectModal();
            }
        });

        // Add click handlers for download links
        document.querySelectorAll('a[href*="download-document"]').forEach(link => {
            link.addEventListener('click', function(e) {
                const documentName = this.getAttribute('title') || 'document';
                handleDocumentDownload(this.href, documentName);
            });
        });

        // Prevent form double submission
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function(e) {
                const submitBtn = this.querySelector('button[type="submit"]');
                if (submitBtn && submitBtn.disabled) {
                    e.preventDefault();
                    return false;
                }
                submitBtn.disabled = true;
                submitBtn.innerHTML = submitBtn.innerHTML.replace('Upload', 'Uploading...')
                                                         .replace('Replace', 'Replacing...')
                                                         .replace('Submit', 'Submitting...');
            });
        });

        // Auto-hide success notifications after 5 seconds
        setTimeout(() => {
            document.getElementById('successNotification').classList.add('hidden');
            document.getElementById('errorNotification').classList.add('hidden');
        }, 5000);
    });

    // Document status update functions
    function updateDocumentStatus(documentId, status, message) {
        // Find the document row and update its status
        const documentRow = document.querySelector(`tr[data-document-id="${documentId}"]`);
        if (documentRow) {
            const statusCell = documentRow.querySelector('.document-status');
            if (statusCell) {
                statusCell.innerHTML = getStatusBadge(status);
            }
            
            // Update action buttons
            const actionCell = documentRow.querySelector('.document-actions');
            if (actionCell && status === 'verified') {
                actionCell.innerHTML = '<span class="text-green-600 font-medium">Verified</span>';
            }
            
            showNotification('Status Updated', message, 'success');
        }
    }

    function getStatusBadge(status) {
        const badges = {
            'pending': '<span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800"><i class="fas fa-clock mr-1"></i> Pending</span>',
            'verified': '<span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800"><i class="fas fa-check-circle mr-1"></i> Verified</span>',
            'rejected': '<span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800"><i class="fas fa-times-circle mr-1"></i> Rejected</span>'
        };
        return badges[status] || '<span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">Unknown</span>';
    }

    // Handle window beforeunload to prevent accidental navigation during upload
    window.addEventListener('beforeunload', function(e) {
        const uploadInProgress = document.getElementById('uploadProgress') && 
                                 !document.getElementById('uploadProgress').classList.contains('hidden');
        const formSubmitting = document.querySelector('button[type="submit"][disabled]');
        
        if (uploadInProgress || formSubmitting) {
            e.preventDefault();
            e.returnValue = 'You have an upload in progress. Are you sure you want to leave?';
            return 'You have an upload in progress. Are you sure you want to leave?';
        }
    });
</script>
</body>
</html>