<style>
    body { font-family: helvetica, sans-serif; }
    table { width: 100%; border-collapse: collapse; }
    
    /* Header Styles */
    .report-title { font-size: 16pt; font-weight: bold; color: #0077C5; text-align: center; }
    .report-meta { font-size: 10pt; text-align: center; margin-bottom: 20px; }
    
    /* Excel-style Grid */
    .data-table th { 
        background-color: #0077C5; 
        color: #ffffff; 
        font-weight: bold; 
        text-align: center; 
        border: 1px solid #005A94;
        font-size: 9pt;
    }
    .data-table td { 
        border: 1px solid #cccccc; 
        font-size: 8.5pt; 
        padding: 5px;
    }
    .text-right { text-align: right; }
    .font-bold { font-weight: bold; }
    
    /* Summary Section - Added margin-top for spacing */
    .summary-table { 
        width: 40%; 
        margin-left: 60%; 
        margin-top: 30px; /* Increased margin for clear separation */
    }
    .summary-label { background-color: #f3f4f6; font-weight: bold; border: 1px solid #cccccc; padding: 5px; font-size: 9pt; }
    .summary-value { border: 1px solid #cccccc; padding: 5px; font-size: 9pt; text-align: right; }
</style>

<div class="report-title">ZEDBANKOS COLLECTIONS REPORT</div>
<div class="report-meta">
    Period: {{ $start }} to {{ $end }}<br>
    Generated On: {{ date('d M Y, H:i') }}
</div>

<br>

<table class="data-table" cellpadding="4">
    <thead>
        <tr>
            <th width="10%">Date</th>
            <th width="20%">Customer</th>
            <th width="10%">Loan No.</th>
            <th width="12%">Reference</th>
            <th width="8%">Method</th>
            <th width="10%">Principal</th>
            <th width="10%">Interest</th>
            <th width="10%">Fees</th>
            <th width="10%">Total Paid</th>
        </tr>
    </thead>
    <tbody>
        @foreach($data as $row)
        <tr>
            <td width="10%">{{ $row->rdate->format('d/m/Y') }}</td>
            <td width="20%">{{ ($row->customer->first_name ?? '') . ' ' . ($row->customer->surname ?? '') }}</td>
            <td width="10%">{{ $row->loan->loannumber ?? 'N/A' }}</td>
            <td width="12%">{{ $row->paymentreference ?? '-' }}</td>
            <td width="8%">{{ $row->pmethod }}</td>
            <td width="10%" class="text-right">{{ number_format($row->rprincipal, 2) }}</td>
            <td width="10%" class="text-right">{{ number_format($row->rinterest, 2) }}</td>
            <td width="10%" class="text-right">{{ number_format($row->processing_fees_amount_paid, 2) }}</td>
            <td width="10%" class="text-right font-bold">{{ number_format($row->rtotal, 2) }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<table style="width: 100%; border: none;">
    <tr><td style="height: 20px; border: none;"></td></tr>
</table>

<table class="summary-table" cellpadding="5">
    <tr>
        <td class="summary-label">Total Principal:</td>
        <td class="summary-value">ZMW {{ number_format($stats['principal'], 2) }}</td>
    </tr>
    <tr>
        <td class="summary-label">Total Interest:</td>
        <td class="summary-value">ZMW {{ number_format($stats['interest'], 2) }}</td>
    </tr>
    <tr>
        <td class="summary-label">Total Fees:</td>
        <td class="summary-value">ZMW {{ number_format($stats['fees'], 2) }}</td>
    </tr>
    <tr>
        <td class="summary-label">Total Penalties:</td>
        <td class="summary-value">ZMW {{ number_format($stats['penalties'], 2) }}</td>
    </tr>
    <tr>
        <td class="summary-label" style="background-color: #0077C5; color: #ffffff;">GRAND TOTAL:</td>
        <td class="summary-value" style="font-weight: bold; background-color: #e5e7eb;">ZMW {{ number_format($stats['total'], 2) }}</td>
    </tr>
</table>