<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Non-Performing Loans | IMMIA FINANCE</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; /* ThemeBlue */
            --zedbank-blue-dark: #005A94; /* Darker shade for hover/active background */
        }

        /* Custom Tailwind-like classes */
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        /* Status badge colors */
        .status-badge {
            @apply inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium;
        }
        .status-active { @apply bg-green-100 text-green-800; }
        .status-closed { @apply bg-gray-100 text-gray-800; }
        .status-default { @apply bg-red-100 text-red-800; }
        .status-npl { @apply bg-orange-100 text-orange-800; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    {{-- Including sidebar --}}
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        
        {{-- Including header --}}
        @include('accounting.partials.header', [
            'title' => 'Non-Performing Loans (NPL)',
            'subtitle' => 'Loans classified as non-performing or in default'
        ])

        <main class="p-6">
            {{-- Breadcrumb Navigation --}}
            <div class="mb-6">
                <nav class="flex" aria-label="Breadcrumb">
                    <ol class="inline-flex items-center space-x-1 md:space-x-3">
                        <li class="inline-flex items-center">
                            <a href="{{ route('admin.dashboard') }}" class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-zedbank-blue">
                                <i class="fas fa-home mr-2"></i>
                                Dashboard
                            </a>
                        </li>
                        <li>
                            <div class="flex items-center">
                                <i class="fas fa-chevron-right text-gray-400"></i>
                                <a href="{{ route('admin.loans.active') }}" class="ml-1 text-sm font-medium text-gray-700 hover:text-zedbank-blue md:ml-2">
                                    Loans
                                </a>
                            </div>
                        </li>
                        <li aria-current="page">
                            <div class="flex items-center">
                                <i class="fas fa-chevron-right text-gray-400"></i>
                                <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Non-Performing Loans</span>
                            </div>
                        </li>
                    </ol>
                </nav>
            </div>

            {{-- Page Header --}}
            <div class="mb-8">
                <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-800">Non-Performing Loans</h1>
                        <p class="text-gray-600 mt-2">
                            View and manage all loans classified as non-performing (default status). These loans are past due and have been provisioned accordingly.
                        </p>
                    </div>
                    
                  
                </div>
            </div>

            {{-- Stats Cards --}}
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Total NPL Loans</p>
                            <p class="text-2xl font-bold text-gray-800">{{ $loans->total() }}</p>
                        </div>
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-exclamation-triangle text-red-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Total Outstanding</p>
                            <p class="text-2xl font-bold text-gray-800">
                                K {{ number_format($loans->sum('totalbalance'), 2) }}
                            </p>
                        </div>
                        <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-balance-scale text-orange-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Total Provisions</p>
                            <p class="text-2xl font-bold text-gray-800">
                                K {{ number_format($loans->sum('provision_amount'), 2) }}
                            </p>
                        </div>
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-shield-alt text-purple-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Average Days Delinquent</p>
                            <p class="text-2xl font-bold text-gray-800">
                                {{ number_format($loans->avg('daysdelinquent') ?? 0, 0) }}
                            </p>
                        </div>
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar-days text-blue-600 text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>

            {{-- NPL Loan List --}}
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                <div class="border-b border-gray-200 px-6 py-4">
                    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                        <div>
                            <h2 class="text-xl font-semibold text-gray-800">Non-Performing Loans List</h2>
                            <p class="text-sm text-gray-600 mt-1">Showing {{ $loans->firstItem() ?? 0 }}-{{ $loans->lastItem() ?? 0 }} of {{ $loans->total() }} loans</p>
                        </div>
                        
                        <div class="flex items-center space-x-2">
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-search text-gray-400"></i>
                                </div>
                                <input type="text" placeholder="Search loans..." 
                                       class="pl-10 block w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary transition">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Loan Details
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Customer
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status & Category
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Outstanding Balance
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($loans as $loan)
                                <tr class="hover:bg-gray-50 transition">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                                    <i class="fas fa-file-contract text-red-600 text-sm"></i>
                                                </div>
                                                <div>
                                                    <a href="{{ route('admin.loans.show', $loan->loanid) }}" 
                                                       class="text-sm font-medium text-gray-900 hover:text-zedbank-blue transition">
                                                        {{ $loan->loannumber }}
                                                    </a>
                                                    <p class="text-xs text-gray-500">
                                                        {{ $loan->loanType->product ?? 'N/A' }}
                                                    </p>
                                                    <p class="text-xs text-gray-500">
                                                        Disbursed: {{ \Carbon\Carbon::parse($loan->disburseddate)->format('M d, Y') }}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($loan->customer)
                                            <div>
                                                <p class="text-sm font-medium text-gray-900">
                                                    {{ $loan->customer->first_name }} {{ $loan->customer->surname }}
                                                </p>
                                                <p class="text-xs text-gray-500">{{ $loan->customer->customer_number ?? 'N/A' }}</p>
                                                <p class="text-xs text-gray-500">{{ $loan->customer->phone ?? 'N/A' }}</p>
                                            </div>
                                        @else
                                            <p class="text-sm text-gray-500">Customer not found</p>
                                        @endif
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="space-y-1">
                                            <span class="status-badge status-default">
                                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                                {{ ucfirst($loan->status) }}
                                            </span>
                                            
                                            @if($loan->npl_category)
                                                <div>
                                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium 
                                                        @if($loan->npl_category == 'substandard') bg-yellow-100 text-yellow-800
                                                        @elseif($loan->npl_category == 'doubtful') bg-orange-100 text-orange-800
                                                        @elseif($loan->npl_category == 'loss') bg-red-100 text-red-800
                                                        @else bg-gray-100 text-gray-800 @endif">
                                                        {{ ucfirst($loan->npl_category) }}
                                                    </span>
                                                </div>
                                            @endif
                                            
                                            @if($loan->daysdelinquent > 0)
                                                <p class="text-xs text-red-600">
                                                    <i class="fas fa-clock mr-1"></i>
                                                    {{ $loan->daysdelinquent }} days delinquent
                                                </p>
                                            @endif
                                            
                                            @if($loan->npl_classification_date)
                                                <p class="text-xs text-gray-500">
                                                    Classified: {{ \Carbon\Carbon::parse($loan->npl_classification_date)->format('M d, Y') }}
                                                </p>
                                            @endif
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div>
                                            <p class="text-lg font-bold text-gray-900">
                                                K {{ number_format($loan->totalbalance, 2) }}
                                            </p>
                                            <div class="text-xs text-gray-500">
                                                <div class="flex justify-between">
                                                    <span>Principal:</span>
                                                    <span>K {{ number_format($loan->principalbalance, 2) }}</span>
                                                </div>
                                                <div class="flex justify-between">
                                                    <span>Interest:</span>
                                                    <span>K {{ number_format($loan->interestbalance, 2) }}</span>
                                                </div>
                                                @if($loan->provision_amount > 0)
                                                    <div class="flex justify-between">
                                                        <span>Provision ({{ $loan->provision_percentage ?? 0 }}%):</span>
                                                        <span class="text-orange-600 font-medium">K {{ number_format($loan->provision_amount, 2) }}</span>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex items-center space-x-2">
                                            <a href="{{ route('admin.loans.show', $loan->loanid) }}" 
                                               class="text-zedbank-blue hover:text-zedbank-blue-dark transition"
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if(auth()->user()->hasPermission('loans.reverse'))
                                                <form action="{{ route('admin.loans.reverse', $loan->loanid) }}" method="POST" 
                                                      onsubmit="return confirm('Are you sure you want to restore this loan to active status?')">
                                                    @csrf
                                                    <button type="submit" 
                                                            class="text-green-600 hover:text-green-800 transition"
                                                            title="Restore to Active">
                                                        <i class="fas fa-undo"></i>
                                                    </button>
                                                </form>
                                            @endif
                                            
                                            @if(auth()->user()->hasPermission('loans.close'))
                                                <a href="{{ route('admin.loans.close-form', $loan->loanid) }}" 
                                                   class="text-gray-600 hover:text-gray-800 transition"
                                                   title="Close Loan">
                                                    <i class="fas fa-lock"></i>
                                                </a>
                                            @endif
                                            
                                            @if(auth()->user()->hasPermission('payments.create'))
                                                <a href="{{ route('admin.loans.payment-form', $loan->loanid) }}" 
                                                   class="text-green-600 hover:text-green-800 transition"
                                                   title="Record Payment">
                                                    <i class="fas fa-dollar-sign"></i>
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-8 text-center">
                                        <div class="flex flex-col items-center justify-center text-gray-500">
                                            <i class="fas fa-check-circle text-4xl text-green-400 mb-4"></i>
                                            <p class="text-lg font-medium">No Non-Performing Loans Found</p>
                                            <p class="text-sm mt-2">Great news! There are currently no loans classified as non-performing.</p>
                                            <a href="{{ route('admin.loans.active') }}" 
                                               class="mt-4 inline-flex items-center px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition">
                                                <i class="fas fa-list mr-2"></i>
                                                View Active Loans
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                {{-- Pagination --}}
                @if($loans->hasPages())
                    <div class="border-t border-gray-200 px-6 py-4">
                        <div class="flex items-center justify-between">
                            <div class="flex-1 flex justify-between sm:hidden">
                                @if($loans->onFirstPage())
                                    <span class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-300 bg-gray-50">
                                        Previous
                                    </span>
                                @else
                                    <a href="{{ $loans->previousPageUrl() }}" 
                                       class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                                        Previous
                                    </a>
                                @endif
                                
                                @if($loans->hasMorePages())
                                    <a href="{{ $loans->nextPageUrl() }}" 
                                       class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                                        Next
                                    </a>
                                @else
                                    <span class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-300 bg-gray-50">
                                        Next
                                    </span>
                                @endif
                            </div>
                            
                            <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                                <div>
                                    <p class="text-sm text-gray-700">
                                        Showing <span class="font-medium">{{ $loans->firstItem() }}</span>
                                        to <span class="font-medium">{{ $loans->lastItem() }}</span>
                                        of <span class="font-medium">{{ $loans->total() }}</span> results
                                    </p>
                                </div>
                                <div>
                                    <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                                        {{ $loans->links('vendor.pagination.tailwind') }}
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
            
            {{-- NPL Information Card --}}
            <div class="mt-6 bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded-r-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-info-circle text-yellow-400 text-xl"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-yellow-800">
                            About Non-Performing Loans (NPL)
                        </h3>
                        <div class="mt-2 text-sm text-yellow-700">
                            <p>
                                <strong>Definition:</strong> A loan is classified as non-performing when payments of principal and/or interest are past due by 90 days or more, 
                                or when the full payment of principal and/or interest is no longer expected.
                            </p>
                            <p class="mt-2">
                                <strong>Categories:</strong>
                                <ul class="list-disc ml-5 mt-1">
                                    <li><strong>Substandard:</strong> Loans with well-defined weaknesses (90-180 days overdue)</li>
                                    <li><strong>Doubtful:</strong> Full collection in serious doubt (181-365 days overdue)</li>
                                    <li><strong>Loss:</strong> Considered uncollectible (365+ days overdue)</li>
                                </ul>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Simple search functionality
            const searchInput = document.querySelector('input[type="text"]');
            if (searchInput) {
                searchInput.addEventListener('keyup', function(e) {
                    if (e.key === 'Enter') {
                        const searchTerm = this.value.trim();
                        if (searchTerm) {
                            // Implement search functionality here
                            console.log('Searching for:', searchTerm);
                        }
                    }
                });
            }
        });
    </script>
</body>
</html>