<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Loan Application Received - IMMIA FINANCE</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            line-height: 1.6; 
            color: #333; 
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container { 
            max-width: 600px; 
            margin: 0 auto; 
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .header { 
            background: linear-gradient(135deg, #0077C5 0%, #005A94 100%); 
            color: white; 
            padding: 30px; 
            text-align: center; 
        }
        .logo { 
            font-size: 24px; 
            font-weight: bold; 
            margin-bottom: 10px; 
        }
        .content { 
            padding: 30px; 
        }
        .loan-details { 
            background: #f8f9fa; 
            padding: 20px; 
            border-radius: 8px; 
            margin: 20px 0; 
            border-left: 4px solid #0077C5; 
        }
        .footer { 
            text-align: center; 
            padding: 20px; 
            color: #666; 
            font-size: 14px; 
            background: #f8f9fa;
            border-top: 1px solid #eaeaea;
        }
        .button { 
            display: inline-block; 
            padding: 12px 30px; 
            background: #0077C5; 
            color: white; 
            text-decoration: none; 
            border-radius: 5px; 
            margin: 20px 0; 
            font-weight: bold;
        }
        .highlight { 
            color: #0077C5; 
            font-weight: bold; 
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        td {
            padding: 10px 0;
            border-bottom: 1px solid #eee;
        }
        td:first-child {
            width: 40%;
            font-weight: bold;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            background: #e3f2fd;
            color: #0077C5;
            border-radius: 20px;
            font-weight: bold;
            margin-left: 10px;
        }
        .next-steps {
            background: #e8f5e9;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #4caf50;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">IMMIA FINANCE LIMITED</div>
            <h2 style="margin: 10px 0 0 0;">Loan Application Received</h2>
            <p style="margin: 5px 0 0 0; opacity: 0.9;">Application #{{ $application->application_number }}</p>
        </div>
        
        <div class="content">
            <p>Dear <strong>{{ $customer->first_name }} {{ $customer->surname }}</strong>,</p>
            
            <p>Thank you for submitting your loan application to IMMIA FINANCE LIMITED. We have successfully received your application and it is now <span class="status-badge">UNDER REVIEW</span>.</p>
            
            <div class="loan-details">
                <h3 style="margin-top: 0; color: #0077C5; border-bottom: 2px solid #0077C5; padding-bottom: 10px;">Application Summary</h3>
                <table>
                    <tr>
                        <td>Application Number:</td>
                        <td>{{ $application->application_number }}</td>
                    </tr>
                    <tr>
                        <td>Submission Date:</td>
                        <td>{{ $application->submitted_at ? $application->submitted_at->format('F d, Y') : date('F d, Y') }}</td>
                    </tr>
                    <tr>
                        <td>Loan Amount:</td>
                        <td>ZMW {{ number_format($application->loan_amount, 2) }}</td>
                    </tr>
                    <tr>
                        <td>Loan Product:</td>
                        <td>{{ $application->product->product ?? 'Personal Loan' }}</td>
                    </tr>
                    <tr>
                        <td>Interest Rate:</td>
                        <td>{{ number_format($application->interest_rate, 2) }}% per annum</td>
                    </tr>
                    <tr>
                        <td>Loan Term:</td>
                        <td>{{ $application->loan_tenure }} {{ $application->payment_frequency == 'monthly' ? 'Months' : 'Periods' }}</td>
                    </tr>
                    <tr>
                        <td>Proposed Installment:</td>
                        <td>ZMW {{ number_format($application->installment_amount, 2) }} {{ $application->payment_frequency ? 'per ' . $application->payment_frequency : 'per month' }}</td>
                    </tr>
                    <tr>
                        <td>Application Source:</td>
                        <td style="text-transform: capitalize;">{{ $application->source ?? 'Online' }}</td>
                    </tr>
                </table>
            </div>

            <div class="next-steps">
                <h4 style="margin-top: 0; color: #2e7d32;">What Happens Next?</h4>
                <ol style="margin: 10px 0; padding-left: 20px;">
                    <li><strong>Application Review:</strong> Our credit team will review your application within 1-3 business days</li>
                    <li><strong>Verification:</strong> We may contact you for additional information or document verification</li>
                    <li><strong>Decision:</strong> You will receive notification once a decision has been made</li>
                    <li><strong>Disbursement:</strong> If approved, funds will be disbursed to your preferred account</li>
                </ol>
            </div>

            <div style="text-align: center; margin: 30px 0;">
                <p><strong>Application Status:</strong> You can track your application status by logging into your account or contacting our customer service.</p>
                
                @if($application->customer->customer_number)
                <p>Your Customer Number: <strong>{{ $application->customer->customer_number }}</strong></p>
                @endif
            </div>

            <p>We appreciate your patience during the review process. Our team is committed to providing you with the best possible service.</p>
            
            <p>Should you have any questions or need to provide additional information, please don't hesitate to contact us:</p>
            
            <p style="background: #f0f8ff; padding: 15px; border-radius: 5px; margin: 20px 0;">
                <strong>Customer Service:</strong><br>
                📞 Phone: +260 211 123456<br>
                📧 Email: support@immiafinance.com<br>
                🏢 Address: Plot 123, Great East Road, Lusaka, Zambia
            </p>
            
            <p>Best regards,<br>
            <strong>IMMIA FINANCE LIMITED</strong><br>
            <em>"Your Financial Partner for Growth"</em></p>
        </div>
        
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>If you believe you received this email in error or did not submit a loan application, please contact us immediately.</p>
            <p>&copy; {{ date('Y') }} IMMIA FINANCE LIMITED. All rights reserved.</p>
            <p style="font-size: 12px; color: #999;">
                This email contains confidential information and is intended only for the addressee.<br>
                Unauthorized use, disclosure, or copying is strictly prohibited.
            </p>
        </div>
    </div>
</body>
</html>