<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\LoanController;
use App\Http\Controllers\Admin\ApplicationController;
use App\Http\Controllers\Admin\BranchController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\DisbursementChannelController;

use App\Http\Controllers\Accounting\NotificationSettingsController;

// Accounting Controllers
use App\Http\Controllers\Accounting\AccountingController;
use App\Http\Controllers\Accounting\ChartOfAccountController;
use App\Http\Controllers\Accounting\ReceivableController;
use App\Http\Controllers\Accounting\PayableController;
use App\Http\Controllers\Accounting\SupplierController;
use App\Http\Controllers\Accounting\SupplierInvoiceController;
use App\Http\Controllers\Accounting\PaymentVoucherController;
use App\Http\Controllers\Accounting\PettyCashController;
use App\Http\Controllers\Accounting\OtherExpenseController;
use App\Http\Controllers\Accounting\JournalEntryController;
use App\Http\Controllers\Accounting\ReportController;
use App\Http\Controllers\Accounting\AccountGroupController;
use App\Http\Controllers\Accounting\AccountTypeController;
use App\Http\Controllers\Accounting\FinancialYearController;
use App\Http\Controllers\Accounting\CurrencyController;
use App\Http\Controllers\Accounting\CurrencyRateController;
use App\Http\Controllers\Accounting\PrimaryCategoryController;
use App\Http\Controllers\Accounting\ReportTypeController;
use App\Http\Controllers\Accounting\BusinessProcessMappingController;
use App\Http\Controllers\CreditScoreTierController;
use App\Http\Controllers\Accounting\SelfServiceController;

// Cash and Banking Controllers
use App\Http\Controllers\Accounting\CashBankingController;
use App\Http\Controllers\Accounting\CashBankAccountController;
use App\Http\Controllers\Accounting\InternalTransferController;
use App\Http\Controllers\Accounting\CashBookController;

// Company Controller
use App\Http\Controllers\Accounting\CompanyController;

// Expenses Controllers
use App\Http\Controllers\Accounting\ExpenseTransactionController;
use App\Http\Controllers\Accounting\VendorController;

// PayrollController Controllers
use App\Http\Controllers\Accounting\PayrollController;

// Leave Management Controller
use App\Http\Controllers\Accounting\LeaveController;

// Application Requirements Controller
use App\Http\Controllers\Accounting\ApplicationRequirementController;

// Product Controller
use App\Http\Controllers\Accounting\ProductController;

// Offer Controller
use App\Http\Controllers\Accounting\OfferController;
use App\Http\Controllers\Admin\QuotationController;
use App\Http\Controllers\Admin\CollectionsController;
use App\Http\Controllers\Admin\MessageController;

// Public routes
Route::get('/', function () {
    return redirect()->route('admin.login');
});

// Generic login route to satisfy Laravel's auth system
Route::get('/login', function () {
    return redirect()->route('admin.login');
})->name('login');

// Admin Authentication Routes
Route::get('/admin/login', [AuthController::class, 'showAdminLogin'])->name('admin.login');
Route::post('/admin/login', [AuthController::class, 'adminLogin'])->name('admin.login.post');
Route::post('/admin/logout', [AuthController::class, 'adminLogout'])->name('admin.logout');

// Admin routes - Protected by auth
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    
    // --- Quotations Management ---
    Route::prefix('quotations')->name('quotations.')->group(function () {
        // 1. Management List (Index)
        Route::get('/', [QuotationController::class, 'index'])->name('index');
        // View for generating a new quotation
        Route::get('/create', [QuotationController::class, 'create'])->name('create');
        // Store/Save the quotation if needed
        // Add this specific route for the schedule matrix
        Route::get('/schedule', function () {
            // We can return the view directly since the logic is inside the Blade file
            return view('admin.quotations.schedule');
        })->name('schedule');
        
        Route::get('admin/quotations/schedule/download', [QuotationController::class, 'downloadSchedulePdf'])->name('schedule.pdf');
        // API Endpoint for dynamic schedule calculation
        // 3. Edit Existing Draft/Quotation View
        Route::get('/{id}/edit', [QuotationController::class, 'edit'])->name('edit');
        // 4. Unified Save/Update Logic (Stores in SQL and returns schedule)
        Route::post('/store', [QuotationController::class, 'store'])->name('store');
        
        Route::get('/{id}/show', [QuotationController::class, 'show'])->name('show');
        // This feeds the LoanService results to your View
        Route::post('/calculate-schedule', [QuotationController::class, 'calculateSchedule'])->name('calculate_schedule');
        // PDF Generation
        Route::get('/{id}/download', [QuotationController::class, 'downloadPdf'])->name('download');
    });
    
    
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    // Applications
    // Applications
    // Applications
   Route::prefix('applications')->name('applications.')->group(function () {
    Route::get('/', [ApplicationController::class, 'index'])->name('index');
    Route::get('/draft', [ApplicationController::class, 'draft'])->name('draft');
    Route::get('/approved', [ApplicationController::class, 'approved'])->name('approved');
    Route::get('/disbursed', [ApplicationController::class, 'disbursed'])->name('disbursed');
    Route::get('/rejected', [ApplicationController::class, 'rejected'])->name('rejected');
    Route::get('/pending', [ApplicationController::class, 'pending'])->name('pending');
    
    Route::get('/create', [ApplicationController::class, 'create'])->name('create');
    Route::post('/', [ApplicationController::class, 'store'])->name('store');
    
    // NEW: Document Management Routes
    Route::get('/{id}/upload-document', [ApplicationController::class, 'uploadDocument'])->name('upload-document');
    Route::post('/{id}/documents', [ApplicationController::class, 'storeDocument'])->name('store-document');
    
    Route::get('/{id}', [ApplicationController::class, 'show'])->name('show');
    
    // NEW AJAX ROUTE: Corrected definition to resolve to admin.applications.get_customer
    Route::get('get-customer/{id}', [ApplicationController::class, 'getCustomerDetails'])->name('get_customer');
    
    // NEW ROUTE: Installment Calculation API
    Route::post('/calculate-installment', [ApplicationController::class, 'calculateInstallment'])->name('calculate_installment');
    
    // AMORTIZATION SCHEDULE ROUTES
    Route::get('/{id}/schedule', [ApplicationController::class, 'viewSchedule'])->name('schedule.view');
    Route::get('/{id}/schedule/pdf', [ApplicationController::class, 'generateSchedulePdf'])->name('schedule.pdf'); // NEW PDF ROUTE
    
    // NEW: Document Management Routes (continued)
    Route::get('/{id}/documents/{document}/view', [ApplicationController::class, 'viewDocument'])->name('view-document');
    Route::get('/{id}/documents/{document}/download', [ApplicationController::class, 'downloadDocument'])->name('download-document');
    Route::post('/{id}/documents/{document}/verify', [ApplicationController::class, 'verifyDocument'])->name('verify-document');
    Route::post('/{id}/documents/{document}/reject', [ApplicationController::class, 'rejectDocument'])->name('reject-document');
    Route::delete('/{id}/documents/{document}', [ApplicationController::class, 'deleteDocument'])->name('delete-document');
    
    // NEW: Document Status/Check Routes
    Route::get('/{id}/check-completion', [ApplicationController::class, 'checkDocumentCompletion'])->name('check-completion');
    Route::get('/{id}/document-status', [ApplicationController::class, 'getDocumentQuickStatus'])->name('document-status');
    Route::get('/{id}/document-report', [ApplicationController::class, 'generateDocumentReport'])->name('document-report');
    
    Route::get('/{id}/edit', [ApplicationController::class, 'edit'])->name('edit');
    Route::get('/{id}/disburse', [ApplicationController::class, 'disburse'])->name('disburse');
    Route::post('/{id}/process-disbursement', [ApplicationController::class, 'processDisbursement'])->name('process-disbursement');
    Route::put('/{id}', [ApplicationController::class, 'update'])->name('update');
    Route::post('/{id}/approve', [ApplicationController::class, 'approve'])->name('approve');
    Route::post('/{id}/reject', [ApplicationController::class, 'reject'])->name('reject');
    Route::post('/{id}/resend-notifications', [ApplicationController::class, 'resendNotifications'])->name('resend-notifications');
    Route::delete('/{id}', [ApplicationController::class, 'destroy'])->name('destroy');
    
    Route::get('/applications/get-product-requirements', [ApplicationController::class, 'getProductRequirements'])->name('get-product-requirements');
});





    // Customers Management Routes
    Route::prefix('customers')->name('customers.')->group(function () {
        
        Route::get('/', [CustomerController::class, 'index'])->name('index');
        Route::get('/create', [CustomerController::class, 'create'])->name('create');
        Route::post('/', [CustomerController::class, 'store'])->name('store');
        
        // NEW: Messaging Routes
        Route::post('/send-message', [App\Http\Controllers\Admin\MessageController::class, 'store'])->name('send-message');
        Route::get('/{customer}/message-history', [App\Http\Controllers\Admin\MessageController::class, 'history'])->name('message-history');
        
        Route::get('/{customer}', [CustomerController::class, 'show'])->name('show');
        Route::get('/{customer}/edit', [CustomerController::class, 'edit'])->name('edit');
        Route::put('/{customer}', [CustomerController::class, 'update'])->name('update');
        Route::delete('/{customer}', [CustomerController::class, 'destroy'])->name('destroy');
    });

    // NEW: Disbursements Channel Routes
    Route::prefix('disbursements-channel')->name('disbursements-channel.')->group(function () {
        Route::get('/', [DisbursementChannelController::class, 'index'])->name('index');
        Route::get('/export', [DisbursementChannelController::class, 'export'])->name('export'); // Add this
        Route::post('/', [DisbursementChannelController::class, 'store'])->name('store');
        Route::put('/{id}', [DisbursementChannelController::class, 'update'])->name('update');
        Route::delete('/{id}', [DisbursementChannelController::class, 'destroy'])->name('destroy');
    });
    
    // Loans
    // Loans
Route::prefix('loans')->name('loans.')->group(function () {
    
    Route::get('/active', [LoanController::class, 'active'])->name('active');
    Route::get('/closed', [LoanController::class, 'closed'])->name('closed');
    Route::get('/non-performing', [LoanController::class, 'nonPerforming'])->name('non-performing');
    Route::get('/{id}', [LoanController::class, 'show'])->name('show');
    
    // Schedule route
    Route::get('/{id}/schedule', [LoanController::class, 'viewRepaymentSchedule'])->name('schedule');
    
    Route::get('/{id}/export-schedule', [LoanController::class, 'exportSchedule'])->name('export-schedule');
    
    // Payment routes
    Route::get('/{loan}/payment', [LoanController::class, 'showPaymentForm'])->name('payment-form');
    Route::post('/{loan}/record-payment', [LoanController::class, 'recordPayment'])->name('record-payment');
    
    // Close loan routes - USE CONSISTENT PARAMETER NAMING
    Route::get('/{loan}/close', [LoanController::class, 'showCloseForm'])->name('close-form');
    Route::post('/{loan}/close', [LoanController::class, 'close'])->name('close');

    // NPL routes - USE CONSISTENT PARAMETER NAMING
    Route::get('/{loan}/npl', [LoanController::class, 'showNPLForm'])->name('npl-form');
    Route::post('/{loan}/transfer-npl', [LoanController::class, 'transferToNPL'])->name('transferToNPL');

    // Other loan action routes - USE CONSISTENT PARAMETER NAMING
    Route::post('/{loan}/reverse', [LoanController::class, 'reverse'])->name('reverse');
    Route::delete('/{loan}', [LoanController::class, 'destroy'])->name('destroy');
    
    // Loan statement
    Route::get('/{loan}/statement', [LoanController::class, 'viewLoanStatement'])->name('loan-statement');
});
    // Collections
    // Update this line inside your auth middleware group
    Route::get('/collections', [CollectionsController::class, 'index'])->name('collections.index');
    // Investments
    Route::get('/investments', function () {
        return view('admin.investments.index');
    })->name('investments.index');
    
    // Accounting Module Routes
    Route::prefix('accounting')->name('accounting.')->group(function () {
        
        Route::get('/', [AccountingController::class, 'index'])->name('index');
        
        Route::prefix('repayments')->name('repayments.')->group(function () {
              // Repayment controller update to handle fee allocation is done in the controller, routes remain standard CRUD-like
              Route::get('/', [RepaymentController::class, 'index'])->name('index');
              Route::get('/create', [RepaymentController::class, 'create'])->name('create');
              Route::post('/store', [RepaymentController::class, 'store'])->name('store');
        });
        
        // Products Management Routes
        Route::prefix('products')->name('products.')->group(function () {
            Route::get('/', [ProductController::class, 'index'])->name('index');
            Route::get('/create', [ProductController::class, 'create'])->name('create');
            Route::post('/', [ProductController::class, 'store'])->name('store');
            Route::get('/{id}', [ProductController::class, 'show'])->name('show');
            Route::get('/{id}/edit', [ProductController::class, 'edit'])->name('edit');
            Route::put('/{id}', [ProductController::class, 'update'])->name('update');
            Route::delete('/{id}', [ProductController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-status', [ProductController::class, 'toggleStatus'])->name('toggle-status');
            Route::get('/{id}/assign-requirements', [ProductController::class, 'assignRequirements'])->name('assign-requirements');
            Route::post('/{id}/update-requirements', [ProductController::class, 'updateRequirements'])->name('update-requirements');
        });
        
        // Offers Management
        Route::prefix('offers')->name('offers.')->group(function () {
            Route::get('/', [OfferController::class, 'index'])->name('index');
            Route::get('/create', [OfferController::class, 'create'])->name('create');
            Route::post('/', [OfferController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [OfferController::class, 'edit'])->name('edit');
            Route::put('/{id}', [OfferController::class, 'update'])->name('update');
            Route::delete('/{id}', [OfferController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-status', [OfferController::class, 'toggleStatus'])->name('toggle-status');
            Route::get('/{id}/activate/form', [OfferController::class, 'activateForm'])->name('activate-form');
            Route::post('/{id}/activate', [OfferController::class, 'activate'])->name('activate');
        });
        
        // Application Requirements
        Route::prefix('application-requirements')->name('application-requirements.')->group(function () {
            Route::get('/', [ApplicationRequirementController::class, 'index'])->name('index');
            Route::get('/create', [ApplicationRequirementController::class, 'create'])->name('create');
            Route::post('/', [ApplicationRequirementController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [ApplicationRequirementController::class, 'edit'])->name('edit');
            Route::put('/{id}', [ApplicationRequirementController::class, 'update'])->name('update');
            Route::delete('/{id}', [ApplicationRequirementController::class, 'destroy'])->name('destroy');
            Route::post('/bulk-import', [ApplicationRequirementController::class, 'bulkImport'])->name('bulk-import');
        });
        
        // Chart of Accounts
        Route::prefix('chart-of-accounts')->name('chart-of-accounts.')->group(function () {
            Route::get('/', [ChartOfAccountController::class, 'index'])->name('index');
            Route::get('/create', [ChartOfAccountController::class, 'create'])->name('create');
            Route::post('/', [ChartOfAccountController::class, 'store'])->name('store');
            Route::get('/{id}', [ChartOfAccountController::class, 'show'])->name('show');
            Route::get('/{id}/edit', [ChartOfAccountController::class, 'edit'])->name('edit');
            Route::put('/{id}', [ChartOfAccountController::class, 'update'])->name('update');
            Route::delete('/{id}', [ChartOfAccountController::class, 'destroy'])->name('destroy');
        });
        
        // Receivables
        Route::prefix('receivables')->name('receivables.')->group(function () {
            Route::get('/', [ReceivableController::class, 'index'])->name('index');
            Route::get('/create', [ReceivableController::class, 'create'])->name('create');
            Route::post('/', [ReceivableController::class, 'store'])->name('store');
            Route::get('/{id}', [ReceivableController::class, 'show'])->name('show');
            Route::get('/{id}/edit', [ReceivableController::class, 'edit'])->name('edit');
            Route::put('/{id}', [ReceivableController::class, 'update'])->name('update');
            Route::delete('/{id}', [ReceivableController::class, 'destroy'])->name('destroy');
        });
        
        // Payables
        Route::prefix('payables')->name('payables.')->group(function () {
            Route::get('/', [PayableController::class, 'index'])->name('index');
            Route::prefix('suppliers')->name('suppliers.')->group(function () {
                Route::get('/', [SupplierController::class, 'index'])->name('index');
                Route::get('/create', [SupplierController::class, 'create'])->name('create');
                Route::post('/', [SupplierController::class, 'store'])->name('store');
                Route::get('/{id}', [SupplierController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [SupplierController::class, 'edit'])->name('edit');
                Route::put('/{id}', [SupplierController::class, 'update'])->name('update');
                Route::delete('/{id}', [SupplierController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('supplier-invoices')->name('supplier-invoices.')->group(function () {
                Route::get('/', [SupplierInvoiceController::class, 'index'])->name('index');
                Route::get('/create', [SupplierInvoiceController::class, 'create'])->name('create');
                Route::post('/', [SupplierInvoiceController::class, 'store'])->name('store');
                Route::get('/{id}', [SupplierInvoiceController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [SupplierInvoiceController::class, 'edit'])->name('edit');
                Route::put('/{id}', [SupplierInvoiceController::class, 'update'])->name('update');
                Route::delete('/{id}', [SupplierInvoiceController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('payment-vouchers')->name('payment-vouchers.')->group(function () {
                Route::get('/', [PaymentVoucherController::class, 'index'])->name('index');
                Route::get('/create', [PaymentVoucherController::class, 'create'])->name('create');
                Route::post('/', [PaymentVoucherController::class, 'store'])->name('store');
                Route::get('/{id}', [PaymentVoucherController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [PaymentVoucherController::class, 'edit'])->name('edit');
                Route::put('/{id}', [PaymentVoucherController::class, 'update'])->name('update');
                Route::delete('/{id}', [PaymentVoucherController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('other-expenses')->name('other-expenses.')->group(function () {
                Route::get('/', [OtherExpenseController::class, 'index'])->name('index');
                Route::get('/create', [OtherExpenseController::class, 'create'])->name('create');
                Route::post('/', [OtherExpenseController::class, 'store'])->name('store');
                Route::get('/{id}', [OtherExpenseController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [OtherExpenseController::class, 'edit'])->name('edit');
                Route::put('/{id}', [OtherExpenseController::class, 'update'])->name('update');
                Route::delete('/{id}', [OtherExpenseController::class, 'destroy'])->name('destroy');
            });
        });

        // Expenses Module
        Route::prefix('expenses')->name('expenses.')->group(function () {
            Route::prefix('transactions')->name('transactions.')->group(function () {
                Route::get('/', [ExpenseTransactionController::class, 'index'])->name('index');
                Route::get('/create', [ExpenseTransactionController::class, 'create'])->name('create');
                Route::post('/', [ExpenseTransactionController::class, 'store'])->name('store');
                Route::get('/{id}', [ExpenseTransactionController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [ExpenseTransactionController::class, 'edit'])->name('edit');
                Route::put('/{id}', [ExpenseTransactionController::class, 'update'])->name('update');
                Route::delete('/{id}', [ExpenseTransactionController::class, 'destroy'])->name('destroy');
                Route::post('/{id}/post', [ExpenseTransactionController::class, 'post'])->name('post');
                Route::post('/{id}/reverse', [ExpenseTransactionController::class, 'reverse'])->name('reverse');
                Route::get('/export', [ExpenseTransactionController::class, 'export'])->name('export');
                Route::get('/statistics', [ExpenseTransactionController::class, 'statistics'])->name('statistics');
            });
            Route::prefix('vendors')->name('vendors.')->group(function () {
                Route::get('/', [VendorController::class, 'index'])->name('index');
                Route::get('/create', [VendorController::class, 'create'])->name('create');
                Route::post('/', [VendorController::class, 'store'])->name('store');
                Route::get('/{vendor}', [VendorController::class, 'show'])->name('show');
                Route::get('/{vendor}/edit', [VendorController::class, 'edit'])->name('edit');
                Route::put('/{vendor}', [VendorController::class, 'update'])->name('update');
                Route::delete('/{vendor}', [VendorController::class, 'destroy'])->name('destroy');
                Route::post('/export', [VendorController::class, 'export'])->name('export');
                Route::post('/bulk-destroy', [VendorController::class, 'bulkDestroy'])->name('bulk-destroy');
                Route::post('/{vendor}/generate-statement', [VendorController::class, 'generateStatement'])->name('generate-statement');
                Route::post('/{vendor}/toggle-status', [VendorController::class, 'toggleStatus'])->name('toggle-status');
                Route::get('/statistics', [VendorController::class, 'statistics'])->name('statistics');
            });
        });

        // Journals
        Route::prefix('journals')->name('journals.')->group(function () {
            Route::get('/', [JournalEntryController::class, 'index'])->name('index');
            Route::get('/create', [JournalEntryController::class, 'create'])->name('create');
            Route::post('/', [JournalEntryController::class, 'store'])->name('store');
            Route::get('/{id}', [JournalEntryController::class, 'show'])->name('show');
            Route::get('/{id}/edit', [JournalEntryController::class, 'edit'])->name('edit');
            Route::put('/{id}', [JournalEntryController::class, 'update'])->name('update');
            Route::delete('/{id}', [JournalEntryController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/post', [JournalEntryController::class, 'post'])->name('post');
            Route::post('/{id}/cancel', [JournalEntryController::class, 'cancel'])->name('cancel');
            Route::get('/approval/pending', [JournalEntryController::class, 'approvalIndex'])->name('approval-index');
            Route::post('/approval/bulk-approve', [JournalEntryController::class, 'bulkApprove'])->name('bulk-approve');
            Route::get('/draft', [JournalEntryController::class, 'draft'])->name('draft');
            Route::get('/posted', [JournalEntryController::class, 'posted'])->name('posted');
            Route::get('/cancelled', [JournalEntryController::class, 'cancelled'])->name('cancelled');
        });

        // Reports
        Route::prefix('reports')->name('reports.')->group(function () {
            Route::get('/', [ReportController::class, 'index'])->name('index');
            Route::get('/balance-sheet', [ReportController::class, 'balanceSheet'])->name('balance-sheet');
            Route::get('/income-statement', [ReportController::class, 'incomeStatement'])->name('income-statement');
            Route::get('/cash-flow', [ReportController::class, 'cashFlow'])->name('cash-flow');
            Route::get('/trial-balance', [ReportController::class, 'trialBalance'])->name('trial-balance');
            Route::get('/general-ledger', [ReportController::class, 'generalLedger'])->name('general-ledger');
        });

        // Cash and Banking
        Route::prefix('cash-banking')->name('cash-banking.')->group(function () {
            Route::get('/', [CashBankingController::class, 'index'])->name('index');
            Route::prefix('accounts')->name('accounts.')->group(function () {
                Route::get('/', [CashBankAccountController::class, 'index'])->name('index');
                Route::get('/create', [CashBankAccountController::class, 'create'])->name('create');
                Route::post('/', [CashBankAccountController::class, 'store'])->name('store');
                Route::get('/{id}', [CashBankAccountController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [CashBankAccountController::class, 'edit'])->name('edit');
                Route::put('/{id}', [CashBankAccountController::class, 'update'])->name('update');
                Route::delete('/{id}', [CashBankAccountController::class, 'destroy'])->name('destroy');
                Route::post('/{id}/toggle-status', [CashBankAccountController::class, 'toggleStatus'])->name('toggle-status');
            });
            Route::prefix('internal-transfers')->name('internal-transfers.')->group(function () {
                Route::get('/', [InternalTransferController::class, 'index'])->name('index');
                Route::get('/create', [InternalTransferController::class, 'create'])->name('create');
                Route::post('/', [InternalTransferController::class, 'store'])->name('store');
                Route::get('/{id}', [InternalTransferController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [InternalTransferController::class, 'edit'])->name('edit');
                Route::put('/{id}', [InternalTransferController::class, 'update'])->name('update');
                Route::delete('/{id}', [InternalTransferController::class, 'destroy'])->name('destroy');
                Route::post('/{id}/send', [InternalTransferController::class, 'send'])->name('send');
            });
            Route::prefix('petty-cash')->name('petty-cash.')->group(function () {
                Route::get('/', [PettyCashController::class, 'index'])->name('index');
                Route::get('/create', [PettyCashController::class, 'create'])->name('create');
                Route::post('/', [PettyCashController::class, 'store'])->name('store');
                Route::get('/{id}', [PettyCashController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [PettyCashController::class, 'edit'])->name('edit');
                Route::put('/{id}', [PettyCashController::class, 'update'])->name('update');
                Route::delete('/{id}', [PettyCashController::class, 'destroy'])->name('destroy');
                Route::post('/{id}/submit', [PettyCashController::class, 'submit'])->name('submit');
                Route::post('/{id}/approve', [PettyCashController::class, 'approve'])->name('approve');
                Route::post('/{id}/reject', [PettyCashController::class, 'reject'])->name('reject');
                Route::post('/{id}/mark-paid', [PettyCashController::class, 'markAsPaid'])->name('mark-paid');
                Route::post('/{id}/reimburse', [PettyCashController::class, 'reimburse'])->name('reimburse');
                Route::post('/{id}/reverse', [PettyCashController::class, 'reverse'])->name('reverse');
                Route::get('/export', [PettyCashController::class, 'export'])->name('export');
                Route::get('/statistics', [PettyCashController::class, 'statistics'])->name('statistics');
            });
            Route::prefix('cash-book')->name('cash-book.')->group(function () {
                Route::get('/', [CashBookController::class, 'index'])->name('index');
                Route::get('/export', [CashBookController::class, 'export'])->name('export');
            });
        });

        // Settings (Accounting)
        Route::prefix('settings')->name('settings.')->group(function () {
            Route::prefix('business-process-mappings')->name('business-process-mappings.')->group(function () {
                Route::get('/', [BusinessProcessMappingController::class, 'index'])->name('index');
                Route::post('/', [BusinessProcessMappingController::class, 'store'])->name('store');
                Route::put('/{id}', [BusinessProcessMappingController::class, 'update'])->name('update');
                Route::delete('/{id}', [BusinessProcessMappingController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('primary-categories')->name('primary-categories.')->group(function () {
                Route::get('/', [PrimaryCategoryController::class, 'index'])->name('index');
                Route::get('/create', [PrimaryCategoryController::class, 'create'])->name('create');
                Route::post('/', [PrimaryCategoryController::class, 'store'])->name('store');
                Route::get('/{id}', [PrimaryCategoryController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [PrimaryCategoryController::class, 'edit'])->name('edit');
                Route::put('/{id}', [PrimaryCategoryController::class, 'update'])->name('update');
                Route::delete('/{id}', [PrimaryCategoryController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('report-types')->name('report-types.')->group(function () {
                Route::get('/', [ReportTypeController::class, 'index'])->name('index');
                Route::get('/create', [ReportTypeController::class, 'create'])->name('create');
                Route::post('/', [ReportTypeController::class, 'store'])->name('store');
                Route::get('/{id}', [ReportTypeController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [ReportTypeController::class, 'edit'])->name('edit');
                Route::put('/{id}', [ReportTypeController::class, 'update'])->name('update');
                Route::delete('/{id}', [ReportTypeController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('account-groups')->name('account-groups.')->group(function () {
                Route::get('/', [AccountGroupController::class, 'index'])->name('index');
                Route::get('/create', [AccountGroupController::class, 'create'])->name('create');
                Route::post('/', [AccountGroupController::class, 'store'])->name('store');
                Route::get('/{id}', [AccountGroupController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [AccountGroupController::class, 'edit'])->name('edit');
                Route::put('/{id}', [AccountGroupController::class, 'update'])->name('update');
                Route::delete('/{id}', [AccountGroupController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('account-types')->name('account-types.')->group(function () {
                Route::get('/', [AccountTypeController::class, 'index'])->name('index');
                Route::get('/create', [AccountTypeController::class, 'create'])->name('create');
                Route::post('/', [AccountTypeController::class, 'store'])->name('store');
                Route::get('/{id}', [AccountTypeController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [AccountTypeController::class, 'edit'])->name('edit');
                Route::put('/{id}', [AccountTypeController::class, 'update'])->name('update');
                Route::delete('/{id}', [AccountTypeController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('financial-years')->name('financial-years.')->group(function () {
                Route::get('/', [FinancialYearController::class, 'index'])->name('index');
                Route::get('/create', [FinancialYearController::class, 'create'])->name('create');
                Route::post('/', [FinancialYearController::class, 'store'])->name('store');
                Route::get('/{id}', [FinancialYearController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [FinancialYearController::class, 'edit'])->name('edit');
                Route::put('/{id}', [FinancialYearController::class, 'update'])->name('update');
                Route::delete('/{id}', [FinancialYearController::class, 'destroy'])->name('destroy');
                Route::get('/{id}/close', [FinancialYearController::class, 'showClose'])->name('close.show');
                Route::post('/{id}/close', [FinancialYearController::class, 'close'])->name('close');
                Route::patch('/{id}/reopen', [FinancialYearController::class, 'reopen'])->name('reopen');
            });
            Route::prefix('currencies')->name('currencies.')->group(function () {
                Route::get('/', [CurrencyController::class, 'index'])->name('index');
                Route::get('/create', [CurrencyController::class, 'create'])->name('create');
                Route::post('/', [CurrencyController::class, 'store'])->name('store');
                Route::get('/{id}', [CurrencyController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [CurrencyController::class, 'edit'])->name('edit');
                Route::put('/{id}', [CurrencyController::class, 'update'])->name('update');
                Route::delete('/{id}', [CurrencyController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('currency-rates')->name('currency-rates.')->group(function () {
                Route::get('/', [CurrencyRateController::class, 'index'])->name('index');
                Route::get('/create', [CurrencyRateController::class, 'create'])->name('create');
                Route::post('/', [CurrencyRateController::class, 'store'])->name('store');
                Route::get('/{id}', [CurrencyRateController::class, 'show'])->name('show');
                Route::get('/{id}/edit', [CurrencyRateController::class, 'edit'])->name('edit');
                Route::put('/{id}', [CurrencyRateController::class, 'update'])->name('update');
                Route::delete('/{id}', [CurrencyRateController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('credit-score-tiers')->name('credit-score-tiers.')->group(function () {
               Route::get('/', [CreditScoreTierController::class, 'index'])->name('index');
               Route::post('/', [CreditScoreTierController::class, 'store'])->name('store');
               Route::get('/{tier}', [CreditScoreTierController::class, 'show'])->name('show');
               Route::put('/{tier}', [CreditScoreTierController::class, 'update'])->name('update');
               Route::delete('/{tier}', [CreditScoreTierController::class, 'destroy'])->name('destroy');
               Route::post('/{tier}/toggle-status', [CreditScoreTierController::class, 'toggleStatus'])->name('toggle-status');
            });
        });

        // Company Routes
        Route::prefix('company')->name('company.')->group(function () {
            Route::get('/', [CompanyController::class, 'index'])->name('index');
            Route::post('/update-currency', [CompanyController::class, 'updateReportingCurrency'])->name('update-currency');
            Route::post('/update-financial-year', [CompanyController::class, 'updateFinancialYear'])->name('update-financial-year');
            Route::post('/update-profile', [CompanyController::class, 'updateProfile'])->name('update-profile');
            Route::get('/history', [CompanyController::class, 'history'])->name('history');
        });
        
        // Payroll Module
        Route::prefix('payroll')->name('payroll.')->group(function () {
            Route::get('/', [PayrollController::class, 'index'])->name('index');
            Route::prefix('paye')->name('paye.')->group(function () {
              Route::get('/', [PayrollController::class, 'payeIndex'])->name('index');
              Route::post('/', [PayrollController::class, 'payeStore'])->name('store');
            });
            Route::prefix('napsa')->name('napsa.')->group(function () {
              Route::get('/', [PayrollController::class, 'nAPSAIndex'])->name('index');
              Route::post('/', [PayrollController::class, 'nAPSAStore'])->name('store');
            });
            Route::prefix('nhima')->name('nhima.')->group(function () {
               Route::get('/', [PayrollController::class, 'nHIMAIndex'])->name('index');
               Route::post('/', [PayrollController::class, 'nHIMAStore'])->name('store');
            });
            Route::prefix('periods')->name('periods.')->group(function () {
              Route::get('/', [PayrollController::class, 'periodsIndex'])->name('index');
              Route::post('/', [PayrollController::class, 'periodsStore'])->name('store');
              Route::post('/generate', [PayrollController::class, 'generatePeriods'])->name('generate');
              Route::put('/{id}', [PayrollController::class, 'periodsUpdate'])->name('update');
              Route::delete('/{id}', [PayrollController::class, 'periodsDestroy'])->name('destroy');
              Route::post('/{id}/close', [PayrollController::class, 'periodsClose'])->name('close');
              Route::post('/{id}/reopen', [PayrollController::class, 'periodsReopen'])->name('reopen');
            });
            Route::post('/calculate-paye', [PayrollController::class, 'calculatePAYE'])->name('calculate-paye');
            Route::get('/get-settings', [PayrollController::class, 'getSettingsForYear'])->name('get-settings');
            Route::prefix('employees')->name('employees.')->group(function () {
                Route::get('/', [PayrollController::class, 'employeesIndex'])->name('index');
                Route::get('/create', [PayrollController::class, 'employeesCreate'])->name('create');
                Route::post('/', [PayrollController::class, 'store'])->name('store');
                Route::get('/{id}', [PayrollController::class, 'employeesShow'])->name('show');
                Route::get('/{id}/edit', [PayrollController::class, 'employeesEdit'])->name('edit');
                Route::put('/{id}', [PayrollController::class, 'employeesUpdate'])->name('update');
                Route::delete('/{id}', [PayrollController::class, 'employeesDestroy'])->name('destroy');
                Route::post('/import', [PayrollController::class, 'employeesImport'])->name('import');
                Route::get('/template/download', [PayrollController::class, 'employeesTemplateDownload'])->name('template.download');
            });
            Route::prefix('earnings')->name('earnings.')->group(function () {
                Route::prefix('types')->name('types.')->group(function () {
                    Route::get('/', [PayrollController::class, 'earningTypesIndex'])->name('index');
                    Route::get('/create', [PayrollController::class, 'earningTypesCreate'])->name('create');
                    Route::post('/', [PayrollController::class, 'earningTypesStore'])->name('store');
                    Route::get('/{id}/edit', [PayrollController::class, 'earningTypesEdit'])->name('edit');
                    Route::put('/{id}', [PayrollController::class, 'earningTypesUpdate'])->name('update');
                    Route::delete('/{id}', [PayrollController::class, 'earningTypesDestroy'])->name('destroy');
                    Route::post('/{id}/toggle-status', [PayrollController::class, 'earningTypesToggleStatus'])->name('toggle-status');
                });
                Route::prefix('employee')->name('employee.')->group(function () {
                    Route::get('/{employeeId}', [PayrollController::class, 'employeeEarningsIndex'])->name('index');
                    Route::post('/{employeeId}', [PayrollController::class, 'employeeEarningsStore'])->name('store');
                    Route::get('/{employeeId}/edit/{earningId}', [PayrollController::class, 'employeeEarningsEdit'])->name('edit');
                    Route::put('/{employeeId}/{earningId}', [PayrollController::class, 'employeeEarningsUpdate'])->name('update');
                    Route::delete('/{employeeId}/{earningId}', [PayrollController::class, 'employeeEarningsDestroy'])->name('destroy');
                    Route::post('/{employeeId}/{earningId}/toggle-status', [PayrollController::class, 'employeeEarningsToggleStatus'])->name('toggle-status');
                });
                Route::prefix('bulk')->name('bulk.')->group(function () {
                    Route::get('/import', [PayrollController::class, 'earningsBulkImport'])->name('import');
                    Route::post('/import', [PayrollController::class, 'earningsBulkImportStore'])->name('import.store');
                    Route::get('/template', [PayrollController::class, 'earningsTemplateDownload'])->name('template');
                    Route::post('/assign', [PayrollController::class, 'earningsBulkAssign'])->name('assign');
                });
                Route::get('/reports', [PayrollController::class, 'earningsReportsIndex'])->name('reports.index');
                Route::get('/reports/summary', [PayrollController::class, 'earningsSummaryReport'])->name('reports.summary');
                Route::get('/reports/taxable', [PayrollController::class, 'taxableEarningsReport'])->name('reports.taxable');
            });
            Route::prefix('processing')->name('processing.')->group(function () {
                Route::get('/', [PayrollController::class, 'processingIndex'])->name('index');
                Route::get('/entry/{entryId}/details', [PayrollController::class, 'getEntryDetails'])->name('entry.details');
                Route::post('/entry/{entryId}/approve', [PayrollController::class, 'approveEntry'])->name('entry.approve');
                Route::post('/entry/{entryId}/pay', [PayrollController::class, 'processEntryPayment'])->name('entry.pay');
                Route::get('/entry/{entryId}/export', [PayrollController::class, 'exportEntry'])->name('entry.export');
                Route::post('/bulk-approve', [PayrollController::class, 'bulkApproveEntries'])->name('bulk.approve');
                Route::post('/bulk-pay', [PayrollController::class, 'bulkPayEntries'])->name('bulk.pay');
                Route::get('/create/{periodId}', [PayrollController::class, 'processingCreate'])->name('create');
                Route::post('/calculate', [PayrollController::class, 'processingCalculate'])->name('calculate');
                Route::get('/review/{runId}', [PayrollController::class, 'processingReview'])->name('review');
                Route::post('/approve/{runId}', [PayrollController::class, 'processingApprove'])->name('approve');
                Route::post('/pay/{runId}', [PayrollController::class, 'processingPay'])->name('pay');
                Route::post('/reverse/{runId}', [PayrollController::class, 'processingReverse'])->name('reverse');
                Route::get('/run/{runId}', [PayrollController::class, 'processingShow'])->name('show');
                Route::get('/entry/{entryId}', [PayrollController::class, 'processingEntryShow'])->name('entry.show');
                Route::post('/export/{runId}', [PayrollController::class, 'processingExport'])->name('export');
                Route::post('/export-bank/{runId}', [PayrollController::class, 'processingExportBank'])->name('export.bank');
            });
            Route::prefix('preparation')->name('preparation.')->group(function () {
                Route::get('/', [PayrollController::class, 'preparationIndex'])->name('index');
                Route::get('/period/{periodId}/create/{employeeId?}', [PayrollController::class, 'preparationCreate'])->name('create');
                Route::post('/period/{periodId}', [PayrollController::class, 'preparationStore'])->name('store');
                Route::put('/adjustment/{adjustmentId}', [PayrollController::class, 'preparationUpdate'])->name('update');
                Route::delete('/adjustment/{adjustmentId}', [PayrollController::class, 'preparationDestroy'])->name('destroy');
                Route::post('/adjustment/{adjustmentId}/approve', [PayrollController::class, 'preparationApprove'])->name('approve');
                Route::post('/adjustment/{adjustmentId}/unapprove', [PayrollController::class, 'preparationUnapprove'])->name('unapprove');
                Route::post('/period/{periodId}/bulk-approve', [PayrollController::class, 'preparationBulkApprove'])->name('bulk-approve');
                Route::get('/period/{periodId}/recurring-earnings', [PayrollController::class, 'getRecurringEarnings'])->name('recurring-earnings');
                Route::get('/period/{periodId}/employee/{employeeId}/adjustments', [PayrollController::class, 'getEmployeeAdjustments'])->name('employee-adjustments');
                Route::get('/preliminary-summary/{periodId}', [PayrollController::class, 'preliminarySummary'])->name('preliminary-summary');
                Route::get('/adjustments-modal/{periodId}/{employeeId}', [PayrollController::class, 'adjustmentsModal'])->name('adjustments-modal');
            });
            Route::prefix('reports')->name('reports.')->group(function () {
                Route::get('/', [PayrollController::class, 'reportsIndex'])->name('index');
                Route::get('/payroll-summary', [PayrollController::class, 'payrollSummary'])->name('payroll-summary');
                Route::get('/paye-report', [PayrollController::class, 'payeReport'])->name('paye-report');
                Route::get('/napsa-report', [PayrollController::class, 'napsaReport'])->name('napsa-report');
                Route::get('/nhima-report', [PayrollController::class, 'nhimaReport'])->name('nhima-report');
                Route::get('/employee-payslip/{entryId}', [PayrollController::class, 'employeePayslip'])->name('employee-payslip');
            });
            Route::prefix('leave')->name('leave.')->group(function () {
                Route::get('/', [LeaveController::class, 'index'])->name('index');
                Route::prefix('requests')->name('requests.')->group(function () {
                    Route::get('/', [LeaveController::class, 'requestsIndex'])->name('index');
                    Route::get('/create', [LeaveController::class, 'requestsCreate'])->name('create');
                    Route::post('/', [LeaveController::class, 'requestsStore'])->name('store');
                    Route::get('/{id}', [LeaveController::class, 'requestsShow'])->name('show');
                    Route::post('/{id}/approve', [LeaveController::class, 'requestsApprove'])->name('approve');
                    Route::post('/{id}/reject', [LeaveController::class, 'requestsReject'])->name('reject');
                    Route::post('/{id}/cancel', [LeaveController::class, 'requestsCancel'])->name('cancel');
                });
                Route::get('/pending-review', [LeaveController::class, 'pendingReview'])->name('pending-review');
                Route::get('/approved-leave', [LeaveController::class, 'approvedLeave'])->name('approved-leave');
                Route::get('/taken-leaves', [LeaveController::class, 'takenLeaves'])->name('taken-leaves');
                Route::prefix('settings')->name('settings.')->group(function () {
                    Route::get('/', [LeaveController::class, 'settingsIndex'])->name('index');
                    Route::get('/create', [LeaveController::class, 'settingsCreate'])->name('create');
                    Route::post('/', [LeaveController::class, 'settingsStore'])->name('store');
                    Route::get('/{id}/edit', [LeaveController::class, 'settingsEdit'])->name('edit');
                    Route::put('/{id}', [LeaveController::class, 'settingsUpdate'])->name('update');
                    Route::delete('/{id}', [LeaveController::class, 'destroy'])->name('destroy');
                });
                Route::prefix('balances')->name('balances.')->group(function () {
                    Route::get('/', [LeaveController::class, 'balancesIndex'])->name('index');
                    Route::post('/adjust', [LeaveController::class, 'balancesAdjust'])->name('adjust');
                    Route::post('/process-accrual', [LeaveController::class, 'processAccrual'])->name('process-accrual');
                });
                Route::prefix('reports')->name('reports.')->group(function () {
                    Route::get('/', [LeaveController::class, 'reportsIndex'])->name('index');
                    Route::get('/leave-utilization', [LeaveController::class, 'reportsLeaveUtilization'])->name('leave-utilization');
                    Route::get('/leave-calendar', [LeaveController::class, 'reportsLeaveCalendar'])->name('leave-calendar');
                });
            });
        });

        // Self Service
        Route::prefix('self-service')->name('self-service.')->group(function () {
            Route::get('/', [SelfServiceController::class, 'index'])->name('index');
            Route::prefix('payrolls')->name('payrolls.')->group(function () {
                Route::get('/', [SelfServiceController::class, 'payrollsIndex'])->name('index');
                Route::get('/{entryId}', [SelfServiceController::class, 'payrollShow'])->name('show');
                Route::get('/{entryId}/payslip', [SelfServiceController::class, 'generatePayslip'])->name('payslip');
            });
            Route::prefix('leave')->name('leave.')->group(function () {
                Route::get('/', [SelfServiceController::class, 'leaveIndex'])->name('index');
                Route::get('/create', [SelfServiceController::class, 'leaveCreate'])->name('create');
                Route::post('/', [SelfServiceController::class, 'leaveStore'])->name('store');
                Route::get('/{id}', [SelfServiceController::class, 'leaveShow'])->name('show');
                Route::post('/{id}/cancel', [SelfServiceController::class, 'leaveCancel'])->name('cancel');
            });
            Route::get('/approved-leave', [SelfServiceController::class, 'approvedLeave'])->name('approved-leave');
            Route::get('/running-leave', [SelfServiceController::class, 'runningLeave'])->name('running-leave');
        });
    });
    
    // System Settings (Root Admin Level)
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/branches', [BranchController::class, 'index'])->name('branches');
        Route::get('/users', [UserController::class, 'index'])->name('users');
        Route::get('/permissions', function () {
            return view('admin.settings.permissions');
        })->name('permissions');

        // NEW: Notification Settings
        
        Route::get('/notifications', [NotificationSettingsController::class, 'index'])
            ->name('notifications');

        Route::post('/notifications', [NotificationSettingsController::class, 'update'])
            ->name('notifications.update');
        
        
        
        
    });

    // Branch Management
    Route::prefix('branches')->name('branches.')->group(function () {
        Route::get('/', [BranchController::class, 'index'])->name('index');
        Route::post('/', [BranchController::class, 'store'])->name('store');
        Route::get('/{branch}', [BranchController::class, 'show'])->name('show');
        Route::put('/{branch}', [BranchController::class, 'update'])->name('update');
        Route::delete('/{branch}', [BranchController::class, 'destroy'])->name('destroy');
        Route::post('/{branch}/toggle-status', [BranchController::class, 'toggleStatus'])->name('toggle-status');
    });

    // User Management
    Route::prefix('users')->name('users.')->group(function () {
        Route::get('/', [UserController::class, 'index'])->name('index');
        Route::post('/', [UserController::class, 'store'])->name('store');
        Route::get('/{user}', [UserController::class, 'show'])->name('show');
        Route::put('/{user}', [UserController::class, 'update'])->name('update');
        Route::put('/{user}/password', [UserController::class, 'updatePassword'])->name('update-password');
        Route::post('/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('toggle-status');
        Route::delete('/{user}', [UserController::class, 'destroy'])->name('destroy');
    });
});

// Fallback
Route::fallback(function () {
    if (request()->is('api/*')) {
        abort(404, 'API endpoint not found');
    }
    if (auth()->check()) {
        return redirect()->route('admin.dashboard');
    }
    return redirect()->route('admin.login');
});