<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login | ZedBankOS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* Define the custom theme color: #0077C5 (ThemeBlue) */
        :root {
            --zedbank-blue: #0077C5;
            --zedbank-blue-dark: #005A94; /* Slightly darker shade for hover/focus */
        }

        /* Custom Tailwind-like classes for the theme color */
        .text-zedbank-blue { color: var(--zedbank-blue); } /* New class for the text logo */
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }
        .focus\:ring-zedbank-blue:focus {
            --tw-ring-color: var(--zedbank-blue);
            box-shadow: 0 0 0 2px var(--tw-ring-offset-color), 0 0 0 4px var(--zedbank-blue);
        }
        .focus\:border-zedbank-blue:focus { border-color: var(--zedbank-blue); }
    </style>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center">
    <div class="max-w-md w-full space-y-8 p-6">
        <div class="text-center">
            
            <h2 class="text-4xl font-extrabold text-gray-900 mb-2">
                <span class="text-zedbank-blue">Zed</span>Bank<span class="text-zedbank-blue">OS</span>
            </h2>
            <p class="mt-2 text-gray-600">Admin Portal Login</p>
            </div>
        
        <?php if($errors->any()): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p><?php echo e($error); ?></p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
        
        <?php if(session('status')): ?>
            <div class="bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>
        
        <form class="mt-8 space-y-6 bg-white p-8 rounded-xl shadow-sm border" method="POST" action="<?php echo e(route('admin.login.post')); ?>">
            <?php echo csrf_field(); ?>
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input id="email" name="email" type="email" required 
                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-1 focus:ring-zedbank-blue focus:border-zedbank-blue"
                       value="<?php echo e(old('email')); ?>"
                       placeholder="admin@example.com">
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="password" name="password" type="password" required 
                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-1 focus:ring-zedbank-blue focus:border-zedbank-blue"
                       placeholder="Enter your password">
            </div>

            <div>
                <button type="submit" 
                        class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-zedbank-blue hover:bg-zedbank-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-zedbank-blue">
                    Sign in to Admin Portal
                </button>
            </div>
        </form>
        
        <div class="text-center">
            <p class="text-sm text-gray-600">
                Access the admin portal for loan management
            </p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>