<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Offers Management | <?php echo e(config('app.name', 'IMMIA FINANCE')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"> 
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-edit {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .action-btn-edit:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-toggle {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
        .action-btn-toggle:hover {
            background-color: #F68C1E;
            color: white;
        }
        .action-btn-delete {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-delete:hover {
            background-color: #D83B01;
            color: white;
        }
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        
        /* Custom card colors for Index View */
        .card-total { background-color: #E1F0FA; } /* primaryLight */
        .card-active { background-color: #E1F7E9; } /* Light Green/Success */
        .card-inactive { background-color: #FEE8E6; } /* Light Red/Danger */
        .card-icon-total { color: #146CAA; }
        .card-icon-active { color: #107C10; }
        .card-icon-inactive { color: #D83B01; }
    </style>
</head>
<body class="bg-gray50">
    
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64">
        
        
        <?php
            // Define variables for header partial
            $pageTitle = 'Offers Management';
            $pageSubtitle = 'Manage and configure your loan offers'; 
        ?>
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-success mr-2"></i>
                            <span class="text-green-800 font-medium"><?php echo e(session('success')); ?></span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($errors->any() || session('error')): ?>
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-danger mr-2"></i>
                            <span class="text-red-800 font-medium">Please fix the following errors:</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <?php if($errors->any()): ?>
                        <ul class="mt-2 text-red-700 text-sm list-disc list-inside">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>
                    <?php if(session('error') && !$errors->any()): ?>
                        <p class="mt-2 text-red-700 text-sm"><?php echo e(session('error')); ?></p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                
                <div class="card-total rounded-lg border border-gray200 p-5 animate-fade-in">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center mr-3 border border-primaryLight">
                            <i class="fas fa-tag card-icon-total"></i>
                        </div>
                        <div>
                            <div class="text-sm text-gray600">Total Offers</div>
                            <div class="text-xl font-bold text-gray900"><?php echo e($stats['total'] ?? 0); ?></div>
                        </div>
                    </div>
                </div>
                
                
                <div class="card-active rounded-lg border border-gray200 p-5 animate-fade-in">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center mr-3 border border-green-100">
                            <i class="fas fa-check-circle card-icon-active"></i>
                        </div>
                        <div>
                            <div class="text-sm text-gray600">Active Offers</div>
                            <div class="text-xl font-bold text-gray900"><?php echo e($stats['active'] ?? 0); ?></div>
                        </div>
                    </div>
                </div>
                
                
                <div class="card-inactive rounded-lg border border-gray200 p-5 animate-fade-in">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center mr-3 border border-red-100">
                            <i class="fas fa-ban card-icon-inactive"></i>
                        </div>
                        <div>
                            <div class="text-sm text-gray600">Inactive Offers</div>
                            <div class="text-xl font-bold text-gray900"><?php echo e($stats['inactive'] ?? 0); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg border border-gray200 p-4 mb-6 animate-fade-in">
                <div class="flex flex-col md:flex-row md:items-center justify-between space-y-4 md:space-y-0">
                    <div>
                        <h2 class="text-lg font-semibold text-gray900">Loan Offers</h2>
                        <p class="text-gray600 text-sm mt-1"><?php echo e($offers->total()); ?> offer(s) found</p>
                    </div>
                    <div class="flex flex-col md:flex-row space-y-3 md:space-y-0 md:space-x-3">
                        <div>
                            <select id="statusFilter" class="quickbooks-input w-40">
                                <option value="all">All Status</option>
                                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                            </select>
                        </div>
                        
                        <div>
                            <select id="productFilter" class="quickbooks-input w-48">
                                <option value="all">All Products</option>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($product->id); ?>" <?php echo e(request('product_id') == $product->id ? 'selected' : ''); ?>>
                                    <?php echo e($product->product); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div>
                            <select id="tierFilter" class="quickbooks-input w-48">
                                <option value="all">All Credit Tiers</option>
                                <?php $__currentLoopData = $creditScoreTiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tier->id); ?>" <?php echo e(request('tier_id') == $tier->id ? 'selected' : ''); ?>>
                                    <?php echo e($tier->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <a href="<?php echo e(route('admin.accounting.offers.create')); ?>" 
                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                            <i class="fas fa-plus"></i>
                            New Offer
                        </a>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg border border-gray200 overflow-hidden animate-fade-in">
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Credit Score Tier</th>
                                <th>Amount Range</th>
                                <th>Duration (Days)</th>
                                <th>Interest Rate</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray100 transition-colors">
                                <td>
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-lg 
                                            <?php if($offer->is_active): ?> bg-green-100
                                            <?php else: ?> bg-gray-100 <?php endif; ?>
                                            flex items-center justify-center">
                                            <i class="fas fa-money-bill-wave 
                                                <?php if($offer->is_active): ?> text-green-600
                                                <?php else: ?> text-gray-600 <?php endif; ?>"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900"><?php echo e($offer->product_name); ?></div>
                                            <div class="text-xs text-gray500">Score: <?php echo e($offer->min_score); ?>-<?php echo e($offer->max_score); ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray900"><?php echo e($offer->credit_score_tier); ?></div>
                                    <div class="text-xs text-gray600"><?php echo e($offer->min_score); ?>-<?php echo e($offer->max_score); ?></div>
                                </td>
                                <td>
                                    <div class="text-sm font-medium text-gray900">
                                        ZMW <?php echo e(number_format($offer->min_amount, 0)); ?>

                                    </div>
                                    <div class="text-xs text-gray600">
                                        to ZMW <?php echo e(number_format($offer->max_amount, 0)); ?>

                                    </div>
                                </td>
                                <td>
                                    <div class="text-sm font-medium text-gray900">
                                        <?php echo e($offer->min_duration); ?> days
                                    </div>
                                    <div class="text-xs text-gray600">
                                        to <?php echo e($offer->max_duration); ?> days
                                    </div>
                                </td>
                                <td>
                                    <div class="space-y-1">
                                        <?php if($offer->daily_rate): ?>
                                        <div class="flex items-center gap-2">
                                            <span class="text-sm font-medium text-gray900"><?php echo e(number_format($offer->daily_rate, 2)); ?>% Daily</span>
                                        </div>
                                        <?php else: ?>
                                        <span class="text-xs text-gray500">N/A</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="quickbooks-badge 
                                        <?php if($offer->is_active): ?> bg-green-100 text-green-800
                                        <?php else: ?> bg-red-100 text-red-800 <?php endif; ?>">
                                        <?php echo e($offer->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                    <?php if($offer->is_finalized): ?>
                                        <span class="quickbooks-badge bg-primaryLight text-primary ml-1" title="Offer is permanently finalized">
                                            <i class="fas fa-lock"></i> Finalized
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="flex items-center">
                                        
                                        <?php if($offer->is_finalized): ?>
                                            
                                            <button type="button" 
                                                    class="action-btn action-btn-view"
                                                    title="Activated Offer: Cannot Edit/Delete/Toggle">
                                                <i class="fas fa-lock"></i>
                                            </button>
                                        <?php elseif($offer->is_active): ?>
                                            
                                            
                                            
                                            <button type="button" 
                                                    class="action-btn action-btn-delete toggle-status"
                                                    data-id="<?php echo e($offer->id); ?>"
                                                    title="Deactivate">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        <?php else: ?>
                                            
                                            
                                            <a href="<?php echo e(route('admin.accounting.offers.edit', $offer->id)); ?>" 
                                                class="action-btn action-btn-edit"
                                                title="Edit Offer">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            
                                            <button type="button" 
                                                    class="action-btn action-btn-delete delete-offer"
                                                    data-id="<?php echo e($offer->id); ?>"
                                                    data-name="<?php echo e($offer->product_name); ?> - <?php echo e($offer->credit_score_tier); ?>"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>

                                            
                                            <a href="<?php echo e(route('admin.accounting.offers.activate-form', $offer->id)); ?>"
                                               class="action-btn bg-primary hover:bg-primary/90 text-white ml-2"
                                               title="Finalize and Activate Offer">
                                                <i class="fas fa-bolt"></i> 
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-12"> 
                                    <div class="py-8 text-center">
                                        <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                            <i class="fas fa-tag text-gray500 text-2xl"></i>
                                        </div>
                                        <h3 class="text-lg font-medium text-gray900 mb-2">No offers found</h3>
                                        <p class="text-gray600 mb-6 max-w-md mx-auto">
                                            No loan offers have been configured yet. Click the button below to create your first offer.
                                        </p>
                                        <a href="<?php echo e(route('admin.accounting.offers.create')); ?>" 
                                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2 mx-auto inline-flex">
                                            <i class="fas fa-plus"></i>
                                            Create New Offer
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php if($offers->hasPages()): ?>
                <div class="px-6 py-4 border-t border-gray200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing <?php echo e($offers->firstItem()); ?> to <?php echo e($offers->lastItem()); ?> of <?php echo e($offers->total()); ?> results
                        </div>
                        <div class="flex space-x-2">
                            <?php if($offers->onFirstPage()): ?>
                            <span class="px-3 py-1 bg-gray100 text-gray500 rounded text-sm">Previous</span>
                            <?php else: ?>
                            <a href="<?php echo e($offers->previousPageUrl()); ?>" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">Previous</a>
                            <?php endif; ?>
                            
                            <?php $__currentLoopData = $offers->getUrlRange(1, $offers->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($page == $offers->currentPage()): ?>
                                <span class="px-3 py-1 bg-primary text-white rounded text-sm"><?php echo e($page); ?></span>
                                <?php else: ?>
                                <a href="<?php echo e($url); ?>" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">
                                    <?php echo e($page); ?>

                                </a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            <?php if($offers->hasMorePages()): ?>
                            <a href="<?php echo e($offers->nextPageUrl()); ?>" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">Next</a>
                            <?php else: ?>
                            <span class="px-3 py-1 bg-gray100 text-gray500 rounded text-sm">Next</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </main>
    </div>

    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4 hidden">
        <div class="bg-white rounded-lg max-w-md w-full">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray900">Confirm Delete</h3>
                    <button type="button" onclick="closeDeleteModal()" class="text-gray500 hover:text-gray700">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <p class="text-gray600 mb-6">
                    Are you sure you want to delete the offer "<span id="offerName" class="font-medium"></span>"?
                    This action cannot be undone.
                </p>
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeDeleteModal()" 
                            class="px-4 py-2 border border-gray300 text-gray700 rounded text-sm font-medium hover:bg-gray100">
                        Cancel
                    </button>
                    <form id="deleteForm" method="POST" action="">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" 
                                class="px-4 py-2 bg-danger text-white rounded text-sm font-medium hover:bg-danger/90">
                            Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Filter functionality (applies filters via URL parameters)
            const statusFilter = document.getElementById('statusFilter');
            const productFilter = document.getElementById('productFilter');
            const tierFilter = document.getElementById('tierFilter');
            
            function applyFilters() {
                const status = statusFilter.value;
                const product = productFilter.value;
                const tier = tierFilter.value;
                let url = '<?php echo e(route("admin.accounting.offers.index")); ?>';
                let params = [];
                
                if (status !== 'all') {
                    params.push(`status=${status}`);
                }
                
                if (product !== 'all') {
                    params.push(`product_id=${product}`);
                }
                
                if (tier !== 'all') {
                    params.push(`tier_id=${tier}`);
                }
                
                if (params.length > 0) {
                    url += '?' + params.join('&');
                }
                
                window.location.href = url;
            }
            
            statusFilter.addEventListener('change', applyFilters);
            productFilter.addEventListener('change', applyFilters);
            tierFilter.addEventListener('change', applyFilters);

            // Toggle offer status (Requires POST route: admin.accounting.offers.toggle-status)
            document.querySelectorAll('.toggle-status').forEach(button => {
                button.addEventListener('click', function() {
                    const offerId = this.getAttribute('data-id');
                    const button = this;
                    
                    // Disable button during request
                    button.disabled = true;
                    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                    
                    fetch('<?php echo e(url("admin/accounting/offers")); ?>/' + offerId + '/toggle-status', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content') || 'INVALID_TOKEN', 
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({})
                    })
                    .then(response => {
                        if (!response.ok) {
                            if (response.status === 403) {
                                throw new Error('Error: This offer is finalized and cannot be modified.');
                            }
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert('Error updating offer status: ' + (data.message || 'Unknown error.'));
                            location.reload(); 
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert(error.message || 'Error updating offer status');
                        location.reload();
                    });
                });
            });
            
            // Delete offer (Triggers Modal)
            document.querySelectorAll('.delete-offer').forEach(button => {
                button.addEventListener('click', function() {
                    const offerId = this.getAttribute('data-id');
                    const offerName = this.getAttribute('data-name');
                    
                    document.getElementById('offerName').textContent = offerName;
                    document.getElementById('deleteForm').action = '<?php echo e(url("admin/accounting/offers")); ?>/' + offerId;
                    document.getElementById('deleteModal').classList.remove('hidden');
                });
            });
            
            // Close modal when clicking outside
            document.getElementById('deleteModal')?.addEventListener('click', function(e) {
                if (e.target === this) {
                    closeDeleteModal();
                }
            });
            
            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
        
        function closeDeleteModal() {
            document.getElementById('deleteModal').classList.add('hidden');
        }
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/offers/index.blade.php ENDPATH**/ ?>