<?php
    $pageTitle = 'Create New Customer';
    $pageSubtitle = 'Add a new customer to the system';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
        }
        .bg-primary { background-color: var(--zedbank-blue); }
        .hover\:bg-secondary:hover { background-color: var(--zedbank-blue-dark); }
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-4 md:p-6">
            <form action="<?php echo e(route('admin.customers.store')); ?>" method="POST" class="max-w-4xl mx-auto space-y-4">
                <?php echo csrf_field(); ?>
                
                <!-- Personal Information Card -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 md:p-5">
                    <h3 class="text-base md:text-lg font-semibold text-gray-800 mb-3">Personal Information</h3>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
                        <div>
                            <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                            <select id="title" name="title" class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary">
                                <option value="">Select Title</option>
                                <option value="Mr">Mr</option>
                                <option value="Mrs">Mrs</option>
                                <option value="Miss">Miss</option>
                                <option value="Dr">Dr</option>
                                <option value="Prof">Prof</option>
                            </select>
                        </div>
                        
                        <div>
                            <label for="first_name" class="block text-sm font-medium text-gray-700 mb-1">First Name *</label>
                            <input type="text" id="first_name" name="first_name" required
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('first_name')); ?>">
                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label for="middle_name" class="block text-sm font-medium text-gray-700 mb-1">Middle Name</label>
                            <input type="text" id="middle_name" name="middle_name"
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('middle_name')); ?>">
                        </div>
                        
                        <div>
                            <label for="surname" class="block text-sm font-medium text-gray-700 mb-1">Surname *</label>
                            <input type="text" id="surname" name="surname" required
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('surname')); ?>">
                            <?php $__errorArgs = ['surname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label for="dob" class="block text-sm font-medium text-gray-700 mb-1">Date of Birth</label>
                            <input type="date" id="dob" name="dob"
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('dob')); ?>">
                        </div>
                    </div>
                </div>

                <!-- Contact Information Card -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 md:p-5">
                    <h3 class="text-base md:text-lg font-semibold text-gray-800 mb-3">Contact Information</h3>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address *</label>
                            <input type="email" id="email" name="email" required
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('email')); ?>">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Phone Number *</label>
                            <input type="text" id="phone" name="phone" required
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('phone')); ?>">
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label for="office_phone" class="block text-sm font-medium text-gray-700 mb-1">Office Phone</label>
                            <input type="text" id="office_phone" name="office_phone"
                                   class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                   value="<?php echo e(old('office_phone')); ?>">
                        </div>
                    </div>
                </div>

                <!-- Address Information Card -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 md:p-5">
                    <h3 class="text-base md:text-lg font-semibold text-gray-800 mb-3">Address Information</h3>
                    <div class="space-y-3">
                        <div>
                            <label for="address" class="block text-sm font-medium text-gray-700 mb-1">Address *</label>
                            <textarea id="address" name="address" required rows="2"
                                      class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"><?php echo e(old('address')); ?></textarea>
                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                            <div>
                                <label for="town" class="block text-sm font-medium text-gray-700 mb-1">Town/City *</label>
                                <input type="text" id="town" name="town" required
                                       class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                       value="<?php echo e(old('town')); ?>">
                                <?php $__errorArgs = ['town'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div>
                                <label for="province" class="block text-sm font-medium text-gray-700 mb-1">Province</label>
                                <input type="text" id="province" name="province"
                                       class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                       value="<?php echo e(old('province')); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Professional & Identification Combined Card -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 md:p-5">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        <!-- Professional Information -->
                        <div>
                            <h3 class="text-base md:text-lg font-semibold text-gray-800 mb-3">Professional Information</h3>
                            <div class="space-y-3">
                                <div>
                                    <label for="occupation" class="block text-sm font-medium text-gray-700 mb-1">Occupation</label>
                                    <input type="text" id="occupation" name="occupation"
                                           class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                           value="<?php echo e(old('occupation')); ?>">
                                </div>
                                
                                <div>
                                    <label for="company" class="block text-sm font-medium text-gray-700 mb-1">Company</label>
                                    <input type="text" id="company" name="company"
                                           class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                           value="<?php echo e(old('company')); ?>">
                                </div>
                                
                                <div>
                                    <label for="income" class="block text-sm font-medium text-gray-700 mb-1">Monthly Income (ZMW)</label>
                                    <input type="number" id="income" name="income" step="0.01" min="0"
                                           class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                           value="<?php echo e(old('income')); ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Identification -->
                        <div>
                            <h3 class="text-base md:text-lg font-semibold text-gray-800 mb-3">Identification</h3>
                            <div class="space-y-3">
                                <div>
                                    <label for="idtype" class="block text-sm font-medium text-gray-700 mb-1">ID Type</label>
                                    <select id="idtype" name="idtype" class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary">
                                        <option value="">Select ID Type</option>
                                        <option value="NRC">NRC</option>
                                        <option value="Passport">Passport</option>
                                        <option value="Drivers License">Driver's License</option>
                                        <option value="Voters Card">Voter's Card</option>
                                    </select>
                                </div>
                                
                                <div>
                                    <label for="number" class="block text-sm font-medium text-gray-700 mb-1">ID Number</label>
                                    <input type="text" id="number" name="number"
                                           class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary"
                                           value="<?php echo e(old('number')); ?>">
                                </div>
                                
                                <div>
                                    <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Customer Status *</label>
                                    <select id="status" name="status" required class="w-full border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-primary focus:border-primary">
                                        <option value="Active" selected>Active</option>
                                        <option value="Inactive">Inactive</option>
                                        <option value="Suspended">Suspended</option>
                                        <option value="Pending">Pending</option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions Card -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                    <div class="flex flex-col sm:flex-row justify-end space-y-2 sm:space-y-0 sm:space-x-3">
                        <a href="<?php echo e(route('admin.customers.index')); ?>" 
                           class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition text-sm text-center">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-secondary transition text-sm">
                            Create Customer
                        </button>
                    </div>
                </div>
            </form>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/customers/create.blade.php ENDPATH**/ ?>