<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Petty Cash Request | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* QuickBooks Online Styling */
        .quickbooks-input {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            color: #323130;
            background: white;
            width: 100%;
            transition: all 0.2s;
        }
        
        .quickbooks-input:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        
        .quickbooks-input::placeholder {
            color: #A19F9D;
        }
        
        .quickbooks-input:disabled {
            background-color: #F3F2F1;
            color: #A19F9D;
            cursor: not-allowed;
        }
        
        .quickbooks-select {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            color: #323130;
            background: white;
            width: 100%;
            transition: all 0.2s;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 24 24' fill='none' stroke='%23605E5C' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='m6 9 6 6 6-6'%3E%3C/path%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
            background-size: 16px;
            padding-right: 36px;
        }
        
        .quickbooks-select:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        
        .quickbooks-textarea {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            color: #323130;
            background: white;
            width: 100%;
            resize: vertical;
            min-height: 80px;
            transition: all 0.2s;
        }
        
        .quickbooks-textarea:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        
        .quickbooks-checkbox {
            width: 18px;
            height: 18px;
            border: 2px solid #605E5C;
            border-radius: 3px;
            cursor: pointer;
            accent-color: #146CAA;
        }
        
        .quickbooks-checkbox:checked {
            background-color: #146CAA;
            border-color: #146CAA;
        }
        
        .quickbooks-checkbox:focus {
            outline: 2px solid #146CAA;
            outline-offset: 2px;
        }
        
        .quickbooks-button-primary {
            background-color: #146CAA;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        
        .quickbooks-button-primary:hover {
            background-color: #11598C;
        }
        
        .quickbooks-button-primary:disabled {
            background-color: #A19F9D;
            cursor: not-allowed;
        }
        
        .quickbooks-button-secondary {
            background-color: white;
            color: #323130;
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .quickbooks-button-secondary:hover {
            background-color: #F3F2F1;
        }
        
        .quickbooks-label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            color: #323130;
            margin-bottom: 6px;
        }
        
        .quickbooks-label-required::after {
            content: "*";
            color: #D83B01;
            margin-left: 4px;
        }
        
        .quickbooks-field-help {
            display: block;
            font-size: 12px;
            color: #605E5C;
            margin-top: 4px;
        }
        
        .quickbooks-error {
            display: block;
            font-size: 12px;
            color: #D83B01;
            margin-top: 4px;
        }
        
        .quickbooks-success {
            display: block;
            font-size: 12px;
            color: #107C10;
            margin-top: 4px;
        }
        
        .quickbooks-info-box {
            background-color: #F3F2F1;
            border: 1px solid #EDEBE9;
            border-radius: 4px;
            padding: 12px;
            margin-top: 8px;
            font-size: 13px;
            color: #605E5C;
        }
        
        .quickbooks-section {
            border-top: 1px solid #EDEBE9;
            padding-top: 24px;
            margin-top: 24px;
        }
        
        .quickbooks-card {
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 4px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .quickbooks-badge-success {
            background-color: #E6F4EA;
            color: #107C10;
        }
        
        .quickbooks-badge-warning {
            background-color: #FFF4CE;
            color: #F68C1E;
        }
        
        .quickbooks-badge-error {
            background-color: #FEE;
            color: #D83B01;
        }
        
        .quickbooks-badge-info {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        
        /* Account Type Badges */
        .account-badge-cash {
            background-color: #E1F0FA;
            color: #146CAA;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
            margin-left: 4px;
        }
        
        .account-badge-bank {
            background-color: #E6F4EA;
            color: #107C10;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
            margin-left: 4px;
        }
        
        .account-badge-mobile {
            background-color: #FFF4CE;
            color: #F68C1E;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
            margin-left: 4px;
        }
        
        /* Currency Badge */
        .currency-badge {
            background-color: #F3F2F1;
            color: #605E5C;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
            margin-left: 4px;
        }
        
        /* Color Variables */
        :root {
            --primary: #146CAA;
            --primary-light: #E1F0FA;
            --secondary: #6b7280;
            --success: #107C10;
            --warning: #F68C1E;
            --danger: #D83B01;
            --info: #0078D4;
            --gray50: #FAF9F8;
            --gray100: #F3F2F1;
            --gray200: #EDEBE9;
            --gray300: #E1DFDD;
            --gray400: #C8C6C4;
            --gray500: #A19F9D;
            --gray600: #605E5C;
            --gray700: #323130;
            --gray800: #201F1E;
            --gray900: #000000;
        }

        /* Animation styles */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes fadeOut {
            from { opacity: 1; transform: translateY(0); }
            to { opacity: 0; transform: translateY(-10px); }
        }
        
        .animate-fade-in {
            animation: fadeIn 0.3s ease-out;
        }
        
        .animate-fade-out {
            animation: fadeOut 0.3s ease-in;
        }

        /* Form validation styles */
        .is-invalid {
            border-color: #D83B01 !important;
        }
        
        .is-valid {
            border-color: #107C10 !important;
        }
    </style>
</head>
<body class="bg-gray50">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64">
        <?php echo $__env->make('accounting.partials.header', ['title' => 'New Petty Cash Request', 'subtitle' => 'Create a new petty cash disbursement'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
                <div class="mb-6 quickbooks-card p-4 border-l-4 border-success animate-fade-in">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-success mr-3"></i>
                        <div>
                            <p class="font-medium text-gray900"><?php echo e(session('success')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 quickbooks-card p-4 border-l-4 border-danger animate-fade-in">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-danger mr-3"></i>
                        <div>
                            <p class="font-medium text-gray900"><?php echo e(session('error')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Form Container -->
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Main Form -->
                    <div class="lg:col-span-3">
                        <div class="quickbooks-card p-6">
                            <!-- Form Header with Back Button -->
                            <div class="border-b border-gray200 pb-4 mb-6">
                                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                                    <div>
                                        <h2 class="text-xl font-semibold text-gray900">
                                            Petty Cash Request Form
                                        </h2>
                                        <p class="text-gray600 text-sm mt-1">Fill in all required fields to create a new petty cash request</p>
                                    </div>
                                    <div>
                                        <a href="<?php echo e(route('admin.accounting.cash-banking.petty-cash.index')); ?>" 
                                           class="quickbooks-button-secondary flex items-center justify-center sm:justify-start">
                                            <i class="fas fa-arrow-left mr-2"></i>
                                            Back to List
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <form action="<?php echo e(route('admin.accounting.cash-banking.petty-cash.store')); ?>" method="POST" class="space-y-8" id="pettyCashForm">
                                <?php echo csrf_field(); ?>

                                <!-- Basic Information Section -->
                                <div>
                                    <h3 class="text-lg font-semibold text-gray900 mb-6">Basic Information</h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <!-- Transaction Date -->
                                        <div>
                                            <label for="transaction_date" class="quickbooks-label quickbooks-label-required">
                                                Transaction Date
                                            </label>
                                            <div class="relative">
                                                <input type="date" 
                                                       id="transaction_date" 
                                                       name="transaction_date" 
                                                       value="<?php echo e(old('transaction_date', date('Y-m-d'))); ?>" 
                                                       required
                                                       class="quickbooks-input pl-10">
                                                <i class="fas fa-calendar-alt absolute left-3 top-1/2 transform -translate-y-1/2 text-gray500"></i>
                                            </div>
                                            <?php $__errorArgs = ['transaction_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="quickbooks-error"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <!-- Payee -->
                                        <div>
                                            <label for="payee" class="quickbooks-label quickbooks-label-required">
                                                Payee
                                            </label>
                                            <input type="text" 
                                                   id="payee" 
                                                   name="payee" 
                                                   value="<?php echo e(old('payee')); ?>" 
                                                   required
                                                   placeholder="Enter payee name"
                                                   class="quickbooks-input">
                                            <?php $__errorArgs = ['payee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="quickbooks-error"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <!-- Description -->
                                    <div class="mt-6">
                                        <label for="description" class="quickbooks-label">
                                            Description
                                        </label>
                                        <textarea id="description" 
                                                  name="description" 
                                                  rows="3" 
                                                  placeholder="Enter overall description (optional)"
                                                  class="quickbooks-textarea"><?php echo e(old('description')); ?></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="quickbooks-error"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Items Section -->
                                <div class="quickbooks-section">
                                    <div class="flex justify-between items-center mb-6">
                                        <h3 class="text-lg font-semibold text-gray900">Items to be Purchased</h3>
                                        <span class="text-sm text-gray600">Add at least one item</span>
                                    </div>
                                    
                                    <div class="quickbooks-card p-4">
                                        <div class="overflow-x-auto">
                                            <table class="quickbooks-table">
                                                <thead>
                                                    <tr>
                                                        <th class="text-sm font-medium text-gray700">Item</th>
                                                        <th class="text-sm font-medium text-gray700">Description</th>
                                                        <th class="text-sm font-medium text-gray700">Amount</th>
                                                        <th class="text-sm font-medium text-gray700">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="itemsContainer">
                                                    <!-- Items will be added here dynamically -->
                                                </tbody>
                                                <tfoot class="bg-gray100">
                                                    <tr>
                                                        <td colspan="2" class="text-right text-sm font-medium text-gray700 py-3">Total Amount:</td>
                                                        <td class="py-3">
                                                            <div class="text-lg font-semibold text-gray900" id="totalAmount">0.00</div>
                                                            <div class="text-xs text-gray500" id="baseAmountDisplay">Base: 0.00</div>
                                                        </td>
                                                        <td></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                        
                                        <button type="button" 
                                                onclick="addItem()" 
                                                class="quickbooks-button-secondary mt-4 flex items-center">
                                            <i class="fas fa-plus mr-2"></i>Add Item
                                        </button>
                                    </div>
                                </div>

                                <!-- Currency & Exchange Rate Section -->
                                <div class="quickbooks-section">
                                    <h3 class="text-lg font-semibold text-gray900 mb-6">Currency & Exchange Rate</h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <!-- Currency -->
                                        <div>
                                            <label for="currency" class="quickbooks-label quickbooks-label-required">
                                                Currency
                                            </label>
                                            <select id="currency" 
                                                    name="currency" 
                                                    required
                                                    class="quickbooks-select">
                                                <option value="">Select Currency</option>
                                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($currency->code); ?>" 
                                                        data-symbol="<?php echo e($currency->symbol); ?>"
                                                        data-name="<?php echo e($currency->name); ?>"
                                                        <?php echo e(old('currency', $reportingCurrency?->code) == $currency->code ? 'selected' : ''); ?>>
                                                    <?php echo e($currency->code); ?> - <?php echo e($currency->name); ?> 
                                                </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ['currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="quickbooks-error"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <p class="quickbooks-field-help">
                                                Default: <?php echo e($reportingCurrency?->code); ?> - <?php echo e($reportingCurrency?->name); ?> 
                                                (<?php echo e($reportingCurrency?->symbol); ?>)
                                            </p>
                                        </div>

                                        <!-- Exchange Rate -->
                                        <div>
                                            <label for="exchange_rate" class="quickbooks-label quickbooks-label-required">
                                                Exchange Rate
                                            </label>
                                            <div class="relative">
                                                <input type="number" 
                                                       id="exchange_rate" 
                                                       name="exchange_rate" 
                                                       value="<?php echo e(old('exchange_rate', 1)); ?>" 
                                                       required
                                                       min="0.0001" 
                                                       step="0.0001"
                                                       class="quickbooks-input pr-20"
                                                       oninput="calculateBaseAmount()">
                                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2 text-sm text-gray600">
                                                    <span id="rateText">
                                                        <?php if($reportingCurrency): ?>
                                                        1 <?php echo e($reportingCurrency->code); ?> = 
                                                        <?php else: ?>
                                                        1 USD = 
                                                        <?php endif; ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <?php $__errorArgs = ['exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="quickbooks-error"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <p class="quickbooks-field-help">
                                                <span id="baseRateText">
                                                    <?php if($reportingCurrency): ?>
                                                    Base currency: <?php echo e($reportingCurrency->code); ?> (<?php echo e($reportingCurrency->name); ?>)
                                                    <?php else: ?>
                                                    Base currency: USD
                                                    <?php endif; ?>
                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Payment Information Section -->
                                <div class="quickbooks-section">
                                    <h3 class="text-lg font-semibold text-gray900 mb-6">Payment Information</h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <!-- Source Account (All account types: Cash, Bank, Mobile Money) -->
                                        <div>
                                            <label for="source_account_id" class="quickbooks-label quickbooks-label-required">
                                                Source Account
                                            </label>
                                            <select id="source_account_id" 
                                                    name="source_account_id" 
                                                    required
                                                    class="quickbooks-select">
                                                <option value="">Select Source Account</option>
                                                <?php $__currentLoopData = $sourceAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(in_array($account->accountType, ['Cash', 'Bank', 'Mobile Money'])): ?>
                                                    <option value="<?php echo e($account->cashBankId); ?>" 
                                                            data-account-type="<?php echo e($account->accountType); ?>"
                                                            data-currency="<?php echo e($account->currency); ?>"
                                                            data-balance="<?php echo e($account->current_balance); ?>"
                                                            <?php echo e(old('source_account_id') == $account->cashBankId ? 'selected' : ''); ?>>
                                                        <?php echo e($account->accountType); ?> - <?php echo e($account->accountName); ?> (<?php echo e($account->currency); ?>)
                                                    </option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="mt-3 quickbooks-info-box">
                                                <div class="flex items-center justify-between">
                                                    <span class="text-sm text-gray600">Available Balance:</span>
                                                    <span id="accountBalance" class="text-sm font-medium text-gray900">0.00</span>
                                                    <span id="accountCurrency" class="text-sm text-gray600"></span>
                                                </div>
                                            </div>
                                            <p class="quickbooks-field-help">Select from Cash, Bank, or Mobile Money accounts</p>
                                            <?php $__errorArgs = ['source_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="quickbooks-error"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <!-- Receipting Account (Only Cash accounts) -->
                                        <div>
                                            <label for="receipting_account_id" class="quickbooks-label quickbooks-label-required">
                                                Receipting Account
                                            </label>
                                            <select id="receipting_account_id" 
                                                    name="receipting_account_id" 
                                                    required
                                                    class="quickbooks-select">
                                                <option value="">Select Receipting Account</option>
                                                <?php $__currentLoopData = $sourceAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($account->accountType == 'Cash'): ?>
                                                    <option value="<?php echo e($account->cashBankId); ?>" 
                                                            data-currency="<?php echo e($account->currency); ?>"
                                                            <?php echo e(old('receipting_account_id') == $account->cashBankId ? 'selected' : ''); ?>>
                                                        <?php echo e($account->accountType); ?> - <?php echo e($account->accountName); ?> (<?php echo e($account->currency); ?>)
                                                    </option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <p class="quickbooks-field-help">Select a Cash account for receipting</p>
                                            <?php $__errorArgs = ['receipting_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="quickbooks-error"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- Form Actions -->
                                <div class="border-t border-gray200 pt-6 mt-6">
                                    <div class="flex justify-end space-x-3">
                                        <button type="submit" 
                                                class="quickbooks-button-primary flex items-center">
                                            <i class="fas fa-save mr-2"></i>
                                            Save as Draft
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Items management
        let itemCounter = 0;
        const itemsContainer = document.getElementById('itemsContainer');
        const totalAmountElement = document.getElementById('totalAmount');
        const baseAmountDisplay = document.getElementById('baseAmountDisplay');

        function addItem(itemData = {}) {
            itemCounter++;
            
            const itemRow = document.createElement('tr');
            itemRow.id = `itemRow${itemCounter}`;
            itemRow.innerHTML = `
                <td class="py-3">
                    <select name="items[${itemCounter}][chart_of_account_id]" 
                            class="quickbooks-select w-full item-account" 
                            onchange="validateItemField(this)">
                        <option value="">Select Item</option>
                        <?php $__currentLoopData = $chartOfAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($account->id); ?>" ${itemData.chart_of_account_id == <?php echo e($account->id); ?> ? 'selected' : ''}>
                            <?php echo e($account->name); ?> (<?php echo e($account->code); ?>)
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="quickbooks-error hidden" id="accountError${itemCounter}">Please select an item</span>
                </td>
                <td class="py-3">
                    <input type="text" 
                           name="items[${itemCounter}][item_description]" 
                           value="${itemData.item_description || ''}"
                           required
                           class="quickbooks-input w-full item-description"
                           placeholder="Enter description"
                           oninput="validateItemField(this)">
                    <span class="quickbooks-error hidden" id="descriptionError${itemCounter}">Please enter a description</span>
                </td>
                <td class="py-3">
                    <div class="relative">
                        <input type="number" 
                               name="items[${itemCounter}][amount]" 
                               value="${itemData.amount || ''}"
                               required
                               min="0.01" 
                               step="0.01"
                               class="quickbooks-input w-full pr-10 item-amount"
                               placeholder="0.00"
                               oninput="validateItemField(this); calculateTotal()">
                        <span class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray600 text-sm">
                            <span id="itemCurrency${itemCounter}">
                                <?php if($reportingCurrency): ?>
                                <?php echo e($reportingCurrency->symbol); ?>

                                <?php else: ?>
                                USD
                                <?php endif; ?>
                            </span>
                        </span>
                    </div>
                    <span class="quickbooks-error hidden" id="amountError${itemCounter}">Please enter a valid amount</span>
                </td>
                <td class="py-3">
                    <button type="button" 
                            onclick="removeItem(${itemCounter})"
                            class="quickbooks-button-secondary p-2 text-danger hover:text-danger/90">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            `;
            
            itemsContainer.appendChild(itemRow);
            calculateTotal();
            updateCurrencyDisplay(); // Update currency symbol for new item
        }

        function removeItem(itemId) {
            const row = document.getElementById(`itemRow${itemId}`);
            if (row) {
                row.remove();
                calculateTotal();
            }
        }

        function validateItemField(field) {
            const value = field.value.trim();
            const isSelect = field.tagName === 'SELECT';
            const isEmpty = isSelect ? value === '' : value === '';
            const isAmount = field.classList.contains('item-amount');
            
            // Remove existing error classes
            field.classList.remove('is-invalid', 'is-valid');
            
            if (isEmpty) {
                field.classList.add('is-invalid');
            } else {
                field.classList.add('is-valid');
                
                // Additional validation for amount
                if (isAmount) {
                    const amountValue = parseFloat(value);
                    if (isNaN(amountValue) || amountValue <= 0) {
                        field.classList.add('is-invalid');
                        field.classList.remove('is-valid');
                    }
                }
            }
            
            // Show/hide error message
            const errorId = isSelect ? `accountError${field.closest('tr').id.replace('itemRow', '')}` :
                          isAmount ? `amountError${field.closest('tr').id.replace('itemRow', '')}` :
                          `descriptionError${field.closest('tr').id.replace('itemRow', '')}`;
            
            const errorElement = document.getElementById(errorId);
            if (errorElement) {
                if (isEmpty || (isAmount && (isNaN(parseFloat(value)) || parseFloat(value) <= 0))) {
                    errorElement.classList.remove('hidden');
                } else {
                    errorElement.classList.add('hidden');
                }
            }
        }

        function calculateTotal() {
            let total = 0;
            const amountInputs = document.querySelectorAll('.item-amount');
            let hasInvalidAmounts = false;
            
            amountInputs.forEach(input => {
                const value = parseFloat(input.value) || 0;
                total += value;
                
                // Validate amount
                if (value <= 0) {
                    hasInvalidAmounts = true;
                    input.classList.add('is-invalid');
                    input.classList.remove('is-valid');
                } else {
                    input.classList.add('is-valid');
                    input.classList.remove('is-invalid');
                }
            });
            
            const formattedTotal = total.toLocaleString('en-US', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
            
            totalAmountElement.textContent = formattedTotal;
            
            // Calculate base amount
            calculateBaseAmount();
            
            // Update account balance validation
            updateAccountBalance();
        }

        function calculateBaseAmount() {
            const total = parseFloat(totalAmountElement.textContent.replace(/,/g, '')) || 0;
            const exchangeRate = parseFloat(document.getElementById('exchange_rate').value) || 1;
            const baseAmount = total * exchangeRate;
            
            baseAmountDisplay.textContent = `Base: ${baseAmount.toLocaleString('en-US', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            })}`;
        }

        // Update account balance display
        function updateAccountBalance() {
            const select = document.getElementById('source_account_id');
            const selectedOption = select.options[select.selectedIndex];
            const balanceInfo = document.getElementById('accountBalance').closest('.quickbooks-info-box');
            
            // Reset styling
            document.getElementById('accountBalance').classList.remove('text-success', 'text-danger');
            balanceInfo.classList.remove('border-success', 'border-danger');
            balanceInfo.classList.add('border-gray200');
            
            if (selectedOption && selectedOption.value) {
                const balance = parseFloat(selectedOption.getAttribute('data-balance')) || 0;
                const currency = selectedOption.getAttribute('data-currency') || '';
                
                const formattedBalance = balance.toLocaleString('en-US', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
                
                document.getElementById('accountBalance').textContent = formattedBalance;
                document.getElementById('accountCurrency').textContent = currency;
                
                // Check if total exceeds balance
                const total = parseFloat(totalAmountElement.textContent.replace(/,/g, '')) || 0;
                
                if (total > 0 && total > balance) {
                    document.getElementById('accountBalance').classList.add('text-danger');
                    balanceInfo.classList.add('border-danger');
                    balanceInfo.classList.remove('border-gray200');
                } else if (total > 0 && total <= balance) {
                    document.getElementById('accountBalance').classList.add('text-success');
                    balanceInfo.classList.add('border-success');
                    balanceInfo.classList.remove('border-gray200');
                }
            } else {
                document.getElementById('accountBalance').textContent = '0.00';
                document.getElementById('accountCurrency').textContent = '';
            }
        }

        // Update currency display
        function updateCurrencyDisplay() {
            const currencySelect = document.getElementById('currency');
            const selectedOption = currencySelect.options[currencySelect.selectedIndex];
            const currencySymbol = selectedOption ? selectedOption.getAttribute('data-symbol') || currencySelect.value : '';
            const currencyName = selectedOption ? selectedOption.getAttribute('data-name') || currencySelect.value : '';
            const rateText = document.getElementById('rateText');
            const baseRateText = document.getElementById('baseRateText');
            
            // Get reporting currency code
            const reportingCurrencyCode = '<?php echo e($reportingCurrency?->code); ?>' || 'USD';
            const reportingCurrencyName = '<?php echo e($reportingCurrency?->name); ?>' || 'US Dollar';
            
            rateText.textContent = `1 ${reportingCurrencyCode} = `;
            baseRateText.textContent = `Base currency: ${reportingCurrencyCode} (${reportingCurrencyName})`;
            
            // Update currency on all item inputs
            document.querySelectorAll('[id^="itemCurrency"]').forEach(element => {
                element.textContent = currencySymbol || reportingCurrencyCode;
            });
            
            // If selected currency is the reporting currency, set exchange rate to 1
            if (currencySelect.value && currencySelect.value === reportingCurrencyCode) {
                document.getElementById('exchange_rate').value = 1;
                calculateBaseAmount();
            }
        }

        // Validate exchange rate
        function validateExchangeRate() {
            const exchangeRateInput = document.getElementById('exchange_rate');
            const value = parseFloat(exchangeRateInput.value);
            
            exchangeRateInput.classList.remove('is-invalid', 'is-valid');
            
            if (isNaN(value) || value <= 0) {
                exchangeRateInput.classList.add('is-invalid');
                return false;
            } else {
                exchangeRateInput.classList.add('is-valid');
                return true;
            }
        }

        // Form validation
        document.getElementById('pettyCashForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            let isValid = true;
            let errorMessage = '';
            
            // Validate basic fields
            const requiredFields = [
                { id: 'transaction_date', name: 'Transaction Date' },
                { id: 'payee', name: 'Payee' },
                { id: 'currency', name: 'Currency' },
                { id: 'exchange_rate', name: 'Exchange Rate' },
                { id: 'source_account_id', name: 'Source Account' },
                { id: 'receipting_account_id', name: 'Receipting Account' }
            ];
            
            requiredFields.forEach(field => {
                const element = document.getElementById(field.id);
                if (!element.value.trim()) {
                    element.classList.add('is-invalid');
                    isValid = false;
                    errorMessage = `Please fill in all required fields. ${field.name} is required.`;
                } else {
                    element.classList.remove('is-invalid');
                }
            });
            
            // Validate exchange rate
            if (!validateExchangeRate()) {
                isValid = false;
                errorMessage = 'Please enter a valid exchange rate greater than 0.';
            }
            
            // Validate items
            const itemRows = document.querySelectorAll('#itemsContainer tr[id^="itemRow"]');
            if (itemRows.length === 0) {
                isValid = false;
                errorMessage = 'Please add at least one item.';
            }
            
            let hasValidItems = false;
            itemRows.forEach(row => {
                const accountSelect = row.querySelector('.item-account');
                const descriptionInput = row.querySelector('.item-description');
                const amountInput = row.querySelector('.item-amount');
                
                if (!accountSelect.value || !descriptionInput.value.trim() || !amountInput.value || parseFloat(amountInput.value) <= 0) {
                    isValid = false;
                    if (!errorMessage) {
                        errorMessage = 'Please ensure all items have a valid account, description, and amount.';
                    }
                } else {
                    hasValidItems = true;
                }
            });
            
            if (!hasValidItems && itemRows.length > 0) {
                isValid = false;
                errorMessage = 'Please ensure all items have a valid account, description, and amount.';
            }
            
            // Validate total amount
            const total = parseFloat(totalAmountElement.textContent.replace(/,/g, '')) || 0;
            if (total <= 0) {
                isValid = false;
                errorMessage = 'Total amount must be greater than 0.';
            }
            
            // Validate account balance
            const selectedOption = document.getElementById('source_account_id').options[document.getElementById('source_account_id').selectedIndex];
            const balance = selectedOption ? parseFloat(selectedOption.getAttribute('data-balance')) || 0 : 0;
            
            if (selectedOption && total > balance) {
                isValid = false;
                errorMessage = 'Insufficient account balance! Please select an account with sufficient funds.';
            }
            
            if (isValid) {
                // Submit the form
                this.submit();
            } else {
                showNotification(errorMessage, 'error');
                
                // Scroll to first error
                const firstError = document.querySelector('.is-invalid');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    firstError.focus();
                }
            }
        });

        // Event listeners
        document.getElementById('currency').addEventListener('change', updateCurrencyDisplay);
        document.getElementById('exchange_rate').addEventListener('input', function() {
            validateExchangeRate();
            calculateBaseAmount();
        });
        document.getElementById('source_account_id').addEventListener('change', updateAccountBalance);

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateCurrencyDisplay();
            updateAccountBalance();
            
            // Set default date to today
            const today = new Date().toISOString().split('T')[0];
            const dateInput = document.getElementById('transaction_date');
            if (dateInput && !dateInput.value) {
                dateInput.value = today;
            }
            
            // Validate existing date
            if (dateInput && dateInput.value) {
                dateInput.classList.add('is-valid');
            }
            
            // Add initial empty item
            addItem();
            
            // Auto-hide success/error messages after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.quickbooks-card.border-l-4');
                alerts.forEach(alert => {
                    alert.classList.add('animate-fade-out');
                    setTimeout(() => {
                        alert.style.display = 'none';
                    }, 300);
                });
            }, 5000);
        });

        // Notification function
        function showNotification(message, type = 'info') {
            // Remove existing notification
            const existing = document.querySelector('.quickbooks-notification');
            if (existing) existing.remove();

            const colors = {
                success: 'border-success bg-green-50',
                error: 'border-danger bg-red-50',
                info: 'border-primary bg-blue-50',
                warning: 'border-warning bg-yellow-50'
            };

            const icons = {
                success: 'fa-check-circle text-success',
                error: 'fa-exclamation-circle text-danger',
                info: 'fa-info-circle text-primary',
                warning: 'fa-exclamation-triangle text-warning'
            };

            const notification = document.createElement('div');
            notification.className = `quickbooks-notification fixed top-4 right-4 quickbooks-card p-4 border-l-4 ${colors[type]} shadow-lg z-50 flex items-center animate-fade-in max-w-md`;
            notification.innerHTML = `
                <i class="fas ${icons[type]} mr-3 text-lg"></i>
                <span class="text-gray900">${message}</span>
                <button onclick="this.parentElement.remove()" class="ml-auto text-gray500 hover:text-gray700">
                    <i class="fas fa-times"></i>
                </button>
            `;

            document.body.appendChild(notification);

            // Remove after 5 seconds
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.classList.add('animate-fade-out');
                    setTimeout(() => {
                        if (notification.parentElement) {
                            notification.remove();
                        }
                    }, 300);
                }
            }, 5000);
        }
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/cash-banking/petty-cash/create.blade.php ENDPATH**/ ?>