<?php
    $pageTitle = 'Quotation Matrix';
    $pageSubtitle = 'Dynamic installments based on monthly reducing balance';

    $monthlyRatePercent = request('rate', 10);
    $monthlyRate = $monthlyRatePercent / 100; 

    $amounts = [2000, 3000, 5000, 8000, 10000, 12000, 15000, 18000, 20000, 25000, 30000, 40000, 50000, 60000, 80000, 100000];
    $tenures = [2, 3, 6, 12, 18, 24, 30, 36, 48, 60];

    if (!function_exists('calculateReducingInstallment')) {
        function calculateReducingInstallment($p, $i, $n) {
            if ($i == 0) return $p / $n;
            return ($p * $i * pow(1 + $i, $n)) / (pow(1 + $i, $n) - 1);
        }
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --zedbank-blue: #0077C5; --midnight-indigo: #1A237E; }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        .custom-scrollbar::-webkit-scrollbar { height: 8px; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: var(--zedbank-blue); border-radius: 10px; }
        .sticky-col { position: sticky; left: 0; z-index: 10; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="lg:ml-64 min-h-screen">
        <?php echo $__env->make('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                <div class="flex flex-col md:flex-row justify-between items-end gap-4">
                    <form action="<?php echo e(url()->current()); ?>" method="GET" class="flex items-end gap-4 w-full md:w-auto">
                        <div class="w-full md:w-auto">
                            <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Monthly Interest Rate (%)</label>
                            <input type="number" name="rate" value="<?php echo e($monthlyRatePercent); ?>" step="0.01" 
                                   class="block w-full md:w-48 px-4 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue text-sm font-bold text-midnight">
                        </div>
                        <button type="submit" class="px-6 py-2 bg-zedbank-blue text-white rounded-lg hover:opacity-90 transition font-semibold text-sm shadow-sm">
                            Update
                        </button>
                    </form>
                    
                    
                    <a href="<?php echo e(route('admin.quotations.schedule.pdf', ['rate' => $monthlyRatePercent])); ?>" 
                       class="px-6 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition flex items-center gap-2 text-sm font-semibold shadow-sm">
                        <i class="fas fa-file-pdf"></i>
                        <span>Export PDF</span>
                    </a>
                </div>
            </div>

            <div class="bg-white shadow-sm rounded-lg border border-gray-200 overflow-hidden">
                <div class="overflow-x-auto custom-scrollbar">
                    <table class="min-w-full text-sm border-collapse">
                         <thead class="bg-[#1A237E] sticky top-0 z-20">
    <tr>
        <th class="px-6 py-4 text-left font-bold uppercase text-[11px] sticky-col bg-[#1A237E] text-white shadow-[1px_0_0_0_rgba(255,255,255,0.1)]">
            Tenure
        </th>
        <?php $__currentLoopData = $amounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <th class="px-6 py-4 text-center font-bold uppercase text-[11px] text-white border-l border-white/10 min-w-[110px]">
                <?php echo e(number_format($amount)); ?>

            </th>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tr>
</thead>
                        <tbody class="divide-y divide-gray-100">
                            <?php $__currentLoopData = $tenures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $months): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-blue-50/50">
                                    <td class="px-6 py-4 font-bold text-midnight bg-gray-50 border-r border-gray-200 sticky-col"><?php echo e($months); ?> Mo</td>
                                    <?php $__currentLoopData = $amounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td class="px-6 py-4 text-center font-semibold text-gray-700">
                                            <?php echo e(number_format(calculateReducingInstallment($amount, $monthlyRate, $months), 0)); ?>

                                        </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/quotations/schedule.blade.php ENDPATH**/ ?>