<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Loan Application Approved</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .loan-details { background: white; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #10B981; }
        .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }
        .button { display: inline-block; padding: 12px 30px; background: #10B981; color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .highlight { color: #10B981; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎉 Congratulations!</h1>
            <h2>Your Loan Application Has Been Approved</h2>
        </div>
        
        <div class="content">
            <p>Dear <strong><?php echo e($customer->first_name); ?> <?php echo e($customer->surname); ?></strong>,</p>
            
            <p>We are pleased to inform you that your loan application has been <span class="highlight">approved</span>!</p>
            
            <div class="loan-details">
                <h3 style="margin-top: 0; color: #10B981;">Loan Details</h3>
                <table style="width: 100%;">
                    <tr>
                        <td style="padding: 8px 0;"><strong>Application Number:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($application->application_number); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Loan Amount:</strong></td>
                        <td style="padding: 8px 0;">$<?php echo e(number_format($application->loan_amount, 2)); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Interest Rate:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e(number_format($application->interest_rate, 2)); ?>%</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Loan Term:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($application->loan_tenure); ?> months</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Monthly Payment:</strong></td>
                        <td style="padding: 8px 0;">$<?php echo e(number_format($application->installment_amount, 2)); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Payment Frequency:</strong></td>
                        <td style="padding: 8px 0; text-transform: capitalize;"><?php echo e($application->payment_frequency ?? 'monthly'); ?></td>
                    </tr>
                </table>
            </div>

            <div style="text-align: center;">
                <p><strong>Next Steps:</strong></p>
                <p>Our team will contact you shortly to complete the final documentation process and disburse your funds.</p>
                
                <a href="#" class="button">View Application Status</a>
            </div>

            <p>If you have any questions, please don't hesitate to contact our customer service team.</p>
            
            <p>Best regards,<br>
            <strong>IMMIA FINANCE LIMITED</strong><br>
            Customer Service Team</p>
        </div>
        
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>&copy; <?php echo e(date('Y')); ?> IMMIA FINANCE LIMITED. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/emails/loan-application-approved.blade.php ENDPATH**/ ?>