<?php
    // Define page variables
    $pageTitle = 'Loan Account Statement';
    $pageSubtitle = 'Detailed transaction history for loan: ' . $loan->loannumber;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | IMMIA FINANCE</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; /* ThemeBlue */
            --zedbank-blue-dark: #005A94; /* Darker shade for hover/active background */
        }

        /* Custom Tailwind-like classes */
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        /* Sidebar/Main Content Layout */
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        /* Local Overrides */
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        .bg-primary { background-color: var(--zedbank-blue); }
        
        /* Statement specific styles */
        .text-debit { color: #dc3545; }
        .text-credit { color: #28a745; }
        .bg-debit-light { background-color: #f8d7da; }
        .bg-credit-light { background-color: #d4edda; }
        
        /* Print styles */
        @media print {
            .no-print { display: none !important; }
            body { font-size: 11pt; }
            .print-section { break-inside: avoid; }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            
            <div class="mb-8">
                <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                    <div>
                        <div class="flex items-center mb-2">
                            <a href="<?php echo e(route('admin.loans.show', $loan->loanid)); ?>" 
                               class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark mr-3 transition">
                                <i class="fas fa-arrow-left mr-1"></i>
                                Back to Loan Details
                            </a>
                            <h1 class="text-2xl font-bold text-gray-800">Account Statement</h1>
                        </div>
                        <div class="text-sm text-gray-600">
                            <p>Loan: <strong><?php echo e($loan->loannumber); ?></strong> | 
                               Customer: <strong><?php echo e($loan->customer->first_name ?? ''); ?> <?php echo e($loan->customer->surname ?? ''); ?></strong></p>
                            <p>Period: <strong><?php echo e(\Carbon\Carbon::parse($startDate)->format('M d, Y')); ?></strong> to 
                               <strong><?php echo e(\Carbon\Carbon::parse($endDate)->format('M d, Y')); ?></strong></p>
                        </div>
                    </div>
                    
                    <div class="flex flex-wrap gap-2 no-print">
                        <button onclick="window.print()" 
                                class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition font-medium flex items-center">
                            <i class="fas fa-print mr-2"></i>
                            Print Statement
                        </button>
                        
                        <a href="<?php echo e(route('admin.loans.schedule', $loan->loanid)); ?>" 
                           class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition font-medium flex items-center">
                            <i class="fas fa-calendar-alt mr-2"></i>
                            View Schedule
                        </a>
                    </div>
                </div>
            </div>
            
            
            <div class="mb-6 bg-white rounded-lg shadow-sm border border-gray-200 p-4 no-print">
                <form method="GET" action="<?php echo e(route('admin.loans.loan-statement', $loan->loanid)); ?>" class="flex flex-col md:flex-row md:items-end gap-4">
                    <div class="flex-1 grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">From Date</label>
                            <input type="date" name="start_date" value="<?php echo e($startDate); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">To Date</label>
                            <input type="date" name="end_date" value="<?php echo e($endDate); ?>" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Quick Select</label>
                            <select id="quickPeriod" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="last_30_days">Last 30 Days</option>
                                <option value="last_90_days">Last 90 Days</option>
                                <option value="this_month">This Month</option>
                                <option value="last_month">Last Month</option>
                                <option value="this_quarter">This Quarter</option>
                                <option value="this_year">This Year</option>
                                <option value="all_time">All Time</option>
                                <option value="custom" selected>Custom Range</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="flex gap-2">
                        <button type="submit" 
                                class="px-6 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition font-medium">
                            Apply Filters
                        </button>
                        <a href="<?php echo e(route('admin.loans.loan-statement', $loan->loanid)); ?>" 
                           class="px-6 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 transition font-medium">
                            Reset
                        </a>
                    </div>
                </form>
            </div>
            
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Opening Balance</p>
                            <p class="text-lg font-bold text-gray-800">K <?php echo e(number_format($openingBalance, 2)); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-wallet text-gray-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Total Credits</p>
                            <p class="text-lg font-bold text-credit">K <?php echo e(number_format($totalCredits, 2)); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-credit-light rounded-lg flex items-center justify-center">
                            <i class="fas fa-arrow-down text-credit"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Total Debits</p>
                            <p class="text-lg font-bold text-debit">K <?php echo e(number_format($totalDebits, 2)); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-debit-light rounded-lg flex items-center justify-center">
                            <i class="fas fa-arrow-up text-debit"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Closing Balance</p>
                            <p class="text-lg font-bold text-blue-600">K <?php echo e(number_format($closingBalance, 2)); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-balance-scale text-blue-600"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden mb-6 print-section">
                <div class="border-b border-gray-200 px-6 py-4">
                    <h2 class="text-xl font-semibold text-gray-800">Transaction History</h2>
                    <p class="text-sm text-gray-600 mt-1"><?php echo e($transactions->count()); ?> transactions in selected period</p>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Debit (K)</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Credit (K)</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance (K)</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php
                                $runningBalance = $openingBalance;
                            ?>
                            
                            <tr class="bg-gray-50">
                                <td class="px-4 py-3 text-sm text-gray-900"><?php echo e(\Carbon\Carbon::parse($startDate)->format('M d, Y')); ?></td>
                                <td class="px-4 py-3 text-sm text-gray-900 font-medium">Opening Balance</td>
                                <td class="px-4 py-3 text-sm text-gray-900">-</td>
                                <td class="px-4 py-3 text-sm text-gray-900">Balance B/F</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">-</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">-</td>
                                <td class="px-4 py-3 text-sm font-bold text-gray-900 text-right">K <?php echo e(number_format($runningBalance, 2)); ?></td>
                            </tr>
                            
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $debit = $transaction['type'] === 'debit' ? $transaction['amount'] : 0;
                                    $credit = $transaction['type'] === 'credit' ? $transaction['amount'] : 0;
                                    $runningBalance += $credit - $debit;
                                ?>
                                <tr>
                                    <td class="px-4 py-3 text-sm text-gray-900">
                                        <?php echo e(\Carbon\Carbon::parse($transaction['date'])->format('M d, Y')); ?>

                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-900">
                                        <?php echo e($transaction['description']); ?>

                                        <?php if($transaction['transaction_type'] === 'repayment'): ?>
                                            <div class="text-xs text-gray-500 mt-1">
                                                Principal: K <?php echo e(number_format($transaction['principal'], 2)); ?>

                                                | Interest: K <?php echo e(number_format($transaction['interest'], 2)); ?>

                                                <?php if($transaction['penalty'] > 0): ?>
                                                    | Penalty: K <?php echo e(number_format($transaction['penalty'], 2)); ?>

                                                <?php endif; ?>
                                                <?php if($transaction['processing_fee'] > 0): ?>
                                                    | Fee: K <?php echo e(number_format($transaction['processing_fee'], 2)); ?>

                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-900">
                                        <?php echo e($transaction['reference']); ?>

                                    </td>
                                    <td class="px-4 py-3">
                                        <?php
                                            $badgeClasses = [
                                                'repayment' => 'bg-green-100 text-green-800',
                                                'interest' => 'bg-yellow-100 text-yellow-800',
                                                'fee' => 'bg-purple-100 text-purple-800',
                                                'disbursement' => 'bg-blue-100 text-blue-800',
                                                'default' => 'bg-gray-100 text-gray-800',
                                            ];
                                            
                                            $badgeClass = $badgeClasses[$transaction['transaction_type']] ?? $badgeClasses['default'];
                                        ?>
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium <?php echo e($badgeClass); ?>">
                                            <?php echo e(ucfirst($transaction['transaction_type'])); ?>

                                        </span>
                                    </td>
                                    <td class="px-4 py-3 text-sm font-medium text-right <?php echo e($debit > 0 ? 'text-debit' : 'text-gray-500'); ?>">
                                        <?php if($debit > 0): ?>
                                            K <?php echo e(number_format($debit, 2)); ?>

                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-sm font-medium text-right <?php echo e($credit > 0 ? 'text-credit' : 'text-gray-500'); ?>">
                                        <?php if($credit > 0): ?>
                                            K <?php echo e(number_format($credit, 2)); ?>

                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-sm font-bold text-gray-900 text-right">
                                        K <?php echo e(number_format($runningBalance, 2)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            <tr class="bg-gray-100">
                                <td class="px-4 py-3 text-sm text-gray-900 font-medium"><?php echo e(\Carbon\Carbon::parse($endDate)->format('M d, Y')); ?></td>
                                <td class="px-4 py-3 text-sm text-gray-900 font-medium">Closing Balance</td>
                                <td class="px-4 py-3 text-sm text-gray-900">-</td>
                                <td class="px-4 py-3 text-sm text-gray-900">Balance C/F</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">-</td>
                                <td class="px-4 py-3 text-sm text-gray-900 text-right">-</td>
                                <td class="px-4 py-3 text-sm font-bold text-gray-900 text-right">K <?php echo e(number_format($runningBalance, 2)); ?></td>
                            </tr>
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td colspan="4" class="px-4 py-3 text-sm font-medium text-gray-900 text-right">
                                    Totals:
                                </td>
                                <td class="px-4 py-3 text-sm font-bold text-debit text-right">
                                    K <?php echo e(number_format($totalDebits, 2)); ?>

                                </td>
                                <td class="px-4 py-3 text-sm font-bold text-credit text-right">
                                    K <?php echo e(number_format($totalCredits, 2)); ?>

                                </td>
                                <td class="px-4 py-3 text-sm font-bold text-gray-900 text-right">
                                    Net: K <?php echo e(number_format($totalCredits - $totalDebits, 2)); ?>

                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 print-section">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Loan Details</h3>
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Loan Number:</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($loan->loannumber); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Customer:</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($loan->customer->first_name ?? ''); ?> <?php echo e($loan->customer->surname ?? ''); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Original Amount:</span>
                            <span class="text-sm font-medium text-gray-900">K <?php echo e(number_format($loan->amount, 2)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Disbursement Date:</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($loan->disburseddate ? \Carbon\Carbon::parse($loan->disburseddate)->format('M d, Y') : 'N/A'); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Interest Rate:</span>
                            <span class="text-sm font-medium text-gray-900"><?php echo e(number_format($loan->interestrate, 2)); ?>%</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Current Status:</span>
                            <?php
                                $statusBadgeClass = '';
                                if ($loan->status === 'active') $statusBadgeClass = 'bg-green-100 text-green-800';
                                elseif ($loan->status === 'closed') $statusBadgeClass = 'bg-gray-100 text-gray-800';
                                elseif ($loan->status === 'default') $statusBadgeClass = 'bg-red-100 text-red-800';
                                else $statusBadgeClass = 'bg-blue-100 text-blue-800';
                            ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($statusBadgeClass); ?>">
                                <?php echo e(ucfirst($loan->status)); ?>

                            </span>
                        </div>
                    </div>
                </div>
                
                
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 print-section">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Payment Summary</h3>
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Total Principal Paid:</span>
                            <span class="text-sm font-medium text-green-600">K <?php echo e(number_format($loan->totalprincipalpaid, 2)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Total Interest Paid:</span>
                            <span class="text-sm font-medium text-green-600">K <?php echo e(number_format($loan->totalinterestpaid, 2)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Total Penalty Paid:</span>
                            <span class="text-sm font-medium text-green-600">K <?php echo e(number_format($loan->totalpenaltypaid, 2)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Total Paid to Date:</span>
                            <span class="text-sm font-bold text-green-600">K <?php echo e(number_format($loan->totalpaid, 2)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Current Outstanding:</span>
                            <span class="text-sm font-bold text-red-600">K <?php echo e(number_format($loan->totalbalance, 2)); ?></span>
                        </div>
                        <div class="pt-3 border-t border-gray-200">
                            <div class="flex justify-between">
                                <span class="text-sm font-medium text-gray-700">Payment Consistency:</span>
                                <span class="text-sm font-bold <?php echo e($paymentConsistency > 80 ? 'text-green-600' : ($paymentConsistency > 60 ? 'text-yellow-600' : 'text-red-600')); ?>">
                                    <?php echo e(number_format($paymentConsistency, 1)); ?>%
                                </span>
                            </div>
                            <div class="w-full bg-gray-200 rounded-full h-2 mt-2">
                                <div class="h-2 rounded-full <?php echo e($paymentConsistency > 80 ? 'bg-green-600' : ($paymentConsistency > 60 ? 'bg-yellow-600' : 'bg-red-600')); ?>" 
                                     style="width: <?php echo e($paymentConsistency); ?>%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            <div class="mt-8 pt-6 border-t border-gray-200 text-center text-sm text-gray-500 print-section">
                <p>This is a computer-generated statement. No signature required.</p>
                <p class="mt-1">Generated on: <?php echo e(now()->format('F d, Y \a\t H:i:s')); ?></p>
                <p class="mt-1">IMMIA FINANCE LTD</p>
            </div>
        </main>
    </div>

    <script>
        // Quick period selection
        document.getElementById('quickPeriod').addEventListener('change', function() {
            const today = new Date();
            const startDate = new Date();
            const endDate = today.toISOString().split('T')[0];
            
            switch(this.value) {
                case 'last_30_days':
                    startDate.setDate(today.getDate() - 30);
                    break;
                case 'last_90_days':
                    startDate.setDate(today.getDate() - 90);
                    break;
                case 'this_month':
                    startDate.setDate(1);
                    break;
                case 'last_month':
                    startDate.setMonth(today.getMonth() - 1);
                    startDate.setDate(1);
                    document.querySelector('input[name="end_date"]').value = new Date(today.getFullYear(), today.getMonth(), 0).toISOString().split('T')[0];
                    break;
                case 'this_quarter':
                    const quarter = Math.floor(today.getMonth() / 3);
                    startDate.setMonth(quarter * 3);
                    startDate.setDate(1);
                    break;
                case 'this_year':
                    startDate.setMonth(0);
                    startDate.setDate(1);
                    break;
                case 'all_time':
                    startDate.setFullYear(2020, 0, 1); // From 2020
                    break;
                case 'custom':
                    return;
            }
            
            if (this.value !== 'custom') {
                document.querySelector('input[name="start_date"]').value = startDate.toISOString().split('T')[0];
                if (this.value !== 'last_month') {
                    document.querySelector('input[name="end_date"]').value = endDate;
                }
            }
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/loans/statement.blade.php ENDPATH**/ ?>