<?php
    $pageTitle = 'Manage Quotations';
    $pageSubtitle = 'Track and manage loan estimates';

    // Stats for sidebar consistency - counting both drafts and active as pending until 'complete'
    $stats_sidebar = [
        'pending_quotations' => $quotations->whereIn('status', ['draft', 'active'])->count() ?? 0, 
    ];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
        }

        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        /* Sidebar/Main Content Layout */
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        /* Local Overrides */
        .focus\:ring-zedbank-blue:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-zedbank-blue:focus { border-color: var(--zedbank-blue); }
        
        .action-btn { width: 30px; height: 30px; border-radius: 4px; display: inline-flex; align-items: center; justify-content: center; margin: 0 1px; transition: all 0.2s; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    
    <?php echo $__env->make('accounting.partials.sidebar', ['stats' => $stats_sidebar], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                    <div class="w-full md:w-auto">
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-search text-gray-400"></i>
                            </div>
                            <input 
                                type="text" 
                                id="searchInput" 
                                class="block w-full md:w-80 pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue focus:ring-1 text-sm" 
                                placeholder="Search by reference, customer..."
                            >
                        </div>
                    </div>
                    <div class="flex flex-wrap gap-2 w-full md:w-auto">
                        <a href="<?php echo e(route('admin.quotations.create')); ?>" class="px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition flex items-center gap-2 text-sm font-semibold shadow-sm">
                            <i class="fas fa-plus text-xs"></i>
                            <span>New Quotation</span>
                        </a>
                        <button class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2 text-sm">
                            <i class="fas fa-download text-gray-400"></i>
                            <span>Export</span>
                        </button>
                    </div>
                </div>
            </div>
            
            
            <div class="overflow-x-auto bg-white shadow-sm rounded-lg border border-gray-200">
                <table class="min-w-full text-sm" id="dataTable">
                    <thead class="bg-gray-50 border-b border-gray-200">
                        <tr>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Reference No</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Customer</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Principal</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Repayment</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Tenure</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Status</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Created At</th>
                            <th class="px-4 py-3 text-center text-gray-600 font-medium whitespace-nowrap uppercase text-[11px]">Actions</th>
                        </tr>
                    </thead>

                    <tbody class="divide-y divide-gray-100">
                        <?php $__empty_1 = true; $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50/50 transition">
                                <td class="px-4 py-3 text-zedbank-blue font-bold font-mono"><?php echo e($quote->quotation_number); ?></td>
                                <td class="px-4 py-3 text-gray-700 font-medium"><?php echo e($quote->customer_name); ?></td>
                                <td class="px-4 py-3 text-gray-900 font-bold">ZMW <?php echo e(number_format($quote->principal_amount, 2)); ?></td>
                                <td class="px-4 py-3 text-gray-700">ZMW <?php echo e(number_format($quote->monthly_installment ?? 0, 2)); ?></td>
                                <td class="px-4 py-3 text-gray-600">
                                    <?php echo e($quote->tenure); ?> <span class="capitalize"><?php echo e(str_replace('_', ' ', $quote->tenure_type)); ?>s</span>
                                </td>
                                <td class="px-4 py-3">
                                    <?php if($quote->status === 'draft'): ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-bold bg-gray-100 text-gray-600 uppercase border border-gray-200">
                                            Draft
                                        </span>
                                    <?php elseif($quote->status === 'complete'): ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-bold bg-blue-100 text-blue-700 uppercase border border-blue-200">
                                            Complete
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-bold bg-green-100 text-green-700 uppercase border border-green-200">
                                            Active
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-gray-500">
                                    <?php echo e($quote->created_at->format('M d, Y')); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-center">
                                    <div class="flex space-x-1 justify-center">
                                        
                                        <a href="<?php echo e(route('admin.quotations.show', $quote->id)); ?>" 
                                           class="action-btn bg-gray-100 text-zedbank-blue hover:bg-zedbank-blue-dark hover:text-white" 
                                           title="View Full Schedule">
                                            <i class="fas fa-eye text-xs"></i>
                                        </a>

                                        
                                        <a href="<?php echo e(route('admin.quotations.edit', $quote->id)); ?>" 
                                           class="action-btn bg-green-50 text-green-600 hover:bg-green-800 hover:text-white" 
                                           title="Edit/Modify">
                                            <i class="fas fa-edit text-xs"></i>
                                        </a>

                                        
                                        <a href="<?php echo e(route('admin.quotations.download', $quote->id)); ?>" 
                                           class="action-btn bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white" 
                                           title="Download PDF">
                                            <i class="fas fa-file-pdf text-xs"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="px-4 py-16 text-center text-gray-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <i class="fas fa-calculator text-5xl text-gray-200 mb-4"></i>
                                        <p class="text-lg font-medium text-gray-400">No quotations found</p>
                                        <p class="text-sm text-gray-400">Generate a new loan estimate to see it listed here.</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            
            <div class="mt-6 flex flex-col md:flex-row justify-between items-center gap-4">
                <div class="text-sm text-gray-500">
                    Showing <span class="font-medium text-gray-800"><?php echo e($quotations->firstItem() ?? 0); ?></span> to 
                    <span class="font-medium text-gray-800"><?php echo e($quotations->lastItem() ?? 0); ?></span> of 
                    <span class="font-medium text-gray-800"><?php echo e($quotations->total()); ?></span> entries
                </div>
                <div>
                    <?php echo e($quotations->links()); ?>

                </div>
            </div>
        </main>
    </div>

    <script>
        // Real-time Search functionality
        document.getElementById('searchInput')?.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('#dataTable tbody tr');
            
            rows.forEach(row => {
                const rowText = row.textContent.toLowerCase();
                if (row.cells.length > 1) { 
                    row.style.display = rowText.includes(searchTerm) ? '' : 'none';
                }
            });
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/quotations/index.blade.php ENDPATH**/ ?>