
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Due Reminder</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #0066cc;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 1px solid #eee;
            padding-bottom: 20px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 15px;
        }
        .title {
            color: #0066cc;
            font-size: 24px;
            font-weight: bold;
            margin: 0 0 10px 0;
        }
        .subtitle {
            color: #666;
            font-size: 16px;
            margin: 0;
        }
        .reminder-box {
            background-color: #e8f4fd;
            border: 1px solid #b6d4fe;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .reminder-icon {
            font-size: 48px;
            color: #0066cc;
            margin-bottom: 15px;
        }
        .reminder-text {
            font-size: 18px;
            color: #0066cc;
            font-weight: bold;
            margin: 0;
        }
        .days-remaining {
            display: inline-block;
            background-color: #0066cc;
            color: white;
            padding: 6px 15px;
            border-radius: 20px;
            font-weight: bold;
            margin: 10px 0;
        }
        .details-box {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            font-weight: 600;
            color: #495057;
        }
        .detail-value {
            color: #212529;
            font-weight: 500;
        }
        .amount-highlight {
            color: #0066cc;
            font-size: 20px;
            font-weight: bold;
        }
        .action-box {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .action-title {
            color: #0066cc;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 15px;
        }
        .payment-methods {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
            flex-wrap: wrap;
        }
        .method {
            background-color: white;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            width: 180px;
            text-align: center;
        }
        .method-icon {
            font-size: 24px;
            color: #0066cc;
            margin-bottom: 10px;
        }
        .method-title {
            font-weight: bold;
            margin-bottom: 5px;
        }
        .method-details {
            font-size: 14px;
            color: #666;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 14px;
        }
        .info-note {
            background-color: #e8f4fd;
            border: 1px solid #b6d4fe;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            color: #0066cc;
            font-size: 14px;
        }
        .contact-info {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            font-size: 14px;
        }
        .cta-button {
            display: inline-block;
            background-color: #0066cc;
            color: white;
            text-decoration: none;
            padding: 12px 30px;
            border-radius: 6px;
            font-weight: bold;
            font-size: 16px;
            margin: 10px 0;
            transition: background-color 0.3s;
        }
        .cta-button:hover {
            background-color: #0056b3;
        }
        .penalty-warning {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            color: #856404;
            font-size: 14px;
        }
        @media (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .detail-row {
                flex-direction: column;
            }
            .payment-methods {
                flex-direction: column;
                align-items: center;
            }
            .method {
                width: 100%;
                max-width: 250px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="title">PAYMENT DUE REMINDER</div>
            <div class="subtitle">IMMIA FINANCE - Loan Account Notification</div>
        </div>

        <div class="reminder-box">
            <div class="reminder-icon">⏰</div>
            <div class="reminder-text">FRIENDLY REMINDER</div>
            <div class="days-remaining">
                <?php
                    $daysUntilDue = \Carbon\Carbon::today()->diffInDays($schedule->paymentdate, false);
                    echo $daysUntilDue > 0 ? "$daysUntilDue DAYS UNTIL DUE" : "DUE TODAY";
                ?>
            </div>
        </div>

        <p>Dear <strong><?php echo e($customer->first_name); ?> <?php echo e($customer->surname); ?></strong>,</p>
        
        <p>This is a friendly reminder that your upcoming payment for loan <strong>#<?php echo e($schedule->loannumber); ?></strong> is due soon.</p>

        <div class="details-box">
            <h3 style="color: #0066cc; margin-top: 0;">Payment Details</h3>
            
            <div class="detail-row">
                <span class="detail-label">Loan Account Number:</span>
                <span class="detail-value"><?php echo e($schedule->loannumber); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Customer Reference:</span>
                <span class="detail-value"><?php echo e($customer->customer_number); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Installment Number:</span>
                <span class="detail-value">#<?php echo e($schedule->installment_number); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Due Date:</span>
                <span class="detail-value"><?php echo e(\Carbon\Carbon::parse($schedule->paymentdate)->format('F d, Y')); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Amount Due:</span>
                <span class="detail-value amount-highlight">ZMW <?php echo e(number_format($dueAmount, 2)); ?></span>
            </div>
            
            <?php if($loan): ?>
            <div class="detail-row">
                <span class="detail-label">Current Loan Balance:</span>
                <span class="detail-value">ZMW <?php echo e(number_format($loan->totalbalance, 2)); ?></span>
            </div>
            <?php endif; ?>
        </div>

        <div class="penalty-warning">
            <strong>⚠️ AVOID LATE PAYMENTS:</strong> Making your payment on time helps you:
            <ul style="margin: 10px 0 0 20px; padding: 0;">
                <li>Maintain a good credit score</li>
                <li>Avoid late payment penalties</li>
                <li>Build trust for future loan facilities</li>
                <li>Stay in good standing with IMMIA Finance</li>
            </ul>
        </div>

        <div class="action-box">
            <div class="action-title">CONVENIENT PAYMENT OPTIONS</div>
            
            <div class="payment-methods">
                <div class="method">
                    <div class="method-icon">🏦</div>
                    <div class="method-title">Bank Transfer</div>
                    <div class="method-details">
                        <div>Account: IMMIA FINANCE LTD</div>
                        <div>Bank: Standard Chartered</div>
                        <div>Acc No: 0100 1234 5678</div>
                        <div>Reference: <?php echo e($schedule->loannumber); ?></div>
                    </div>
                </div>
                
                <div class="method">
                    <div class="method-icon">📱</div>
                    <div class="method-title">Mobile Money</div>
                    <div class="method-details">
                        <div>Airtel Money: *123*<?php echo e($schedule->loannumber); ?>#</div>
                        <div>MTN Mobile Money: *126*<?php echo e($schedule->loannumber); ?>#</div>
                        <div>Reference: <?php echo e($schedule->loannumber); ?></div>
                    </div>
                </div>
                
                <div class="method">
                    <div class="method-icon">🏢</div>
                    <div class="method-title">Branch Payment</div>
                    <div class="method-details">
                        <div>Visit any IMMIA branch</div>
                        <div>Bring this notification</div>
                        <div>Business Hours: 8AM-5PM</div>
                    </div>
                </div>
            </div>
            
            <a href="#" class="cta-button">PAY NOW</a>
        </div>

        <div class="info-note">
            <strong>💡 TIP:</strong> Consider setting up automatic payments to ensure you never miss a due date. Contact our customer service for assistance with auto-pay setup.
        </div>


        <div class="footer">
            <p>This is an automated reminder from IMMIA FINANCE LTD. Please do not reply to this email.</p>
            <p>If you have already made this payment, please disregard this notice and accept our thanks.</p>
            <p style="font-size: 12px; color: #999; margin-top: 20px;">
                CONFIDENTIALITY NOTICE: This email and any attachments are confidential and intended solely for the addressee. 
                If you are not the intended recipient, please notify us immediately and delete this email.
            </p>
            <p style="font-size: 12px; color: #999;">
                © <?php echo e(date('Y')); ?> IMMIA FINANCE LTD. All rights reserved. Registered under the Banking and Financial Services Act.
            </p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/emails/payment_due_reminder.blade.php ENDPATH**/ ?>