<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Loan Quotation - <?php echo e($quotation->quotation_number); ?></title>
    <style>
        body { font-family: helvetica, sans-serif; color: #333; line-height: 1.2; }
        .header-table { width: 100%; border-bottom: 2px solid #0077C5; padding-bottom: 10px; }
        .title { color: #0077C5; font-size: 20pt; font-weight: bold; text-transform: uppercase; }
        .company-name { font-size: 12pt; font-weight: bold; text-align: right; }
        
        .section-title { 
            background-color: #F3F4F6; 
            padding: 5px 10px; 
            font-size: 9pt; 
            font-weight: bold; 
            color: #374151; 
            margin-top: 15px;
            text-transform: uppercase;
        }

        .details-table { width: 100%; margin-top: 5px; margin-bottom: 10px; }
        .label { color: #6B7280; font-size: 8pt; text-transform: uppercase; }
        .value { font-size: 10pt; font-weight: bold; color: #111827; }

        .schedule-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .schedule-table th { 
            background-color: #0077C5; 
            color: white; 
            font-weight: bold; 
            text-transform: uppercase; 
            font-size: 7.5pt; 
            padding: 8px; 
            text-align: left;
        }
        .schedule-table td { 
            border-bottom: 1px solid #EEE; 
            padding: 6px; 
            font-size: 8pt; 
        }
        .text-right { text-align: right; }
        .text-blue { color: #0077C5; font-weight: bold; }
        
        /* Updated Summary Box with Border Lines */
        .summary-box { 
            margin-top: 20px; 
            padding: 10px 0;
        }
        .border-top { border-top: 1px solid #333; }
        .border-bottom { border-bottom: 1px solid #333; }
        .footer-line { border-top: 1px solid #0077C5; border-bottom: 1px solid #0077C5; padding: 10px 0; margin-top: 20px; }

        .footer { 
            text-align: center; 
            font-size: 7pt; 
            color: #999; 
            margin-top: 25px; 
            padding-top: 8px;
        }
    </style>
</head>
<body>

    <table class="header-table">
        <tr>
            <td width="60%">
                <span class="title">Loan Quotation</span><br>
                <span style="font-size: 9pt; color: #666;">Reference: <b><?php echo e($quotation->quotation_number); ?></b></span>
            </td>
            <td width="40%" class="company-name">
                ZEDBANKOS PORTAL<br>
                <span style="font-size: 8pt; font-weight: normal; color: #666;">Date: <?php echo e(now()->format('d M, Y')); ?></span>
            </td>
        </tr>
    </table>

    <div class="section-title">Client & Product Information</div>
    <table class="details-table" cellpadding="4">
        <tr>
            <td width="50%">
                <span class="label">Customer Name</span><br>
                <span class="value"><?php echo e($quotation->customer_name); ?></span>
            </td>
            <td width="50%">
                <span class="label">Loan Product</span><br>
                <span class="value"><?php echo e($quotation->product->product ?? 'Standard Loan'); ?></span>
            </td>
        </tr>
    </table>

    <div class="section-title">Loan Parameters & Rates</div>
    <table class="details-table" cellpadding="4">
        <tr>
            <td width="20%">
                <span class="label">Principal</span><br>
                <span class="value">ZMW <?php echo e(number_format($quotation->principal_amount, 2)); ?></span>
            </td>
            <td width="20%">
                <span class="label">Int. Rate</span><br>
                <span class="value"><?php echo e(number_format($quotation->effective_interest_rate, 2)); ?>%</span>
            </td>
            <td width="20%">
                <span class="label">Proc. Rate</span><br>
                <span class="value"><?php echo e(number_format($quotation->effective_processing_rate, 2)); ?>%</span>
            </td>
            <td width="20%">
                <span class="label">Tenure</span><br>
                <span class="value"><?php echo e($quotation->tenure); ?> <?php echo e(ucfirst($quotation->tenure_type)); ?>s</span>
            </td>
            <td width="20%">
                <span class="label">Method</span><br>
                <span class="value" style="font-size: 7.5pt;"><?php echo e(str_replace('_', ' ', ucfirst($quotation->interest_method))); ?></span>
            </td>
        </tr>
    </table>

    <div class="section-title">Amortization Schedule (Month-End)</div>
    <table class="schedule-table" cellpadding="5">
        <thead>
            <tr>
                <th width="7%">#</th>
                <th width="18%">Due Date</th>
                <th width="19%">Installment</th>
                <th width="14%">Principal</th>
                <th width="14%">Interest</th>
                <th width="14%">Proc. Fee</th>
                <th width="14%" class="text-right">Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $scheduleData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($row['period']); ?></td>
                <td><?php echo e($row['date']); ?></td>
                <td><b>ZMW <?php echo e(number_format($row['installment'], 2)); ?></b></td>
                <td><?php echo e(number_format($row['principal'], 2)); ?></td>
                <td><?php echo e(number_format($row['interest'], 2)); ?></td>
                <td><?php echo e(number_format($row['processing_fee'], 2)); ?></td>
                <td class="text-right text-blue"><?php echo e(number_format($row['balance'], 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="summary-box">
        <table width="100%" cellpadding="3">
            <tr>
                <td width="65%" style="font-size: 9pt;">Loan Principal Amount:</td>
                <td width="35%" class="text-right" style="font-size: 9pt;">ZMW <?php echo e(number_format($quotation->principal_amount, 2)); ?></td>
            </tr>
            <tr>
                <td width="65%" style="font-size: 9pt;">Admin Fee (<?php echo e(number_format($quotation->admin_rate, 2)); ?>% Upfront):</td>
                <td width="35%" class="text-right" style="font-size: 9pt; color: #DC2626;">- ZMW <?php echo e(number_format($summary['admin_fee_upfront'], 2)); ?></td>
            </tr>
            <tr>
                <td width="65%" style="font-size: 9pt;">Insurance Fee (<?php echo e(number_format($quotation->insurance_rate, 2)); ?>% Upfront):</td>
                <td width="35%" class="text-right" style="font-size: 9pt; color: #DC2626;">- ZMW <?php echo e(number_format($summary['insurance_fee_upfront'], 2)); ?></td>
            </tr>
            
            <tr>
                <td colspan="2" style="border-top: 1px solid #333; height: 1px; padding: 0; margin: 5px 0;"></td>
            </tr>
            <tr>
                <td width="65%" style="font-size: 10pt; font-weight: bold;">NET DISBURSEMENT (What you receive):</td>
                <td width="35%" class="text-right" style="font-size: 11pt; font-weight: bold; color: #059669;">ZMW <?php echo e(number_format($summary['net_disbursement'], 2)); ?></td>
            </tr>
            
            <tr>
                <td colspan="2" style="border-bottom: 1px solid #333; height: 1px; padding: 0; margin: 5px 0;"></td>
            </tr>
            
            <tr><td colspan="2" style="height: 10px;"></td></tr>
            
            <tr>
                <td width="65%" style="font-size: 9pt;">Total Interest Paid over tenure:</td>
                <td width="35%" class="text-right" style="font-size: 9pt;">ZMW <?php echo e(number_format($summary['total_interest'], 2)); ?></td>
            </tr>
            <tr>
                <td width="65%" style="font-size: 9pt;">Total Processing Fees Paid over tenure:</td>
                <td width="35%" class="text-right" style="font-size: 9pt;">ZMW <?php echo e(number_format($summary['total_processing_fee'], 2)); ?></td>
            </tr>
            
            
            <tr style="border-top: 2px solid #0077C5;">
                <td width="65%" style="font-size: 10pt; font-weight: bold; color: #0077C5; padding-top: 8px;">TOTAL REPAYABLE AMOUNT:</td>
                <td width="35%" class="text-right" style="font-size: 12pt; font-weight: bold; color: #0077C5; padding-top: 8px;">ZMW <?php echo e(number_format($summary['total_repayable'], 2)); ?></td>
            </tr>
        </table>
    </div>

    <div class="footer footer-line">
        Generated by ZedBankOS on <?php echo e(now()->format('d M, Y H:i')); ?>.<br>
        This quotation is an estimate. Fees amortized within installments are included in the schedule above.
    </div>

</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/quotations/pdf_template.blade.php ENDPATH**/ ?>