<?php
    $pageTitle = 'Quotation Schedule';
    $pageSubtitle = 'Amortization schedule for ' . $quotation->quotation_number;
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
    $feeApplicable = ($quotation->effective_processing_rate > 0);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --zedbank-blue: <?php echo e($themeBlue); ?>; --zedbank-blue-dark: <?php echo e($themeBlueDark); ?>; }
        .bg-primary { background-color: var(--zedbank-blue); }
        .bg-primary-dark { background-color: var(--zedbank-blue-dark); }
        .text-primary { color: var(--zedbank-blue); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        
        .schedule-table th { 
            background-color: #F9FAFB; 
            color: #4B5563; 
            font-weight: 700; 
            text-transform: uppercase; 
            font-size: 11px;
            letter-spacing: 0.05em;
            border-bottom: 2px solid #E5E7EB; 
        }
        .summary-card { background-color: #FFFFFF; border: 1px solid #E5E7EB; border-radius: 12px; padding: 24px; box-shadow: 0 1px 2px rgba(0,0,0,0.05); }
        .term-badge { display: inline-flex; align-items: center; padding: 4px 10px; border-radius: 9999px; font-weight: 700; font-size: 10px; text-transform: uppercase; }

        @media print { 
            .print-hide { display: none !important; } 
            .lg\:ml-64 { margin-left: 0 !important; }
            .bg-gray-50 { background-color: white !important; }
            .summary-card { border: 1px solid #eee !important; box-shadow: none !important; }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen text-gray-900">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen flex flex-col">
        <?php echo $__env->make('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                
                <div class="flex justify-between items-center mb-6 print-hide">
                    <a href="<?php echo e(route('admin.quotations.index')); ?>" class="inline-flex items-center text-sm font-semibold text-gray-600 hover:text-primary transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Quotations
                    </a>
                    <div class="flex gap-3">
                        <a href="<?php echo e(route('admin.quotations.edit', $quotation->id)); ?>" class="px-4 py-2 bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition text-sm font-semibold flex items-center gap-2">
                            <i class="fas fa-edit text-orange-500"></i> Back to Builder
                        </a>
                        
                       <a href="<?php echo e(route('admin.quotations.download', $quotation->id)); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition text-sm font-semibold flex items-center gap-2 shadow-sm">
                           <i class="fas fa-file-pdf"></i> Download PDF
                        </a>
                    </div>
                </div>

                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                    <div class="summary-card">
                        <div class="text-[10px] font-bold text-gray-400 mb-2 uppercase tracking-widest text-primary">Prospect Detail</div>
                        <h4 class="text-xl font-extrabold text-gray-800"><?php echo e($quotation->customer_name); ?></h4>
                        <p class="text-sm font-mono text-gray-500"><?php echo e($quotation->quotation_number); ?></p>
                    </div>

                    <div class="summary-card">
                        <div class="text-[10px] font-bold text-gray-400 mb-2 uppercase tracking-widest text-primary">Repayment Setup</div>
                        <h4 class="text-xl font-extrabold text-gray-900">
                            ZMW <?php echo e(number_format($scheduleData[0]['installment'] ?? 0, 2)); ?> 
                            <span class="text-sm font-medium text-gray-400">/ Periodic</span>
                        </h4>
                        <p class="text-sm text-gray-600 font-semibold"><?php echo e($quotation->tenure); ?> Payments (<?php echo e(ucfirst($quotation->tenure_type)); ?>)</p>
                    </div>

                    <div class="summary-card">
                        <div class="text-[10px] font-bold text-gray-400 mb-2 uppercase tracking-widest text-primary">Financial Summary</div>
                        <h4 class="text-xl font-extrabold text-primary">ZMW <?php echo e(number_format($summary['total_repayable'] ?? 0, 2)); ?></h4>
                        <p class="text-xs text-gray-500 italic font-medium">Net Disbursement: ZMW <?php echo e(number_format($summary['net_disbursement'] ?? 0, 2)); ?></p>
                    </div>
                </div>

                
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="p-5 bg-gray-50/50 border-b border-gray-200 flex justify-between items-center">
                        <div>
                            <h4 class="text-lg font-bold text-gray-800">Repayment Schedule</h4>
                            <p class="text-xs text-gray-500 italic">Installments occur at the <strong>end of each month</strong>.</p>
                        </div>
                        <span class="text-xs font-bold text-gray-400 uppercase">Projection from <?php echo e(now()->format('d M, Y')); ?></span>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="w-full text-left text-sm schedule-table">
                            <thead>
                                <tr>
                                    <th class="px-6 py-4">Inst.</th>
                                    <th class="px-6 py-4">Due Date</th>
                                    <th class="px-6 py-4">Periodic Installment</th>
                                    <th class="px-6 py-4">Principal</th>
                                    <th class="px-6 py-4">Interest</th>
                                    <?php if($feeApplicable): ?> <th class="px-6 py-4">Processing Fee</th> <?php endif; ?>
                                    <th class="px-6 py-4 text-right">Balance</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                <?php $__currentLoopData = $scheduleData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-blue-50/30 transition-colors">
                                        <td class="px-6 py-4 text-gray-400 font-bold font-mono">#<?php echo e($row['period']); ?></td>
                                        <td class="px-6 py-4 font-semibold text-gray-900">
                                            <i class="far fa-calendar-alt mr-2 text-primary opacity-40"></i>
                                            <?php echo e($row['date']); ?>

                                        </td>
                                        <td class="px-6 py-4 font-black text-gray-900">ZMW <?php echo e(number_format($row['installment'], 2)); ?></td>
                                        <td class="px-6 py-4 text-gray-700">ZMW <?php echo e(number_format($row['principal'], 2)); ?></td>
                                        <td class="px-6 py-4 text-red-600 font-bold">ZMW <?php echo e(number_format($row['interest'], 2)); ?></td>
                                        <?php if($feeApplicable): ?> 
                                            <td class="px-6 py-4 text-orange-600 font-semibold">ZMW <?php echo e(number_format($row['processing_fee'], 2)); ?></td> 
                                        <?php endif; ?>
                                        <td class="px-6 py-4 text-right font-bold text-primary font-mono">ZMW <?php echo e(number_format($row['balance'], 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="p-6 bg-gray-50 border-t border-gray-200">
                        <div class="flex flex-wrap gap-8 justify-end">
                            <div class="text-right">
                                <span class="text-[10px] font-bold text-gray-400 uppercase block mb-1">Total Interest Earned</span>
                                <span class="text-xl font-black text-gray-800">ZMW <?php echo e(number_format($summary['total_interest'] ?? 0, 2)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="mt-8 text-center">
                    <p class="text-[11px] text-gray-400 leading-relaxed uppercase tracking-widest font-bold">
                        Generated by ZedBankOS Amortization Engine. This quotation is valid for 30 days.
                    </p>
                </div>
            </div>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/quotations/show.blade.php ENDPATH**/ ?>