<style>
.rotate-180 {
    transform: rotate(180deg);
}
/* Define the custom theme color: #0077C5 (ThemeBlue) */
:root {
    --zedbank-blue: #0077C5;
    --zedbank-blue-dark: #005A94; /* Darker shade for hover/active background */
    --zedbank-blue-medium: #005A94; /* Deeper color for active link background */
}

/* Custom Tailwind-like classes for the theme color */
.bg-zedbank-blue { background-color: var(--zedbank-blue); }
.bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
.bg-zedbank-blue-medium { background-color: var(--zedbank-blue-medium); }
.text-zedbank-blue { color: var(--zedbank-blue); }
.border-zedbank-blue-dark { border-color: var(--zedbank-blue-dark); }

/* Ensure base text is light for dark sidebar background */
.sidebar-text-color { color: #e5e7eb; /* gray-200 */ }
.sidebar-hover-color:hover { color: #ffffff; }
.sidebar-border-color { border-color: #374151; /* Dark gray for subtle borders */ }

/* Dropdown styling for smooth animation */
.dropdown-content {
    transition: max-height 0.3s ease;
    max-height: 0;
    overflow: hidden;
}
</style>

<button id="mobile-menu-button" class="lg:hidden fixed top-4 left-4 z-50 bg-zedbank-blue text-white p-3 rounded-lg shadow-lg hover:bg-zedbank-blue-dark">
    <i class="fas fa-bars"></i>
</button>

<div id="sidebar" class="fixed inset-y-0 left-0 z-40 w-64 bg-zedbank-blue shadow-xl transform -translate-x-full lg:translate-x-0 transition-transform duration-300">
    <div class="p-6 border-b border-zedbank-blue-dark">
        <div class="flex items-center space-x-3">
            <div class="w-10 h-10 bg-zedbank-blue-dark rounded-lg flex items-center justify-center">
                <i class="fas fa-hand-holding-usd text-white text-lg"></i>
            </div>
            <div>
                <h1 class="text-xl font-bold text-white">ZedBankOS</h1>
                <p class="text-gray-300 text-xs">Admin Portal</p>
            </div>
        </div>
    </div>
    
    <nav class="p-4 space-y-1 overflow-y-auto h-[calc(100vh-88px)]">
        <a href="<?php echo e(route('admin.accounting.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-tachometer-alt w-5"></i>
            <span>Dashboard</span>
        </a>
        
        <?php if(auth()->user()->hasAnyPermission(['customers.view', 'customers.create', 'customers.edit', 'poweruser'])): ?>
        <a href="<?php echo e(route('admin.customers.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.customers.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
          <i class="fas fa-users w-5"></i>
          <span>Customers</span>
        </a>
        <?php endif; ?>
        
        
        <div class="group quotations-menu">
            <button class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.quotations.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-calculator w-5"></i>
                    <span>Loan Quotations</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-300 quotations-menu-arrow"></i>
            </button>
            <div class="ml-8 mt-2 space-y-2 dropdown-content quotations-submenu">
                
                <a href="<?php echo e(route('admin.quotations.schedule')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.quotations.schedule') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                   <i class="fas fa-table w-4"></i>
                   <span>Quotation Schedule</span>
                </a>
                <a href="<?php echo e(route('admin.quotations.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.quotations.index') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-save w-4"></i>
                    <span>Saved Quotations</span>
                </a>
                <a href="<?php echo e(route('admin.quotations.create')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.quotations.create') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-plus-circle w-4"></i>
                    <span>New Quotation</span>
                </a>
                
            </div>
        </div>
        
        <?php if(auth()->user()->hasAnyPermission(['applications.view', 'applications.approve', 'applications.create', 'poweruser'])): ?>
      <div class="group applications-menu">
    <button class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.applications.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
        <div class="flex items-center space-x-3">
            <i class="fas fa-file-invoice-dollar w-5"></i>
            <span>Applications</span>
        </div>
        <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-300 applications-menu-arrow"></i>
    </button>
    <div class="ml-8 mt-2 space-y-2 dropdown-content applications-submenu">
        
         <?php if(auth()->user()->hasPermission('applications.create')): ?>
        <a href="<?php echo e(route('admin.applications.create')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.create') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-plus-circle w-4"></i>
            <span>New Application</span>
        </a>
        <?php endif; ?>
        
        <a href="<?php echo e(route('admin.applications.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.index') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
           <i class="fas fa-list w-4"></i>
           <span>All Applications</span>
        </a>
        
        <a href="<?php echo e(route('admin.applications.draft')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.index') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-list w-4"></i>
            <span>Requests In Draft</span>
            <?php if(isset($stats['pending_applications']) && $stats['pending_applications'] > 0): ?>
            <span class="ml-auto bg-red-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['pending_applications']); ?></span>
            <?php endif; ?>
        </a>
        
        <!-- NEW: Requests Submitted -->
        <a href="<?php echo e(route('admin.applications.pending')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.pending') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-paper-plane w-4"></i>
            <span>Requests Submitted</span>
            <?php if(isset($stats['pending_submitted_count']) && $stats['pending_submitted_count'] > 0): ?>
            <span class="ml-auto bg-blue-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['pending_submitted_count']); ?></span>
            <?php endif; ?>
        </a>
        
        <!-- NEW: Requests Approved -->
        <a href="<?php echo e(route('admin.applications.approved')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.approved') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-check-circle w-4"></i>
            <span>Requests Approved</span>
            <?php if(isset($stats['approved_applications']) && $stats['approved_applications'] > 0): ?>
            <span class="ml-auto bg-green-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['approved_applications']); ?></span>
            <?php endif; ?>
        </a>
        
        <a href="<?php echo e(route('admin.applications.rejected')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.rejected') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-times-circle w-4"></i>
            <span>Requests Rejected</span>
            <?php if(isset($stats['rejected_applications']) && $stats['rejected_applications'] > 0): ?>
            <span class="ml-auto bg-red-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['rejected_applications']); ?></span>
            <?php endif; ?>
        </a>
        
        <a href="<?php echo e(route('admin.applications.disbursed')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.applications.disbursed') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-money-check-alt w-4"></i>
            <span>Disbursed</span>
            <?php if(isset($stats['disbursed_applications']) && $stats['disbursed_applications'] > 0): ?>
            <span class="ml-auto bg-purple-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['disbursed_applications']); ?></span>
            <?php endif; ?>
        </a>
        
        
        
       
    </div>
</div>
<?php endif; ?>
  
        
        <?php if(auth()->user()->hasAnyPermission(['loans.view', 'poweruser'])): ?>
        <div class="group loans-menu">
            <button class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.loans.*') && !request()->routeIs('admin.accounting.offers.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-hand-holding-usd w-5"></i>
                    <span>Loans</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-300 loans-menu-arrow"></i>
            </button>
            <div class="ml-8 mt-2 space-y-2 dropdown-content loans-submenu">
                <a href="<?php echo e(route('admin.loans.active')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.loans.active') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-play-circle w-4"></i>
                    <span class="text-sm">Active Loans</span>
                    <?php if(isset($stats['active_loans'])): ?>
                    <span class="ml-auto bg-green-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['active_loans']); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.loans.closed')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.loans.closed') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-check-circle w-4"></i>
                    <span class="text-sm">Closed Loans</span>
                    <?php if(isset($stats['closed_loans'])): ?>
                    <span class="ml-auto bg-gray-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['closed_loans']); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.loans.non-performing')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.loans.non-performing') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-exclamation-triangle w-4"></i>
                    <span class="text-sm">Non-Performing</span>
                    <?php if(isset($stats['non_performing_loans']) && $stats['non_performing_loans'] > 0): ?>
                    <span class="ml-auto bg-red-500 text-white text-xs px-2 py-1 rounded-full"><?php echo e($stats['non_performing_loans']); ?></span>
                    <?php endif; ?>
                </a>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if(auth()->user()->hasAnyPermission(['collections.view', 'poweruser'])): ?>
        <a href="<?php echo e(route('admin.collections.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.collections.index') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-money-bill-wave w-5"></i>
            <span>Collections</span>
        </a>
        <?php endif; ?>
        
        <?php if(auth()->user()->hasPermission('poweruser')): ?>
        <a href="<?php echo e(route('admin.investments.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.investments.index') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-chart-line w-5"></i>
            <span>Investments</span>
        </a>
        <?php endif; ?>

        <a href="<?php echo e(route('admin.accounting.offers.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.accounting.offers.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
           <i class="fas fa-tags w-5"></i>
           <span class="text-sm font-medium">Loan Offers (Products)</span>
        </a>
        
        <a href="<?php echo e(route('admin.accounting.chart-of-accounts.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.accounting.chart-of-accounts.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-chart-pie w-5"></i>
            <span class="text-sm font-medium">Chart of Accounts</span>
        </a>
        
        <div class="group cash-banking-menu">
            <button type="button" class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium cash-banking-menu-toggle <?php echo e(request()->routeIs('admin.accounting.cash-banking.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-wallet w-5"></i>
                    <span class="text-sm font-medium">Cash & Banking</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 cash-banking-menu-arrow"></i>
            </button>
            <div class="ml-8 mt-2 space-y-1 dropdown-content cash-banking-submenu">
                <a href="<?php echo e(route('admin.accounting.cash-banking.accounts.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.cash-banking.accounts.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-landmark w-4"></i>
                    <span>Cash & Bank Accounts</span>
                </a>
                <a href="<?php echo e(route('admin.accounting.cash-banking.cash-book.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg transition-colors text-sm <?php echo e(request()->routeIs('admin.accounting.cash-banking.cash-book.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-book w-4"></i>
                    <span>Transactions</span>
                </a>
                <a href="<?php echo e(route('admin.accounting.cash-banking.internal-transfers.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg transition-colors text-sm <?php echo e(request()->routeIs('admin.accounting.cash-banking.internal-transfers.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-exchange-alt w-4"></i>
                    <span>Internal Transfers</span>
                </a>
                <a href="<?php echo e(route('admin.accounting.cash-banking.petty-cash.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg transition-colors text-sm <?php echo e(request()->routeIs('admin.accounting.cash-banking.petty-cash.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-money-bill-wave w-4"></i>
                    <span>Petty Cash</span>
                </a>
            </div>
        </div>
        
        <div class="group expenses-menu">
            <button type="button" class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium expenses-menu-toggle <?php echo e(request()->routeIs('admin.accounting.expenses.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-money-bill-wave w-5"></i>
                    <span class="text-sm font-medium">Expenses</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 expenses-menu-arrow"></i>
            </button>
            
            <div class="ml-8 mt-2 space-y-1 dropdown-content expenses-submenu">
                <a href="<?php echo e(route('admin.accounting.expenses.transactions.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.expenses.transactions.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-exchange-alt w-4"></i>
                    <span>Transactions</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.expenses.vendors.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.expenses.vendors.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-users w-4"></i>
                    <span>Vendors</span>
                </a>
            </div>
        </div>
        
        <div class="group journal-entries-menu">
            <button type="button" class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium journal-menu-toggle <?php echo e(request()->routeIs('admin.accounting.journals.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-book w-5"></i>
                    <span class="text-sm font-medium">Journal Entries</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 journal-menu-arrow"></i>
                <?php if(isset($pendingJournalsCount) && $pendingJournalsCount > 0): ?>
                    <span class="bg-red-500 text-white text-xs px-2 py-1 rounded-full ml-2">
                        <?php echo e($pendingJournalsCount); ?>

                    </span>
                <?php endif; ?>
            </button>
            
            <div class="ml-8 mt-2 space-y-1 dropdown-content journal-submenu">
                <a href="<?php echo e(route('admin.accounting.journals.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.journals.index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-list w-4"></i>
                    <span>All Journals</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.journals.create')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.journals.create') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-plus w-4"></i>
                    <span>Create Journal</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.journals.approval-index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.journals.approval-index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-check-double w-4"></i>
                    <span>Approve Journals</span>
                    <?php if(isset($pendingJournalsCount) && $pendingJournalsCount > 0): ?>
                        <span class="bg-red-500 text-white text-xs px-1.5 py-0.5 rounded-full ml-auto">
                            <?php echo e($pendingJournalsCount); ?>

                        </span>
                    <?php endif; ?>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.journals.draft')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.journals.draft') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-edit w-4"></i>
                    <span>Draft Journals</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.journals.posted')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.journals.posted') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-paper-plane w-4"></i>
                    <span>Posted Journals</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.journals.cancelled')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.journals.cancelled') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-ban w-4"></i>
                    <span>Cancelled Journals</span>
                </a>
            </div>
        </div>
        
        <a href="<?php echo e(route('admin.accounting.receivables.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.accounting.receivables.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-hand-holding-usd w-5"></i>
            <span class="text-sm font-medium">Receivables</span>
        </a>
        
        <a href="<?php echo e(route('admin.accounting.payables.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.accounting.payables.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
            <i class="fas fa-file-invoice-dollar w-5"></i>
            <span class="text-sm font-medium">Payables</span>
        </a>
        
        <div class="group payroll-menu">
            <button type="button" class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium payroll-menu-toggle <?php echo e(request()->routeIs('admin.accounting.payroll.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-money-check-alt w-5"></i>
                    <span class="text-sm font-medium">Payroll</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 payroll-menu-arrow"></i>
                <?php
                    $payrollCounts = \App\Http\Controllers\Accounting\PayrollController::getPayrollMenuCounts();
                    $totalPending = $payrollCounts['pending_review_count'] + $payrollCounts['approved_pending_count'];
                ?>
                <?php if($totalPending > 0): ?>
                    <span class="bg-red-500 text-white text-xs px-2 py-1 rounded-full ml-2">
                        <?php echo e($totalPending); ?>

                    </span>
                <?php endif; ?>
            </button>
            
            <div class="ml-8 mt-2 space-y-1 dropdown-content payroll-submenu">
                <a href="<?php echo e(route('admin.accounting.payroll.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-tachometer-alt w-4"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.employees.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.employees.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-user-tie w-4"></i>
                    <span>Employees</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.earnings.types.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.earnings.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-money-bill-wave w-4"></i>
                    <span>Earnings Management</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.preparation.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.preparation.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-edit w-4"></i>
                    <span>Payroll Preparation</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.processing.index')); ?>?status=calculated" class="flex items-center justify-between p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->get('status') == 'calculated' ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-clock w-4 text-yellow-300"></i>
                        <span>Payroll Pending Review</span>
                    </div>
                    <?php if($payrollCounts['pending_review_count'] > 0): ?>
                        <span class="bg-yellow-500 text-white text-xs px-2 py-1 rounded-full">
                            <?php echo e($payrollCounts['pending_review_count']); ?>

                        </span>
                    <?php endif; ?>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.processing.index')); ?>?status=approved" class="flex items-center justify-between p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->get('status') == 'approved' ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-check-circle w-4 text-green-300"></i>
                        <span>Approved Payroll</span>
                    </div>
                    <?php if($payrollCounts['approved_pending_count'] > 0): ?>
                        <span class="bg-green-500 text-white text-xs px-2 py-1 rounded-full">
                            <?php echo e($payrollCounts['approved_pending_count']); ?>

                        </span>
                    <?php endif; ?>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.processing.index')); ?>?status=paid" class="flex items-center justify-between p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->get('status') == 'paid' ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-money-check-alt w-4 text-white"></i>
                        <span>Paid Payroll</span>
                    </div>
                    <?php if($payrollCounts['paid_recent_count'] > 0): ?>
                        <span class="bg-white text-zedbank-blue text-xs px-2 py-1 rounded-full">
                            <?php echo e($payrollCounts['paid_recent_count']); ?>

                        </span>
                    <?php endif; ?>
                </a>
                
                <div class="group leave-management-menu">
                    <button type="button" class="flex items-center justify-between w-full p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm leave-menu-toggle <?php echo e(request()->routeIs('admin.accounting.payroll.leave.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                        <div class="flex items-center space-x-3">
                            <i class="fas fa-calendar-alt w-4"></i>
                            <span class="text-sm">Leave Management</span>
                        </div>
                        <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 leave-menu-arrow"></i>
                        <?php
                            $pendingLeaveCount = \App\Http\Controllers\Accounting\LeaveController::getPendingCount();
                        ?>
                        <?php if($pendingLeaveCount > 0): ?>
                            <span class="bg-yellow-500 text-white text-xs px-1.5 py-0.5 rounded-full ml-1">
                                <?php echo e($pendingLeaveCount); ?>

                            </span>
                        <?php endif; ?>
                    </button>
                    
                    <div class="ml-6 mt-1 space-y-1 dropdown-content leave-submenu">
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-tachometer-alt w-3"></i>
                            <span>Dashboard</span>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.requests.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.requests.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-file-alt w-3"></i>
                            <span>Leave Requests</span>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.pending-review')); ?>" class="flex items-center justify-between p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.pending-review') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-clock w-3"></i>
                                <span>Pending Review</span>
                            </div>
                            <?php if($pendingLeaveCount > 0): ?>
                                <span class="bg-yellow-500 text-white text-xs px-1 py-0.5 rounded-full">
                                    <?php echo e($pendingLeaveCount); ?>

                                </span>
                            <?php endif; ?>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.approved-leave')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.approved-leave') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-check-circle w-3"></i>
                            <span>Approved Leave</span>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.taken-leaves')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.taken-leaves') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-calendar-check w-3"></i>
                            <span>Taken Leaves</span>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.balances.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.balances.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-balance-scale w-3"></i>
                            <span>Leave Balances</span>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.settings.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.settings.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-cog w-3"></i>
                            <span>Leave Settings</span>
                        </a>
                        
                        <a href="<?php echo e(route('admin.accounting.payroll.leave.reports.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-xs <?php echo e(request()->routeIs('admin.accounting.payroll.leave.reports.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                            <i class="fas fa-chart-bar w-3"></i>
                            <span>Reports</span>
                        </a>
                    </div>
                </div>
                
                <a href="<?php echo e(route('admin.accounting.payroll.reports.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.reports.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-chart-bar w-4"></i>
                    <span>Payroll Reports</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.paye.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.paye.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-percentage w-4"></i>
                    <span>PAYE Bands</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.napsa.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.napsa.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-shield-alt w-4"></i>
                    <span>NAPSA</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.nhima.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.nhima.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-heartbeat w-4"></i>
                    <span>NHIMA</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.payroll.periods.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.payroll.periods.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-calendar-alt w-4"></i>
                    <span>Payroll Periods</span>
                </a>
            </div>
        </div>
        
        <div class="group self-service-menu mt-6 pt-4 border-t border-zedbank-blue-dark">
            <button type="button" class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium self-service-menu-toggle <?php echo e(request()->routeIs('admin.accounting.self-service.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-user-circle w-5"></i>
                    <span class="text-sm font-medium">Self Service</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 self-service-menu-arrow"></i>
            </button>
            
            <div class="ml-8 mt-2 space-y-1 dropdown-content self-service-submenu">
                <a href="<?php echo e(route('admin.accounting.self-service.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.self-service.index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-tachometer-alt w-4"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.self-service.payrolls.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.self-service.payrolls.*') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-money-check-alt w-4"></i>
                    <span>My Payrolls</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.self-service.leave.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.self-service.leave.index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-calendar-plus w-4"></i>
                    <span>Leave Requests</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.self-service.approved-leave')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.self-service.approved-leave') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-calendar-check w-4"></i>
                    <span>Approved Leave</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.self-service.running-leave')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.self-service.running-leave') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-calendar-day w-4"></i>
                    <span>Running Leave</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.self-service.leave.create')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.self-service.leave.create') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-plus-circle w-4"></i>
                    <span>New Leave Request</span>
                </a>
            </div>
        </div>
        
        <div class="group reports-menu">
            <button type="button" class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium reports-menu-toggle <?php echo e(request()->routeIs('admin.accounting.reports.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-chart-bar w-5"></i>
                    <span class="text-sm font-medium">Financial Reports</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-200 reports-menu-arrow"></i>
            </button>
            
            <div class="ml-8 mt-2 space-y-1 dropdown-content reports-submenu">
                <a href="<?php echo e(route('admin.accounting.reports.index')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.reports.index') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-chart-line w-4"></i>
                    <span>Reports Dashboard</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.reports.trial-balance')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.reports.trial-balance') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-balance-scale w-4"></i>
                    <span>Trial Balance</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.reports.balance-sheet')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.reports.balance-sheet') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-file-invoice-dollar w-4"></i>
                    <span>Balance Sheet</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.reports.income-statement')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.reports.income-statement') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-chart-pie w-4"></i>
                    <span>Income Statement</span>
                </a>
                
                <a href="<?php echo e(route('admin.accounting.reports.general-ledger')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.accounting.reports.general-ledger') ? 'text-white bg-zedbank-blue-medium' : ''); ?>">
                    <i class="fas fa-book w-4"></i>
                    <span>General Ledger</span>
                </a>
            </div>
        </div>

        <?php if(auth()->user()->hasPermission('poweruser')): ?>
        <div class="group settings-menu pt-4 border-t border-zedbank-blue-dark">
            <button class="flex items-center justify-between w-full p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.settings.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-cog w-5"></i>
                    <span>Settings</span>
                </div>
                <i class="fas fa-chevron-down text-gray-300 text-xs transition-transform duration-300 settings-menu-arrow"></i>
            </button>
            <div class="ml-8 mt-2 space-y-2 dropdown-content settings-submenu">
                <a href="<?php echo e(route('admin.settings.branches')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.settings.branches') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-code-branch w-4"></i>
                    <span class="text-sm">Branches</span>
                </a>
                <a href="<?php echo e(route('admin.settings.users')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.settings.users') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-users w-4"></i>
                    <span class="text-sm">Users</span>
                </a>
                <a href="<?php echo e(route('admin.settings.permissions')); ?>" class="flex items-center space-x-3 p-2 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg text-sm <?php echo e(request()->routeIs('admin.settings.permissions') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                    <i class="fas fa-shield-alt w-4"></i>
                    <span class="text-sm">Permissions</span>
                </a>
            </div>
        </div>
        <?php endif; ?>

        <div class="mt-4 pt-4 border-t border-zedbank-blue-dark">
             <a href="<?php echo e(route('admin.accounting.company.index')); ?>" class="flex items-center space-x-3 p-3 sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark rounded-lg font-medium <?php echo e(request()->routeIs('admin.accounting.company.*') ? 'bg-zedbank-blue-medium text-white' : ''); ?>">
                <i class="fas fa-building w-5"></i>
                <span class="text-sm font-medium">Company Profile</span>
            </a>
        </div>
        
        <div class="pt-4 border-t border-zedbank-blue-dark">
            <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="flex items-center space-x-3 p-3 w-full sidebar-text-color sidebar-hover-color hover:bg-zedbank-blue-dark hover:text-red-300 rounded-lg font-medium">
                    <i class="fas fa-sign-out-alt w-5"></i>
                    <span>Logout</span>
                </button>
            </form>
        </div>
    </nav>
</div>

<div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 lg:hidden hidden"></div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // --- MOBILE/LAYOUT JS ---
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('-translate-x-full');
                sidebarOverlay.classList.toggle('hidden');
            });
            
            if (sidebarOverlay) {
                sidebarOverlay.addEventListener('click', function() {
                    sidebar.classList.add('-translate-x-full');
                    sidebarOverlay.classList.add('hidden');
                });
            }
        }
        
        // --- DROPDOWN JS ---
        
        // Setup function for smooth dropdown behavior
        function setupDropdown(toggleSelector, submenuSelector, arrowSelector) {
            const toggle = document.querySelector(toggleSelector);
            const submenu = document.querySelector(submenuSelector);
            const arrow = document.querySelector(arrowSelector);
            
            if (toggle && submenu) {
                
                const openDropdown = () => {
                    submenu.classList.add('open');
                    submenu.style.maxHeight = submenu.scrollHeight + 'px';
                    if (arrow) arrow.classList.add('rotate-180');
                };

                const closeDropdown = () => {
                    submenu.classList.remove('open');
                    submenu.style.maxHeight = '0';
                    if (arrow) arrow.classList.remove('rotate-180');
                };

                // Auto-open check on load
                const isActive = toggle.classList.contains('bg-zedbank-blue-medium');
                const hasActiveLink = submenu.querySelector('a.bg-zedbank-blue-medium');

                if (isActive || hasActiveLink) {
                    openDropdown();
                }

                toggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    const isOpen = submenu.classList.contains('open');
                    
                    // Close all other dropdowns
                    document.querySelectorAll('.dropdown-content.open').forEach(openDropdown => {
                        if (openDropdown !== submenu) {
                            openDropdown.classList.remove('open');
                            openDropdown.style.maxHeight = '0';
                            const openToggle = openDropdown.previousElementSibling;
                            const openArrow = openToggle ? openToggle.querySelector('.fa-chevron-down') : null;
                            if (openArrow) openArrow.classList.remove('rotate-180');
                        }
                    });

                    // Toggle current dropdown
                    if (isOpen) {
                        closeDropdown();
                    } else {
                        openDropdown();
                    }
                });
                
                // Recalculate max-height on window resize
                window.addEventListener('resize', () => {
                    if (submenu.classList.contains('open')) {
                        submenu.style.maxHeight = submenu.scrollHeight + 'px';
                    }
                });

                // Prevent dropdown close when clicking inside dropdown
                submenu.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
            }
        }
        
        // Setup all dropdowns
        // ADDED QUOTATIONS MENU HERE
        setupDropdown('.quotations-menu button', '.quotations-submenu', '.quotations-menu-arrow');
        setupDropdown('.applications-menu button', '.applications-submenu', '.applications-menu-arrow');
        setupDropdown('.loans-menu button', '.loans-submenu', '.loans-menu-arrow');
        setupDropdown('.cash-banking-menu-toggle', '.cash-banking-submenu', '.cash-banking-menu-arrow');
        setupDropdown('.expenses-menu-toggle', '.expenses-submenu', '.expenses-menu-arrow');
        setupDropdown('.journal-menu-toggle', '.journal-submenu', '.journal-menu-arrow');
        setupDropdown('.payroll-menu-toggle', '.payroll-submenu', '.payroll-menu-arrow');
        setupDropdown('.leave-menu-toggle', '.leave-submenu', '.leave-menu-arrow');
        setupDropdown('.reports-menu-toggle', '.reports-submenu', '.reports-menu-arrow');
        setupDropdown('.self-service-menu-toggle', '.self-service-submenu', '.self-service-menu-arrow');
        setupDropdown('.settings-menu button', '.settings-submenu', '.settings-menu-arrow');

        // Global click listener to close non-active dropdowns
        document.addEventListener('click', function(e) {
            document.querySelectorAll('.dropdown-content.open').forEach(dropdown => {
                // Find the parent button/toggle
                const toggle = dropdown.previousElementSibling;
                
                // Check if the link within the dropdown is the active route
                const isCurrentActive = dropdown.querySelector('a.bg-zedbank-blue-medium');
                
                // Only close if click is outside the dropdown AND the dropdown does not contain an active link.
                if (!e.target.closest('.group') && !e.target.closest('#sidebar') && !isCurrentActive) {
                    dropdown.classList.remove('open');
                    dropdown.style.maxHeight = '0';
                    const arrow = toggle ? toggle.querySelector('.fa-chevron-down') : null;
                    if (arrow) arrow.classList.remove('rotate-180');
                }
            });
        });
    });
</script><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/partials/sidebar.blade.php ENDPATH**/ ?>