<div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
    <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50 flex justify-between items-center">
        <div class="flex items-center gap-2">
            <i class="fas fa-history text-midnight"></i>
            <h3 class="text-lg font-bold text-gray-800">Communication History</h3>
        </div>
        <span class="text-[10px] bg-blue-50 text-midnight px-2 py-1 rounded font-black tracking-widest uppercase border border-blue-100">Chronological SMS Audit</span>
    </div>

    <div class="p-6 bg-slate-50/30">
        <div class="space-y-4">
            <?php
                // Fetch all messages sorted by latest first
                $allMessages = $customer->messages()->latest()->get();
            ?>

            <?php $__empty_1 = true; $__currentLoopData = $allMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="flex items-start gap-4 p-4 rounded-2xl bg-white border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 flex-shrink-0 flex flex-col items-center justify-center rounded-xl border border-gray-100 shadow-inner bg-gray-50">
                        <i class="fas <?php echo e(match($message->category) {
                            'Payment Reminder' => 'fa-file-invoice-dollar text-orange-500',
                            'Follow Up' => 'fa-sync text-blue-500',
                            'Document Requests' => 'fa-file-upload text-purple-500',
                            'Promotions' => 'fa-bullhorn text-pink-500',
                            default => 'fa-comment-alt text-gray-400'
                        }); ?> text-lg"></i>
                    </div>

                    <div class="flex-1">
                        <div class="flex justify-between items-start mb-2">
                            <div class="flex items-center gap-2">
                                <span class="px-2 py-0.5 rounded text-[9px] font-black uppercase tracking-wider bg-midnight text-white">
                                    <?php echo e($message->category); ?>

                                </span>
                                <span class="text-[9px] font-bold uppercase <?php echo e($message->status === 'sent' ? 'text-green-600' : 'text-red-600'); ?>">
                                    • <?php echo e($message->status === 'sent' ? 'Delivered' : 'Failed'); ?>

                                </span>
                            </div>
                            <span class="text-[10px] text-gray-400 font-bold uppercase tracking-tighter">
                                <?php echo e($message->created_at->format('d M Y • h:i A')); ?>

                            </span>
                        </div>

                        <p class="text-sm text-gray-700 leading-relaxed font-medium">
                            <?php echo e($message->message); ?>

                        </p>

                        <div class="mt-3 pt-3 border-t border-gray-50 flex items-center justify-between">
                            <div class="flex gap-4">
                                <span class="text-[10px] text-gray-500 font-bold uppercase tracking-widest">
                                    <i class="fas fa-mobile-alt mr-1"></i> <?php echo e($message->phone_number); ?>

                                </span>
                                <span class="text-[10px] text-gray-500 font-bold uppercase tracking-widest">
                                    <i class="fas fa-user-tie mr-1"></i> <?php echo e($message->sender->name ?? 'System'); ?>

                                </span>
                            </div>
                            <?php if($message->status !== 'sent'): ?>
                                <button onclick="openChatModal(<?php echo e($customer->id); ?>, '<?php echo e($customer->customer); ?>')" class="text-[9px] font-black uppercase text-midnight hover:underline decoration-2">
                                    Retry SMS
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="flex flex-col items-center justify-center py-20 opacity-40">
                    <div class="w-20 h-20 mb-4 bg-gray-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-comment-slash text-4xl text-gray-300"></i>
                    </div>
                    <p class="text-gray-500 text-xs font-bold uppercase tracking-widest">No communication history recorded</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/customers/partials/comm_logs_card.blade.php ENDPATH**/ ?>