<?php
    $pageTitle = 'Submitted Applications';
    $pageSubtitle = 'Applications submitted for review';
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --zedbank-blue: <?php echo e($themeBlue); ?>; --zedbank-blue-dark: <?php echo e($themeBlueDark); ?>; }
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="lg:ml-64 min-h-screen">
        <?php echo $__env->make('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                <div class="mb-6 flex items-center justify-between">
                    <a href="<?php echo e(route('admin.applications.index')); ?>" class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark font-medium">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Applications
                    </a>
                    <div class="text-sm text-gray-600">
                        <i class="fas fa-paper-plane text-blue-500 mr-1"></i>
                        <span class="font-semibold"><?php echo e($applications->total()); ?></span> submitted applications
                    </div>
                </div>

                <?php if($applications->isEmpty()): ?>
                    <div class="bg-white rounded-xl shadow-sm border p-8 text-center">
                        <div class="mx-auto w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-paper-plane text-blue-500 text-2xl"></i>
                        </div>
                        <h3 class="text-lg font-medium text-gray-900 mb-2">No Submitted Applications</h3>
                        <p class="text-gray-500">There are no submitted applications at the moment.</p>
                    </div>
                <?php else: ?>
                    <div class="bg-white rounded-xl shadow-sm border overflow-hidden">
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Application Details</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Loan Details</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted Date</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <?php $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="flex items-center">
                                                    <div class="flex-shrink-0 h-10 w-10 bg-blue-100 rounded-full flex items-center justify-center">
                                                        <i class="fas fa-paper-plane text-blue-600"></i>
                                                    </div>
                                                    <div class="ml-4">
                                                        <div class="text-sm font-medium text-gray-900"><?php echo e($application->application_number); ?></div>
                                                        <div class="text-sm text-gray-500"><?php echo e($application->product->product ?? 'N/A'); ?></div>
                                                        <div class="text-xs text-gray-400"><?php echo e($application->created_at->format('M d, Y')); ?></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900"><?php echo e($application->customer->first_name); ?> <?php echo e($application->customer->surname); ?></div>
                                                <div class="text-sm text-gray-500"><?php echo e($application->customer->customer_number); ?></div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900"><span class="font-medium"><?php echo e(number_format($application->loan_amount, 2)); ?></span> <?php echo e($application->currency->code ?? 'ZMW'); ?></div>
                                                <div class="text-sm text-gray-500"><?php echo e($application->loan_tenure); ?> <?php echo e($application->payment_frequency === 'monthly' ? 'Months' : 'Periods'); ?></div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900"><?php echo e($application->submitted_at ? $application->submitted_at->format('M d, Y H:i') : 'N/A'); ?></div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <div class="flex space-x-2">
                                                    <a href="<?php echo e(route('admin.applications.show', $application->id)); ?>" class="text-blue-600 hover:text-blue-900" title="View"><i class="fas fa-eye"></i></a>
                                                    <a href="<?php echo e(route('admin.applications.edit', $application->id)); ?>" class="text-green-600 hover:text-green-900" title="Edit"><i class="fas fa-edit"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6"><?php echo e($applications->links()); ?></div>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/applications/pending.blade.php ENDPATH**/ ?>